/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Font;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import org.omegat.gui.editor.EditorController;

public class Document3
extends DefaultStyledDocument {
    protected final EditorController controller;
    Position activeTranslationBeginM1;
    Position activeTranslationEndP1;
    protected boolean trustedChangesInProgress = false;

    public Document3(EditorController controller) {
        this.controller = controller;
    }

    protected int getTranslationStart() {
        return this.activeTranslationBeginM1.getOffset() + 1;
    }

    protected int getTranslationEnd() {
        return this.activeTranslationEndP1.getOffset() - 1;
    }

    public Font getFont(AttributeSet attr) {
        if (!StyleConstants.isBold(attr) && !StyleConstants.isItalic(attr)) {
            return this.controller.font;
        }
        if (StyleConstants.isBold(attr) && !StyleConstants.isItalic(attr)) {
            return this.controller.fontb;
        }
        if (!StyleConstants.isBold(attr) && StyleConstants.isItalic(attr)) {
            return this.controller.fonti;
        }
        if (StyleConstants.isBold(attr) && StyleConstants.isItalic(attr)) {
            return this.controller.fontbi;
        }
        return null;
    }

    boolean isEditMode() {
        return this.activeTranslationBeginM1 != null && this.activeTranslationEndP1 != null;
    }

    void stopEditMode() {
        this.activeTranslationBeginM1 = null;
        this.activeTranslationEndP1 = null;
    }

    String extractTranslation() {
        if (!this.isEditMode()) {
            return null;
        }
        int start = this.getTranslationStart();
        int end = this.getTranslationEnd();
        try {
            return this.getText(start, end - start);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAlignment(int beginOffset, int endOffset, boolean isRightAlignment) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, beginOffset, endOffset - beginOffset, DocumentEvent.EventType.CHANGE);
            Element root = this.getDefaultRootElement();
            int parBeg = root.getElementIndex(beginOffset);
            int parEnd = root.getElementIndex(endOffset - 1);
            for (int par = parBeg; par <= parEnd; ++par) {
                Element el = root.getElement(par);
                MutableAttributeSet attr = (MutableAttributeSet)el.getAttributes();
                attr.addAttribute(StyleConstants.Alignment, isRightAlignment ? 2 : 0);
            }
            changes.end();
            this.fireChangedUpdate(changes);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ORIENTATION {
        ALL_LTR,
        ALL_RTL,
        DIFFER;

    }
}

