/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public class TagValidationOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JButton cancelButton;
    private JTextField customPatternRegExpTF;
    private JTextArea descriptionTextArea;
    private JRadioButton fullCheckRadio;
    private JLabel jLabelCustomPattern;
    private JLabel jLabelRemovePattern;
    private JCheckBox javaPatternCheckBox;
    private JCheckBox looseTagOrderCheckBox;
    private JTextArea looseTagOrderWarningTextArea;
    private JRadioButton noCheckRadio;
    private JButton okButton;
    private ButtonGroup ourButtonGroup;
    private JTextField removePatternRegExpTF;
    private JRadioButton simpleCheckRadio;
    private int returnStatus = 0;

    public TagValidationOptionsDialog(Frame parent) {
        super(parent, true);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TagValidationOptionsDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.noCheckRadio.setSelected(Preferences.isPreference("tagValidation_noCheck"));
        this.simpleCheckRadio.setSelected(Preferences.isPreference("tagValidation_simpleCheck"));
        this.fullCheckRadio.setSelected(Preferences.isPreference("tagValidation_elaborateCheck"));
        this.javaPatternCheckBox.setSelected(Preferences.isPreference("tagValidation_javaMessageFormatSimplePatternCheck"));
        this.customPatternRegExpTF.setText(Preferences.getPreferenceDefaultAllowEmptyString("tagValidation_customPattern"));
        this.removePatternRegExpTF.setText(Preferences.getPreferenceDefaultAllowEmptyString("tagValidation_removePattern"));
        this.looseTagOrderCheckBox.setSelected(Preferences.isPreference("loose_tag_ordering"));
        this.invalidate();
        this.pack();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.ourButtonGroup = new ButtonGroup();
        this.descriptionTextArea = new JTextArea();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.noCheckRadio = new JRadioButton();
        this.simpleCheckRadio = new JRadioButton();
        this.fullCheckRadio = new JRadioButton();
        this.javaPatternCheckBox = new JCheckBox();
        this.jLabelCustomPattern = new JLabel();
        this.customPatternRegExpTF = new JTextField();
        this.jLabelRemovePattern = new JLabel();
        this.removePatternRegExpTF = new JTextField();
        this.looseTagOrderCheckBox = new JCheckBox();
        this.looseTagOrderWarningTextArea = new JTextArea();
        this.setTitle(OStrings.getString("GUI_TITLE_TagValidation_Options"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TagValidationOptionsDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.descriptionTextArea.setFont(new JLabel().getFont());
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(OStrings.getString("GUI_TAGVALIDATION_DESCRIPTION"));
        this.descriptionTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.descriptionTextArea, gridBagConstraints);
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagValidationOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 4, 4);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagValidationOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 4, 4);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.ourButtonGroup.add(this.noCheckRadio);
        this.noCheckRadio.setSelected(true);
        Mnemonics.setLocalizedText(this.noCheckRadio, OStrings.getString("TV_OPTION_NO_CHECK"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 4);
        this.getContentPane().add((Component)this.noCheckRadio, gridBagConstraints);
        this.ourButtonGroup.add(this.simpleCheckRadio);
        Mnemonics.setLocalizedText(this.simpleCheckRadio, OStrings.getString("TV_OPTION_SIMPLE_CHECK"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 4);
        this.getContentPane().add((Component)this.simpleCheckRadio, gridBagConstraints);
        this.ourButtonGroup.add(this.fullCheckRadio);
        Mnemonics.setLocalizedText(this.fullCheckRadio, OStrings.getString("TV_OPTION_FULL_CHECK"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 4, 4);
        this.getContentPane().add((Component)this.fullCheckRadio, gridBagConstraints);
        Mnemonics.setLocalizedText(this.javaPatternCheckBox, OStrings.getString("TV_OPTION_JAVA_PATTERN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.getContentPane().add((Component)this.javaPatternCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText(this.jLabelCustomPattern, OStrings.getString("TV_OPTION_CUSTOMPATTERN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 4);
        this.getContentPane().add((Component)this.jLabelCustomPattern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.getContentPane().add((Component)this.customPatternRegExpTF, gridBagConstraints);
        Mnemonics.setLocalizedText(this.jLabelRemovePattern, OStrings.getString("TV_OPTION_REMOVEPATTERN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 4);
        this.getContentPane().add((Component)this.jLabelRemovePattern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.getContentPane().add((Component)this.removePatternRegExpTF, gridBagConstraints);
        Mnemonics.setLocalizedText(this.looseTagOrderCheckBox, OStrings.getString("TV_OPTION_LOOSE_TAG_ORDER"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 4);
        this.getContentPane().add((Component)this.looseTagOrderCheckBox, gridBagConstraints);
        this.looseTagOrderWarningTextArea.setEditable(false);
        this.looseTagOrderWarningTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.looseTagOrderWarningTextArea.setFont(new JLabel().getFont());
        this.looseTagOrderWarningTextArea.setLineWrap(true);
        this.looseTagOrderWarningTextArea.setText(OStrings.getString("TV_OPTION_LOOSE_TAG_WARNING"));
        this.looseTagOrderWarningTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 24, 4, 24);
        this.getContentPane().add((Component)this.looseTagOrderWarningTextArea, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private boolean checkRegExp(JTextField textfield) {
        try {
            Pattern.compile(textfield.getText());
        }
        catch (PatternSyntaxException e) {
            textfield.setCaretPosition(e.getIndex());
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), OStrings.getString("TV_OPTION_ERROR_CUSTOMREGEXP_TITLE"), 0);
            textfield.grabFocus();
            return false;
        }
        return true;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.checkRegExp(this.customPatternRegExpTF) && this.checkRegExp(this.removePatternRegExpTF)) {
            Preferences.setPreference("tagValidation_noCheck", this.noCheckRadio.isSelected());
            Preferences.setPreference("tagValidation_simpleCheck", this.simpleCheckRadio.isSelected());
            Preferences.setPreference("tagValidation_elaborateCheck", this.fullCheckRadio.isSelected());
            Preferences.setPreference("tagValidation_javaMessageFormatSimplePatternCheck", this.javaPatternCheckBox.isSelected());
            Preferences.setPreference("tagValidation_customPattern", this.customPatternRegExpTF.getText());
            Preferences.setPreference("tagValidation_removePattern", this.removePatternRegExpTF.getText());
            Preferences.setPreference("loose_tag_ordering", this.looseTagOrderCheckBox.isSelected());
            PatternConsts.updatePlaceholderPattern();
            PatternConsts.updateRemovePattern();
            this.doClose(1);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

