/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.omegat.gui.matches.MatchesVarExpansion;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public class ExternalTMXMatchesDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JButton cancelButton;
    private JTextArea descriptionTextArea;
    private JCheckBox displayLevel2Tags;
    private JButton insertButton;
    private JScrollPane jScrollPane1;
    private JTextArea matchesTemplate;
    private JButton okButton;
    private JLabel templateLabel;
    private JCheckBox useSlash;
    private JLabel variablesLabel;
    private JComboBox variablesList;
    private int returnStatus = 0;

    public ExternalTMXMatchesDialog(Frame parent) {
        super(parent, true);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ExternalTMXMatchesDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.displayLevel2Tags.setSelected(Preferences.isPreference("ext_tmx_show_level2"));
        this.useSlash.setSelected(Preferences.isPreference("ext_tmx_use_slash"));
        this.matchesTemplate.setText(Preferences.getPreferenceDefault("ext_tmx_match_template", "${id}) ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}/${noStemScore}/${adjustedScore}% ${filePath}>"));
        this.matchesTemplate.setCaretPosition(0);
        this.invalidate();
        this.pack();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.descriptionTextArea = new JTextArea();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.displayLevel2Tags = new JCheckBox();
        this.useSlash = new JCheckBox();
        this.templateLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.matchesTemplate = new JTextArea();
        this.variablesLabel = new JLabel();
        this.variablesList = new JComboBox();
        this.insertButton = new JButton();
        this.setTitle(OStrings.getString("EXT_TMX_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ExternalTMXMatchesDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.descriptionTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(new JLabel().getFont());
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(OStrings.getString("EXT_TMX_DESCRIPTION"));
        this.descriptionTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.descriptionTextArea, gridBagConstraints);
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExternalTMXMatchesDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 4, 4);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExternalTMXMatchesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 4, 4);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.displayLevel2Tags.setSelected(true);
        Mnemonics.setLocalizedText(this.displayLevel2Tags, OStrings.getString("EXT_TMX_SHOW_LEVEL2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.displayLevel2Tags, gridBagConstraints);
        this.useSlash.setSelected(true);
        Mnemonics.setLocalizedText(this.useSlash, OStrings.getString("EXT_TMX_USE_XML"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.useSlash, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/omegat/Bundle");
        Mnemonics.setLocalizedText(this.templateLabel, bundle.getString("EXT_TMX_MATCHES_TEMPLATE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.templateLabel, gridBagConstraints);
        this.jScrollPane1.setCursor(new Cursor(0));
        this.jScrollPane1.setMinimumSize(new Dimension(525, 25));
        this.jScrollPane1.setPreferredSize(new Dimension(446, 96));
        this.matchesTemplate.setColumns(30);
        this.matchesTemplate.setRows(5);
        this.jScrollPane1.setViewportView(this.matchesTemplate);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText(this.variablesLabel, bundle.getString("EXT_TMX_MATCHES_TEMPLATE_VARIABLES"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.variablesLabel, gridBagConstraints);
        this.variablesList.setModel(new DefaultComboBoxModel<String>(MatchesVarExpansion.MATCHES_VARIABLES));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.variablesList, gridBagConstraints);
        Mnemonics.setLocalizedText(this.insertButton, bundle.getString("BUTTON_INSERT"));
        this.insertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExternalTMXMatchesDialog.this.insertButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.insertButton, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        this.matchesTemplate.insert(this.variablesList.getSelectedItem().toString(), this.matchesTemplate.getCaretPosition());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Preferences.setPreference("ext_tmx_show_level2", this.displayLevel2Tags.isSelected());
        Preferences.setPreference("ext_tmx_use_slash", this.useSlash.isSelected());
        Preferences.setPreference("ext_tmx_match_template", this.matchesTemplate.getText());
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

