/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.omegat.core.spellchecker.DictionaryManager;
import org.omegat.gui.dialogs.SpellcheckerConfigurationDialog;
import org.omegat.util.OStrings;
import org.openide.awt.Mnemonics;

public class DictionaryInstallerDialog
extends JDialog {
    private DictionaryManager dicMan;
    private DefaultListModel listModel;
    private JButton closeButton;
    private JList dictionaryList;
    private JTextArea infoTextArea;
    private JButton installButton;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel listLabel;

    public DictionaryInstallerDialog(JDialog parent, DictionaryManager dicMan) throws IOException {
        super((Dialog)parent, true);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DictionaryInstallerDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.dicMan = dicMan;
        this.initComponents();
        this.UiInitComponents();
        List<String> list = dicMan.getInstallableDictionaryNameList();
        this.listModel = new DefaultListModel();
        for (String str : list) {
            this.listModel.addElement(str);
        }
        this.dictionaryList.setModel(this.listModel);
        this.dictionaryList.setEnabled(true);
        if (!list.isEmpty()) {
            this.installButton.setEnabled(true);
            this.infoTextArea.setText(OStrings.getString("GUI_DICTIONARY_INSTALLER_TEXT_GO"));
        } else {
            this.installButton.setEnabled(false);
            this.infoTextArea.setText(OStrings.getString("GUI_DICTIONARY_INSTALLER_TEXT_NOTHING"));
        }
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.dictionaryList = new JList();
        this.closeButton = new JButton();
        this.installButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.infoTextArea = new JTextArea();
        this.listLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("GUI_DICTIONARY_INSTALLER_TITLE"));
        this.jScrollPane2.setViewportView(this.dictionaryList);
        Mnemonics.setLocalizedText(this.closeButton, OStrings.getString("BUTTON_CLOSE"));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DictionaryInstallerDialog.this.closeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.installButton, OStrings.getString("GUI_DICTIONARY_INSTALLER_INSTALL"));
        this.installButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DictionaryInstallerDialog.this.installButtonActionPerformed(evt);
            }
        });
        this.infoTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.infoTextArea.setColumns(20);
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setFont(new Font("Dialog", 1, 12));
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setRows(5);
        this.infoTextArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.infoTextArea);
        Mnemonics.setLocalizedText(this.listLabel, OStrings.getString("GUI_DICTIONARY_INSTALLER_AVAILABLE"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.listLabel).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane2, -1, 304, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.installButton, -1, -1, Short.MAX_VALUE).add((Component)this.closeButton, -1, 84, Short.MAX_VALUE))).add((Component)this.jScrollPane1, -1, 394, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, -1, -2).add(9, 9, 9).add((Component)this.listLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.installButton).addPreferredGap(0, 125, Short.MAX_VALUE).add((Component)this.closeButton)).add((Component)this.jScrollPane2, -1, 171, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.getCursor();
        this.setCursor(hourglassCursor);
        Object[] selection = this.dictionaryList.getSelectedValues();
        for (int i = 0; i < selection.length; ++i) {
            String item = (String)selection[i];
            String langCode = item.substring(0, item.indexOf(" "));
            try {
                this.dicMan.installRemoteDictionary(langCode);
                ((SpellcheckerConfigurationDialog)this.getParent()).updateLanguageList();
                continue;
            }
            catch (MalformedURLException ex) {
                this.setCursor(oldCursor);
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), "Error", 0);
                this.setCursor(hourglassCursor);
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.setCursor(oldCursor);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void UiInitComponents() {
        this.installButton.setEnabled(false);
        this.dictionaryList.setEnabled(false);
    }
}

