/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.common;

import javax.swing.SwingUtilities;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntryInfoSearchThread<T>
extends Thread {
    private final EntryInfoThreadPane<T> pane;
    private final SourceTextEntry currentlyProcessedEntry;

    public EntryInfoSearchThread(EntryInfoThreadPane<T> pane, SourceTextEntry entry) {
        this.pane = pane;
        this.currentlyProcessedEntry = entry;
    }

    private boolean isEntryChanged() {
        return this.currentlyProcessedEntry != this.pane.currentlyProcessedEntry;
    }

    protected void checkEntryChanged() throws EntryChangedException {
        if (this.isEntryChanged()) {
            throw new EntryChangedException();
        }
    }

    @Override
    public void run() {
        if (this.isEntryChanged()) {
            return;
        }
        Object result = null;
        Exception error = null;
        try {
            result = this.search();
        }
        catch (EntryChangedException ex) {
            return;
        }
        catch (Exception ex) {
            error = ex;
            Log.log(ex);
        }
        if (this.isEntryChanged()) {
            return;
        }
        final Object fresult = result;
        final Exception ferror = error;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (EntryInfoSearchThread.this.isEntryChanged()) {
                    return;
                }
                if (ferror != null) {
                    EntryInfoSearchThread.this.pane.setError(ferror);
                } else {
                    EntryInfoSearchThread.this.pane.setFoundResult(EntryInfoSearchThread.this.currentlyProcessedEntry, fresult);
                }
            }
        });
    }

    protected abstract T search() throws EntryChangedException, Exception;

    public static class EntryChangedException
    extends RuntimeException {
    }
}

