/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.resx;

import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.XMLFilter;
import org.omegat.filters3.xml.resx.ResXDialect;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.xml.sax.Attributes;

public class ResXFilter
extends XMLFilter {
    private String id = "";
    private String entryText;
    private String comment;
    private String text;

    public ResXFilter() {
        super(new ResXDialect());
    }

    public String getFileFormatName() {
        return OStrings.getString("RESX_FILTER_NAME");
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.??-??.resx", null, null, "${nameOnly}.${targetLocaleLCID}.resx"), new Instance("*.??.resx", null, null, "${nameOnly}.${targetLocaleLCID}.resx"), new Instance("*.resx", null, null, "${nameOnly}.${targetLocaleLCID}.resx")};
    }

    public boolean isSourceEncodingVariable() {
        return false;
    }

    public boolean isTargetEncodingVariable() {
        return true;
    }

    public void tagStart(String path, Attributes atts) {
        if ("/root/data".equals(path)) {
            this.id = StringUtil.nvl(atts.getValue("name"), "");
            this.comment = null;
        }
    }

    public void tagEnd(String path) {
        if ("/root/data/comment".equals(path)) {
            this.comment = this.text;
        } else if ("/root/data".equals(path)) {
            if (this.entryParseCallback != null) {
                this.entryParseCallback.addEntry(this.id, this.entryText, null, false, this.comment, null, this);
            }
            this.id = null;
            this.entryText = null;
            this.comment = null;
        }
    }

    public void text(String text) {
        this.text = text;
    }

    public String translate(String entry) {
        if (this.entryParseCallback != null) {
            this.entryText = entry;
            return entry;
        }
        String trans = this.entryTranslateCallback.getTranslation(this.id, entry, null);
        return trans != null ? trans : entry;
    }
}

