/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.openxml;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.xml.openxml.EditOpenXMLOptionsDialog;
import org.omegat.filters3.xml.openxml.OpenXMLDialect;
import org.omegat.filters3.xml.openxml.OpenXMLOptions;
import org.omegat.filters3.xml.openxml.OpenXMLXMLFilter;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenXMLFilter
extends AbstractFilter {
    private String DOCUMENTS;
    private Pattern TRANSLATABLE;
    private static final Pattern DIGITS = Pattern.compile("(\\d+)\\.xml");
    OpenXMLXMLFilter xmlfilter = null;

    private void defineDOCUMENTSOptions(Map<String, String> config) {
        this.DOCUMENTS = "(document\\.xml)";
        OpenXMLOptions options = new OpenXMLOptions(config);
        if (options.getTranslateComments()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(comments\\.xml)";
        }
        if (options.getTranslateFootnotes()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(footnotes\\.xml)";
        }
        if (options.getTranslateEndnotes()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(endnotes\\.xml)";
        }
        if (options.getTranslateHeaders()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(header\\d+\\.xml)";
        }
        if (options.getTranslateFooters()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(footer\\d+\\.xml)";
        }
        this.DOCUMENTS = this.DOCUMENTS + "|(sharedStrings\\.xml)";
        if (options.getTranslateExcelComments()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(comments\\d+\\.xml)";
        }
        this.DOCUMENTS = this.DOCUMENTS + "|(slide\\d+\\.xml)";
        if (options.getTranslateSlideMasters()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(slideMaster\\d+\\.xml)";
        }
        if (options.getTranslateSlideLayouts()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(slideLayout\\d+\\.xml)";
        }
        if (options.getTranslateSlideComments()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(notesSlide\\d+\\.xml)";
        }
        if (options.getTranslateDiagrams()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(data\\d+\\.xml)";
        }
        if (options.getTranslateCharts()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(chart\\d+\\.xml)";
        }
        if (options.getTranslateDrawings()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(drawing\\d+\\.xml)";
        }
        if (options.getTranslateSheetNames()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(workbook\\.xml)";
        }
        this.TRANSLATABLE = Pattern.compile(this.DOCUMENTS);
    }

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext fc) {
        try {
            this.defineDOCUMENTSOptions(config);
            ZipFile file = new ZipFile(inFile);
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String shortname = entry.getName();
                Matcher filematch = this.TRANSLATABLE.matcher(shortname = this.removePath(shortname));
                if (!filematch.matches()) continue;
                file.close();
                return true;
            }
            file.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    private OpenXMLXMLFilter createXMLFilter() {
        this.xmlfilter = new OpenXMLXMLFilter();
        this.xmlfilter.setCallbacks(this.entryParseCallback, this.entryTranslateCallback);
        OpenXMLDialect dialect = (OpenXMLDialect)this.xmlfilter.getDialect();
        dialect.defineDialect(new OpenXMLOptions(this.processOptions));
        return this.xmlfilter;
    }

    private File tmp() throws IOException {
        return File.createTempFile("o-xml-temp", ".xml");
    }

    private String removePath(String fileName) {
        if (fileName.lastIndexOf(47) >= 0) {
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        } else if (fileName.lastIndexOf(92) >= 0) {
            fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
        }
        return fileName;
    }

    private String removeXML(String fileName) {
        if (fileName.endsWith(".xml")) {
            fileName = fileName.substring(0, fileName.lastIndexOf(".xml"));
        }
        return fileName;
    }

    @Override
    public void processFile(File inFile, File outFile, FilterContext fc) throws IOException, TranslationException {
        this.defineDOCUMENTSOptions(this.processOptions);
        ZipFile zipfile = new ZipFile(inFile);
        ZipOutputStream zipout = null;
        if (outFile != null) {
            zipout = new ZipOutputStream(new FileOutputStream(outFile));
        }
        Enumeration<? extends ZipEntry> unsortedZipcontents = zipfile.entries();
        ArrayList<? extends ZipEntry> filelist = Collections.list(unsortedZipcontents);
        Collections.sort(filelist, new Comparator<ZipEntry>(){

            @Override
            public int compare(ZipEntry z1, ZipEntry z2) {
                int index2;
                String s1 = z1.getName();
                String s2 = z2.getName();
                String[] words1 = s1.split("\\d+\\.");
                String[] words2 = s2.split("\\d+\\.");
                if (words1.length > 1 && words2.length > 1 && words1[0].equals(words2[0])) {
                    int number1 = 0;
                    int number2 = 0;
                    Matcher getDigits = DIGITS.matcher(s1);
                    if (getDigits.find()) {
                        number1 = Integer.parseInt(getDigits.group(1));
                    }
                    if ((getDigits = DIGITS.matcher(s2)).find()) {
                        number2 = Integer.parseInt(getDigits.group(1));
                    }
                    if (number1 > number2) {
                        return 1;
                    }
                    if (number1 < number2) {
                        return -1;
                    }
                    return 0;
                }
                String shortname1 = OpenXMLFilter.this.removePath(words1[0]);
                shortname1 = OpenXMLFilter.this.removeXML(shortname1);
                String shortname2 = OpenXMLFilter.this.removePath(words2[0]);
                shortname2 = OpenXMLFilter.this.removeXML(shortname2);
                if (shortname1.indexOf("sharedStrings") >= 0 || shortname2.indexOf("sharedStrings") >= 0) {
                    if (shortname2.indexOf("sharedStrings") >= 0) {
                        return 1;
                    }
                    return -1;
                }
                int index1 = OpenXMLFilter.this.DOCUMENTS.indexOf(shortname1);
                if (index1 > (index2 = OpenXMLFilter.this.DOCUMENTS.indexOf(shortname2))) {
                    return 1;
                }
                if (index1 < index2) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
        });
        Enumeration<? extends ZipEntry> zipcontents = Collections.enumeration(filelist);
        while (zipcontents.hasMoreElements()) {
            ZipEntry zipentry = zipcontents.nextElement();
            String shortname = zipentry.getName();
            Matcher filematch = this.TRANSLATABLE.matcher(shortname = this.removePath(shortname));
            if (filematch.matches()) {
                File tmpin = this.tmp();
                LFileCopy.copy(zipfile.getInputStream(zipentry), tmpin);
                File tmpout = null;
                if (zipout != null) {
                    tmpout = this.tmp();
                }
                try {
                    this.createXMLFilter().processFile(tmpin, tmpout, fc);
                }
                catch (Exception e) {
                    zipfile.close();
                    e.printStackTrace();
                    throw new TranslationException(e.getLocalizedMessage() + "\n" + OStrings.getString("OpenXML_ERROR_IN_FILE") + inFile, e);
                }
                if (zipout != null) {
                    ZipEntry outEntry = new ZipEntry(zipentry.getName());
                    zipout.putNextEntry(outEntry);
                    LFileCopy.copy(tmpout, (OutputStream)zipout);
                    zipout.closeEntry();
                }
                if (!tmpin.delete()) {
                    tmpin.deleteOnExit();
                }
                if (tmpout == null || tmpout.delete()) continue;
                tmpout.deleteOnExit();
                continue;
            }
            if (zipout == null) continue;
            ZipEntry outEntry = new ZipEntry(zipentry.getName());
            zipout.putNextEntry(outEntry);
            LFileCopy.copy(zipfile.getInputStream(zipentry), (OutputStream)zipout);
            zipout.closeEntry();
        }
        if (zipout != null) {
            zipout.close();
        }
        zipfile.close();
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("OpenXML_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.doc?"), new Instance("*.dotx"), new Instance("*.xls?"), new Instance("*.ppt?")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return false;
    }

    @Override
    protected void processFile(BufferedReader inFile, BufferedWriter outFile, FilterContext fc) throws IOException, TranslationException {
        throw new IOException("Not Implemented!");
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    @Override
    public Map<String, String> changeOptions(Dialog parent, Map<String, String> currentOptions) {
        try {
            EditOpenXMLOptionsDialog dialog = new EditOpenXMLOptionsDialog(parent, currentOptions);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions().getOptionsMap();
            }
            return null;
        }
        catch (Exception e) {
            Log.logErrorRB("HTML_EXC_EDIT_OPTIONS", new Object[0]);
            Log.log(e);
            return null;
        }
    }

    @Override
    public String getInEncodingLastParsedFile() {
        return "OpenXML";
    }
}

