/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.android;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.XMLFilter;
import org.omegat.filters3.xml.android.AndroidDialect;
import org.omegat.util.OStrings;
import org.xml.sax.Attributes;

public class AndroidFilter
extends XMLFilter {
    static final String DO_NOT_TRANSLATE = "Do not translate";
    static Set<String> NAMED_TAGS = new HashSet<String>(Arrays.asList("/resources/string", "/resources/color", "/resources/array", "/resources/string-array", "/resources/integer-array"));
    private String id;
    private String idPlurals = "";
    private String comment;
    private String idComment;

    public AndroidFilter() {
        super(new AndroidDialect());
    }

    public String getFileFormatName() {
        return OStrings.getString("Android_FILTER_NAME");
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.xml")};
    }

    public boolean isSourceEncodingVariable() {
        return false;
    }

    public boolean isTargetEncodingVariable() {
        return false;
    }

    public void tagStart(String path, Attributes atts) {
        if (atts != null) {
            if (NAMED_TAGS.contains(path)) {
                this.id = atts.getValue("name");
                this.idComment = this.comment;
            } else if ("/resources/plurals".equals(path)) {
                this.idPlurals = atts.getValue("name");
            } else if ("/resources/plurals/item".equals(path)) {
                this.id = this.idPlurals + '/' + atts.getValue("quantity");
                this.idComment = this.comment;
            }
        }
    }

    public void tagEnd(String path) {
        this.comment = null;
        if ("/resources/string".equals(path)) {
            this.idComment = null;
        } else if ("/resources/plurals/item".equals(path)) {
            this.idComment = null;
        }
    }

    public void comment(String comment) {
        this.comment = comment;
    }

    public String translate(String entry) {
        if (this.idComment != null && this.idComment.contains(DO_NOT_TRANSLATE)) {
            return entry;
        }
        String e = entry.replace("\\'", "'");
        String r = null;
        if (this.entryParseCallback != null) {
            this.entryParseCallback.addEntry(this.id, e, null, false, this.idComment, null, this);
            r = e;
        } else if (this.entryTranslateCallback != null && (r = this.entryTranslateCallback.getTranslation(this.id, e, null)) == null) {
            r = e;
        }
        return r.replace("'", "\\'");
    }
}

