/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import org.omegat.filters3.Attribute;
import org.omegat.filters3.Tag;
import org.omegat.filters3.xml.XMLUtils;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.util.Language;
import org.xml.sax.Attributes;

public class XMLTag
extends Tag {
    private Language targetLanguage;

    public XMLTag(String tag, String shortcut, int type, Attributes attributes, Language targetLanguage) {
        super(tag, shortcut, type, XMLUtils.convertAttributes(attributes));
        this.targetLanguage = targetLanguage;
    }

    public String toOriginal() {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        if (2 == this.getType()) {
            buf.append("/");
        }
        buf.append(this.getTag());
        buf.append(this.getAttributes().toString());
        if (this.getTag().equalsIgnoreCase("w:t") && 1 == this.getType()) {
            Boolean preserve = false;
            for (int i = 0; i < this.getAttributes().size(); ++i) {
                Attribute oneAttribute = this.getAttributes().get(i);
                if (!oneAttribute.getName().equalsIgnoreCase("xml:space")) continue;
                preserve = true;
                break;
            }
            if (!preserve.booleanValue()) {
                buf.append(" xml:space=\"preserve\"");
            }
        }
        boolean alreadyClosed = false;
        if (EditorUtils.isRTL(this.targetLanguage.getLanguageCode())) {
            if (this.getTag().equalsIgnoreCase("w:pPr") && 1 == this.getType()) {
                buf.append("><w:bidi/");
            } else if (this.getTag().equalsIgnoreCase("w:sectPr") && 1 == this.getType()) {
                buf.append("><w:bidi/");
            } else if (this.getTag().equalsIgnoreCase("w:rPr") && 1 == this.getType()) {
                buf.append("><w:rtl/");
            } else if (this.getTag().equalsIgnoreCase("w:tblPr") && 1 == this.getType()) {
                buf.append("><w:bidiVisual/");
            } else if (this.getTag().equalsIgnoreCase("w:tblStyle") && 3 == this.getType()) {
                buf.append("/><w:bidiVisual/");
                alreadyClosed = true;
            }
        }
        if (3 == this.getType() && !alreadyClosed) {
            buf.append("/");
        }
        buf.append(">");
        return buf.toString();
    }
}

