/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import org.omegat.util.PatternConsts;

public class XMLReader
extends Reader {
    private BufferedReader reader;
    private String encoding;
    boolean readFirstTime = true;

    public String getEncoding() {
        return this.encoding;
    }

    public XMLReader(File file) throws IOException {
        this(file, null);
    }

    public XMLReader(File file, String encoding) throws IOException {
        this.reader = new BufferedReader(this.createReader(file, encoding));
    }

    private Reader createReader(File file, String defaultEncoding) throws IOException {
        String buffer;
        Matcher matcher_xml;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        is.mark(8192);
        int char1 = is.read();
        int char2 = is.read();
        int char3 = is.read();
        this.encoding = null;
        if (char1 == 254 && char2 == 255) {
            this.encoding = "UTF-16BE";
        }
        if (char1 == 255 && char2 == 254) {
            this.encoding = "UTF-16LE";
        }
        if (char1 == 239 && char2 == 187 && char3 == 191) {
            this.encoding = "UTF-8";
        }
        is.reset();
        if (this.encoding != null) {
            return new InputStreamReader((InputStream)is, this.encoding);
        }
        is.mark(8192);
        byte[] buf = new byte[8192];
        int len = is.read(buf);
        if (len > 0 && (matcher_xml = PatternConsts.XML_ENCODING.matcher(buffer = new String(buf, 0, len))).find()) {
            this.encoding = matcher_xml.group(1);
        }
        is.reset();
        if (this.encoding != null) {
            return new InputStreamReader((InputStream)is, this.encoding);
        }
        try {
            return new InputStreamReader((InputStream)is, "UTF-8");
        }
        catch (Exception e) {
            return new InputStreamReader(is);
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.readFirstTime) {
            this.readFirstTime = false;
            this.reader.mark(1);
            int ch = this.reader.read();
            if (ch != 65279) {
                this.reader.reset();
            }
        }
        return this.reader.read(cbuf, off, len);
    }
}

