/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.xml.Handler;
import org.omegat.filters3.xml.Translator;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.filters3.xml.XMLReader;
import org.omegat.filters3.xml.XMLWriter;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.PatternConsts;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLFilter
extends AbstractFilter
implements Translator {
    private SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private XMLDialect dialect;
    private String encoding;
    private Language targetLanguage;

    public XMLFilter(XMLDialect dialect) {
        try {
            this.parserFactory.setFeature("http://xml.org/sax/features/validation", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dialect = dialect;
    }

    public XMLDialect getDialect() {
        return this.dialect;
    }

    public BufferedReader createReader(File inFile, String inEncoding) throws UnsupportedEncodingException, IOException {
        XMLReader xmlreader = new XMLReader(inFile, inEncoding);
        this.encoding = xmlreader.getEncoding();
        return new BufferedReader(xmlreader);
    }

    public BufferedWriter createWriter(File outFile, String outEncoding) throws UnsupportedEncodingException, IOException {
        if (outEncoding == null) {
            outEncoding = this.encoding;
        }
        if (outFile == null) {
            return new BufferedWriter(new StringWriter());
        }
        return new BufferedWriter(new XMLWriter(outFile, outEncoding));
    }

    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    public void processFile(File inFile, File outFile, FilterContext fc) throws IOException, TranslationException {
        try {
            BufferedReader inReader = this.createReader(inFile, fc.getInEncoding());
            this.inEncodingLastParsedFile = this.encoding;
            this.targetLanguage = fc.getTargetLang();
            InputSource source = new InputSource(inReader);
            source.setSystemId("file:///" + inFile.getCanonicalPath().replace(File.separatorChar, '/'));
            SAXParser parser = this.parserFactory.newSAXParser();
            Handler handler = new Handler(this, this.dialect, inFile, outFile, fc.getOutEncoding());
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
            parser.parse(source, (DefaultHandler)handler);
            inReader.close();
        }
        catch (ParserConfigurationException e) {
            throw new TranslationException(e.getLocalizedMessage());
        }
        catch (SAXException e) {
            Log.log(e);
            throw new TranslationException(e.getLocalizedMessage());
        }
    }

    protected void processFile(BufferedReader inFile, BufferedWriter outFile, FilterContext fc) throws IOException, TranslationException {
        throw new UnsupportedOperationException("XMLFilter.processFile(BufferedReader,BufferedWriter) should never be called!");
    }

    public boolean isSourceEncodingVariable() {
        return false;
    }

    public boolean isTargetEncodingVariable() {
        return true;
    }

    public String translate(String entry) {
        return super.processEntry(entry);
    }

    public boolean isFileSupported(BufferedReader reader) {
        if (this.dialect.getConstraints() == null || this.dialect.getConstraints().size() == 0) {
            return true;
        }
        try {
            Pattern xmlns;
            Pattern root;
            char[] cbuf = new char[8192];
            int cbuf_len = reader.read(cbuf);
            String buf = new String(cbuf, 0, cbuf_len);
            Matcher matcher = PatternConsts.XML_DOCTYPE.matcher(buf);
            if (matcher.find()) {
                Pattern doctype = this.dialect.getConstraints().get(XMLDialect.CONSTRAINT_DOCTYPE);
                if (!(doctype == null || matcher.group(1) != null && doctype.matcher(matcher.group(1)).matches())) {
                    return false;
                }
                Pattern publicc = this.dialect.getConstraints().get(XMLDialect.CONSTRAINT_PUBLIC_DOCTYPE);
                if (!(publicc == null || matcher.group(3) != null && publicc.matcher(matcher.group(3)).matches())) {
                    return false;
                }
                Pattern system = this.dialect.getConstraints().get(XMLDialect.CONSTRAINT_SYSTEM_DOCTYPE);
                if (!(system == null || matcher.group(5) != null && system.matcher(matcher.group(5)).matches())) {
                    return false;
                }
            } else if (this.dialect.getConstraints().containsKey(XMLDialect.CONSTRAINT_DOCTYPE) || this.dialect.getConstraints().containsKey(XMLDialect.CONSTRAINT_PUBLIC_DOCTYPE) || this.dialect.getConstraints().containsKey(XMLDialect.CONSTRAINT_SYSTEM_DOCTYPE)) {
                return false;
            }
            if ((matcher = PatternConsts.XML_ROOTTAG.matcher(buf)).find() ? (root = this.dialect.getConstraints().get(XMLDialect.CONSTRAINT_ROOT)) != null && (matcher.group(1) == null || !root.matcher(matcher.group(1)).matches()) : this.dialect.getConstraints().containsKey(XMLDialect.CONSTRAINT_ROOT)) {
                return false;
            }
            matcher = PatternConsts.XML_XMLNS.matcher(buf);
            return !(matcher.find() ? (xmlns = this.dialect.getConstraints().get(XMLDialect.CONSTRAINT_XMLNS)) != null && (matcher.group(2) == null || !xmlns.matcher(matcher.group(2)).matches()) : this.dialect.getConstraints().containsKey(XMLDialect.CONSTRAINT_XMLNS));
        }
        catch (Exception e) {
            return false;
        }
    }

    public void tagStart(String path, Attributes atts) {
    }

    public void tagEnd(String path) {
    }

    public void comment(String comment) {
    }

    public void text(String text) {
    }
}

