/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3;

import org.omegat.filters3.Attributes;
import org.omegat.filters3.Element;

public abstract class Tag
implements Element {
    public static final int TYPE_BEGIN = 1;
    public static final int TYPE_END = 2;
    public static final int TYPE_ALONE = 3;
    private String tag;
    private String shortcut;
    private int type;
    private Attributes attributes;
    private int index;

    public String getTag() {
        return this.tag;
    }

    public String getShortcut() {
        if (this.shortcut != null) {
            return this.shortcut;
        }
        return Character.toString(this.getTag().charAt(0));
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int shortcut) {
        this.index = shortcut;
    }

    public Tag(String tag, String shortcut, int type, Attributes attributes) {
        this.tag = tag;
        this.shortcut = shortcut;
        this.type = type;
        this.attributes = attributes;
    }

    public String toTMX() {
        String tmxtag;
        switch (this.getType()) {
            case 1: {
                tmxtag = "bpt";
                break;
            }
            case 2: {
                tmxtag = "ept";
                break;
            }
            case 3: {
                tmxtag = "ph";
                break;
            }
            default: {
                throw new RuntimeException("Shouldn't hapen!");
            }
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(tmxtag);
        buf.append(" i=\"");
        buf.append(this.getIndex());
        buf.append("\">");
        buf.append(this.toPartialTMX());
        buf.append("</");
        buf.append(tmxtag);
        buf.append(">");
        return buf.toString();
    }

    protected String toPartialTMX() {
        StringBuffer buf = new StringBuffer();
        buf.append("&amp;lt;");
        if (2 == this.getType()) {
            buf.append("/");
        }
        buf.append(this.getTag());
        buf.append(this.getAttributes().toString());
        if (3 == this.getType()) {
            buf.append("/");
        }
        buf.append("&amp;gt;");
        return buf.toString();
    }

    public String toShortcut() {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        if (2 == this.getType()) {
            buf.append("/");
        }
        buf.append(this.getShortcut());
        buf.append(this.getIndex());
        if (3 == this.getType()) {
            buf.append("/");
        }
        buf.append(">");
        return buf.toString();
    }

    public abstract String toOriginal();
}

