/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.xtagqxp;

import org.omegat.filters3.Element;

public class Xtag
implements Element {
    private String tag;
    private String shortcut;
    private int index;

    public Xtag(String tag, int index) {
        this.tag = tag;
        this.shortcut = this.makeShortcut(tag);
        this.index = index;
    }

    private String makeShortcut(String tag) {
        char letter = ' ';
        for (int i = 0; i < tag.length(); ++i) {
            letter = tag.charAt(i);
            if (!Character.isLetter(letter)) continue;
            letter = Character.toLowerCase(letter);
            return String.valueOf(letter);
        }
        if (letter == '<') {
            return "<";
        }
        if (letter == '>') {
            return ">";
        }
        return "x";
    }

    public String getTag() {
        return this.tag;
    }

    public String getShortcut() {
        if (this.shortcut != null) {
            return this.shortcut;
        }
        return Character.toString(this.getTag().charAt(0));
    }

    public int getIndex() {
        return this.index;
    }

    public String toShortcut() {
        StringBuffer buf = new StringBuffer();
        if (this.getShortcut().equals("<")) {
            return "<";
        }
        if (this.getShortcut().equals(">")) {
            return ">";
        }
        buf.append("<");
        buf.append(this.getShortcut());
        buf.append(this.getIndex());
        buf.append("/");
        buf.append(">");
        return buf.toString();
    }

    public String toOriginal() {
        return "<" + this.getTag() + ">";
    }

    public String toTMX() {
        return "";
    }
}

