/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.omegat.util.OStrings;
import org.openide.awt.Mnemonics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private Map<String, String> options;
    private JRadioButton breaksRB;
    private ButtonGroup buttonGroup1;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JRadioButton emptyLinesRB;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JRadioButton neverRB;
    private JButton okButton;
    private int returnStatus = 0;

    public TextOptionsDialog(Dialog parent, Map<String, String> options) {
        super(parent, true);
        this.options = new TreeMap<String, String>(options);
        this.initComponents();
        String segmentOn = options.get("segmentOn");
        if ("BREAKS".equals(segmentOn)) {
            this.breaksRB.setSelected(true);
        } else if ("NEVER".equals(segmentOn)) {
            this.neverRB.setSelected(true);
        } else {
            this.emptyLinesRB.setSelected(true);
        }
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TextOptionsDialog.this.doClose(0);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.breaksRB = new JRadioButton();
        this.emptyLinesRB = new JRadioButton();
        this.neverRB = new JRadioButton();
        this.setTitle(OStrings.getString("TEXTFILTER_OPTIONS_DIALOG_TITLE"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TextOptionsDialog.this.closeDialog(evt);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jPanel1.setLayout(new GridLayout(0, 1, 0, 3));
        this.jPanel1.setBorder(new EmptyBorder(new Insets(3, 3, 3, 3)));
        Mnemonics.setLocalizedText(this.jLabel1, OStrings.getString("TEXTFILTER_OPTIONS_DIALOG_DESCRIPTION"));
        this.jPanel1.add(this.jLabel1);
        this.buttonGroup1.add(this.breaksRB);
        Mnemonics.setLocalizedText(this.breaksRB, OStrings.getString("TEXTFILTER_OPTION_SEGMENT_ON_LINE_BREAKS"));
        this.jPanel1.add(this.breaksRB);
        this.buttonGroup1.add(this.emptyLinesRB);
        this.emptyLinesRB.setSelected(true);
        Mnemonics.setLocalizedText(this.emptyLinesRB, OStrings.getString("TEXTFILTER_OPTION_SEGMENT_ON_EMPTY_LINES"));
        this.jPanel1.add(this.emptyLinesRB);
        this.buttonGroup1.add(this.neverRB);
        Mnemonics.setLocalizedText(this.neverRB, OStrings.getString("TEXTFILTER_OPTION_NEVER_SEGMENT"));
        this.jPanel1.add(this.neverRB);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String segmentOn = this.breaksRB.isSelected() ? "BREAKS" : (this.neverRB.isSelected() ? "NEVER" : "EMPTYLINES");
        this.options.put("segmentOn", segmentOn);
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

