/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.rc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.util.NullBufferedWriter;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class RcFilter
extends AbstractFilter {
    protected static final Pattern RE_DIALOG = Pattern.compile("(\\S+)\\s+DIALOG(EX)?\\s+.+");
    protected static final Pattern RE_DIALOG_CAPTION = Pattern.compile("CAPTION\\s+.+");
    protected static final Pattern RE_MENU = Pattern.compile("(\\S+)\\s+MENU(EX)?\\s*.*");
    protected static final Pattern RE_MESSAGETABLE = Pattern.compile("(\\S+)\\s+MESSAGETABLE\\s*.*");
    protected static final Pattern RE_STRINGTABLE = Pattern.compile("STRINGTABLE\\s*.*");
    protected String blockId;
    protected int b;
    protected int e;
    protected Map<String, String> align;

    public String getFileFormatName() {
        return OStrings.getString("RCFILTER_FILTER_NAME");
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.rc")};
    }

    public boolean isSourceEncodingVariable() {
        return true;
    }

    public boolean isTargetEncodingVariable() {
        return true;
    }

    protected void processFile(BufferedReader inFile, BufferedWriter outFile, FilterContext fc) throws IOException, TranslationException {
        String s;
        PART cPart = PART.UNKNOWN;
        int cLevel = 0;
        this.blockId = null;
        while ((s = inFile.readLine()) != null) {
            this.b = -1;
            this.e = -1;
            String id = null;
            String strim = s.trim();
            if (strim.startsWith("//") || strim.startsWith("#")) {
                outFile.write(s);
                outFile.newLine();
                continue;
            }
            if (strim.length() == 0) {
                if (cLevel == 0) {
                    cPart = PART.UNKNOWN;
                }
            } else if (cPart == PART.UNKNOWN) {
                cPart = this.parseFirstLineInBlock(strim);
            } else if ("{".equals(strim) || "BEGIN".equalsIgnoreCase(strim)) {
                ++cLevel;
            } else if ("}".equals(strim) || "END".equalsIgnoreCase(strim)) {
                if (--cLevel == 0) {
                    cPart = PART.UNKNOWN;
                }
            } else if (cLevel > 0 && cPart != PART.OTHER && cPart != PART.UNKNOWN) {
                this.markForTranslation(s);
                if (this.b >= 0 && this.e >= 0 && this.b < this.e && this.e > 0) {
                    id = this.parseId(cPart, s, this.b, this.e);
                }
            } else if (cLevel == 0 && cPart == PART.DIALOG && RE_DIALOG_CAPTION.matcher(strim).matches()) {
                this.markForTranslation(s);
                id = "__CAPTION__";
            }
            if (this.b >= 0 && this.e >= 0 && this.b < this.e && this.e > 0) {
                String loc = s.substring(this.b + 1, this.e);
                loc = loc.replace("\\\"", "\"").replace("\"\"", "\"");
                if (this.entryParseCallback != null) {
                    this.entryParseCallback.addEntry(this.blockId + "/" + id, loc, null, false, null, null, this);
                } else if (this.entryTranslateCallback != null) {
                    String trans = this.entryTranslateCallback.getTranslation(this.blockId + "/" + id, loc, null);
                    if (trans == null) {
                        trans = loc;
                    }
                    trans = trans.replace("\"", "\"\"");
                    s = s.substring(0, this.b + 1) + trans + s.substring(this.e);
                } else if (this.entryAlignCallback != null && id != null) {
                    this.align.put(this.blockId + "/" + id, loc);
                }
            }
            outFile.write(s);
            outFile.newLine();
        }
    }

    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc) throws Exception {
        HashMap<String, String> source = new HashMap<String, String>();
        HashMap<String, String> translated = new HashMap<String, String>();
        this.align = source;
        this.processFile(sourceFile, new NullBufferedWriter(), fc);
        this.align = translated;
        this.processFile(translatedFile, new NullBufferedWriter(), fc);
        for (Map.Entry en : source.entrySet()) {
            String tr = (String)translated.get(en.getKey());
            if (StringUtil.isEmpty(tr)) continue;
            this.entryAlignCallback.addTranslation((String)en.getKey(), (String)en.getValue(), tr, false, null, this);
        }
    }

    private PART parseFirstLineInBlock(String line) {
        Matcher m = RE_DIALOG.matcher(line);
        if (m.matches()) {
            this.blockId = m.group(1);
            return PART.DIALOG;
        }
        m = RE_MENU.matcher(line);
        if (m.matches()) {
            this.blockId = m.group(1);
            return PART.MENU;
        }
        m = RE_MESSAGETABLE.matcher(line);
        if (m.matches()) {
            this.blockId = m.group(1);
            return PART.MESSAGETABLE;
        }
        if (RE_STRINGTABLE.matcher(line).matches()) {
            this.blockId = "";
            return PART.STRINGTABLE;
        }
        return PART.OTHER;
    }

    private String parseId(PART cPart, String line, int b, int e) {
        switch (cPart) {
            case DIALOG: 
            case MENU: {
                String[] w = line.substring(e).split(",");
                return w.length > 1 ? w[1].trim() : null;
            }
            case MESSAGETABLE: 
            case STRINGTABLE: {
                String[] w = line.substring(0, b).split(",");
                return w[0].trim();
            }
        }
        return null;
    }

    private void markForTranslation(String s) {
        this.b = s.indexOf(34);
        if (this.b < 0) {
            return;
        }
        this.e = this.b;
        while (true) {
            this.e = s.indexOf(34, this.e + 1);
            if (this.e < 0) break;
            if (s.charAt(this.e - 1) == '\\') continue;
            if (this.e >= s.length() - 1 || s.charAt(this.e + 1) != '\"') break;
            ++this.e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PART {
        DIALOG,
        MENU,
        MESSAGETABLE,
        STRINGTABLE,
        OTHER,
        UNKNOWN;

    }
}

