/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.html2;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.visitors.NodeVisitor;
import org.omegat.filters2.html2.HTMLFilter2;
import org.omegat.filters2.html2.HTMLOptions;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.StaticUtils;

public class FilterVisitor
extends NodeVisitor {
    protected HTMLFilter2 filter;
    private BufferedWriter writer;
    private HTMLOptions options;
    boolean recurse = true;
    boolean text = false;
    boolean preformatting = false;
    List<Node> befors;
    List<Node> translatable;
    List<Node> afters;
    List<Tag> s_tags;
    List<Integer> s_tag_numbers;
    List<String> s_shortcuts;
    int s_nshortcuts;
    boolean firstcall = true;
    private static final Object[][] ENTITIES = new Object[][]{{"quot", new Integer(34)}, {"amp", new Integer(38)}, {"lt", new Integer(60)}, {"gt", new Integer(62)}, {"OElig", new Integer(338)}, {"oelig", new Integer(339)}, {"Scaron", new Integer(352)}, {"scaron", new Integer(353)}, {"Yuml", new Integer(376)}, {"circ", new Integer(710)}, {"tilde", new Integer(732)}, {"ensp", new Integer(8194)}, {"emsp", new Integer(8195)}, {"thinsp", new Integer(8201)}, {"zwnj", new Integer(8204)}, {"zwj", new Integer(8205)}, {"lrm", new Integer(8206)}, {"rlm", new Integer(8207)}, {"ndash", new Integer(8211)}, {"mdash", new Integer(8212)}, {"lsquo", new Integer(8216)}, {"rsquo", new Integer(8217)}, {"sbquo", new Integer(8218)}, {"ldquo", new Integer(8220)}, {"rdquo", new Integer(8221)}, {"bdquo", new Integer(8222)}, {"dagger", new Integer(8224)}, {"Dagger", new Integer(8225)}, {"permil", new Integer(8240)}, {"lsaquo", new Integer(8249)}, {"rsaquo", new Integer(8250)}, {"euro", new Integer(8364)}, {"nbsp", new Integer(160)}, {"iexcl", new Integer(161)}, {"cent", new Integer(162)}, {"pound", new Integer(163)}, {"curren", new Integer(164)}, {"yen", new Integer(165)}, {"brvbar", new Integer(166)}, {"sect", new Integer(167)}, {"uml", new Integer(168)}, {"copy", new Integer(169)}, {"ordf", new Integer(170)}, {"laquo", new Integer(171)}, {"not", new Integer(172)}, {"shy", new Integer(173)}, {"reg", new Integer(174)}, {"macr", new Integer(175)}, {"deg", new Integer(176)}, {"plusmn", new Integer(177)}, {"sup2", new Integer(178)}, {"sup3", new Integer(179)}, {"acute", new Integer(180)}, {"micro", new Integer(181)}, {"para", new Integer(182)}, {"middot", new Integer(183)}, {"cedil", new Integer(184)}, {"sup1", new Integer(185)}, {"ordm", new Integer(186)}, {"raquo", new Integer(187)}, {"frac14", new Integer(188)}, {"frac12", new Integer(189)}, {"frac34", new Integer(190)}, {"iquest", new Integer(191)}, {"Agrave", new Integer(192)}, {"Aacute", new Integer(193)}, {"Acirc", new Integer(194)}, {"Atilde", new Integer(195)}, {"Auml", new Integer(196)}, {"Aring", new Integer(197)}, {"AElig", new Integer(198)}, {"Ccedil", new Integer(199)}, {"Egrave", new Integer(200)}, {"Eacute", new Integer(201)}, {"Ecirc", new Integer(202)}, {"Euml", new Integer(203)}, {"Igrave", new Integer(204)}, {"Iacute", new Integer(205)}, {"Icirc", new Integer(206)}, {"Iuml", new Integer(207)}, {"ETH", new Integer(208)}, {"Ntilde", new Integer(209)}, {"Ograve", new Integer(210)}, {"Oacute", new Integer(211)}, {"Ocirc", new Integer(212)}, {"Otilde", new Integer(213)}, {"Ouml", new Integer(214)}, {"times", new Integer(215)}, {"Oslash", new Integer(216)}, {"Ugrave", new Integer(217)}, {"Uacute", new Integer(218)}, {"Ucirc", new Integer(219)}, {"Uuml", new Integer(220)}, {"Yacute", new Integer(221)}, {"THORN", new Integer(222)}, {"szlig", new Integer(223)}, {"agrave", new Integer(224)}, {"aacute", new Integer(225)}, {"acirc", new Integer(226)}, {"atilde", new Integer(227)}, {"auml", new Integer(228)}, {"aring", new Integer(229)}, {"aelig", new Integer(230)}, {"ccedil", new Integer(231)}, {"egrave", new Integer(232)}, {"eacute", new Integer(233)}, {"ecirc", new Integer(234)}, {"euml", new Integer(235)}, {"igrave", new Integer(236)}, {"iacute", new Integer(237)}, {"icirc", new Integer(238)}, {"iuml", new Integer(239)}, {"eth", new Integer(240)}, {"ntilde", new Integer(241)}, {"ograve", new Integer(242)}, {"oacute", new Integer(243)}, {"ocirc", new Integer(244)}, {"otilde", new Integer(245)}, {"ouml", new Integer(246)}, {"divide", new Integer(247)}, {"oslash", new Integer(248)}, {"ugrave", new Integer(249)}, {"uacute", new Integer(250)}, {"ucirc", new Integer(251)}, {"uuml", new Integer(252)}, {"yacute", new Integer(253)}, {"thorn", new Integer(254)}, {"yuml", new Integer(255)}, {"fnof", new Integer(402)}, {"Alpha", new Integer(913)}, {"Beta", new Integer(914)}, {"Gamma", new Integer(915)}, {"Delta", new Integer(916)}, {"Epsilon", new Integer(917)}, {"Zeta", new Integer(918)}, {"Eta", new Integer(919)}, {"Theta", new Integer(920)}, {"Iota", new Integer(921)}, {"Kappa", new Integer(922)}, {"Lambda", new Integer(923)}, {"Mu", new Integer(924)}, {"Nu", new Integer(925)}, {"Xi", new Integer(926)}, {"Omicron", new Integer(927)}, {"Pi", new Integer(928)}, {"Rho", new Integer(929)}, {"Sigma", new Integer(931)}, {"Tau", new Integer(932)}, {"Upsilon", new Integer(933)}, {"Phi", new Integer(934)}, {"Chi", new Integer(935)}, {"Psi", new Integer(936)}, {"Omega", new Integer(937)}, {"alpha", new Integer(945)}, {"beta", new Integer(946)}, {"gamma", new Integer(947)}, {"delta", new Integer(948)}, {"epsilon", new Integer(949)}, {"zeta", new Integer(950)}, {"eta", new Integer(951)}, {"theta", new Integer(952)}, {"iota", new Integer(953)}, {"kappa", new Integer(954)}, {"lambda", new Integer(955)}, {"mu", new Integer(956)}, {"nu", new Integer(957)}, {"xi", new Integer(958)}, {"omicron", new Integer(959)}, {"pi", new Integer(960)}, {"rho", new Integer(961)}, {"sigmaf", new Integer(962)}, {"sigma", new Integer(963)}, {"tau", new Integer(964)}, {"upsilon", new Integer(965)}, {"phi", new Integer(966)}, {"chi", new Integer(967)}, {"psi", new Integer(968)}, {"omega", new Integer(969)}, {"thetasym", new Integer(977)}, {"upsih", new Integer(978)}, {"piv", new Integer(982)}, {"bull", new Integer(8226)}, {"hellip", new Integer(8230)}, {"prime", new Integer(8242)}, {"Prime", new Integer(8243)}, {"oline", new Integer(8254)}, {"frasl", new Integer(8260)}, {"weierp", new Integer(8472)}, {"image", new Integer(8465)}, {"real", new Integer(8476)}, {"trade", new Integer(8482)}, {"alefsym", new Integer(8501)}, {"larr", new Integer(8592)}, {"uarr", new Integer(8593)}, {"rarr", new Integer(8594)}, {"darr", new Integer(8595)}, {"harr", new Integer(8596)}, {"crarr", new Integer(8629)}, {"lArr", new Integer(8656)}, {"uArr", new Integer(8657)}, {"rArr", new Integer(8658)}, {"dArr", new Integer(8659)}, {"hArr", new Integer(8660)}, {"forall", new Integer(8704)}, {"part", new Integer(8706)}, {"exist", new Integer(8707)}, {"empty", new Integer(8709)}, {"nabla", new Integer(8711)}, {"isin", new Integer(8712)}, {"notin", new Integer(8713)}, {"ni", new Integer(8715)}, {"prod", new Integer(8719)}, {"sum", new Integer(8722)}, {"minus", new Integer(8722)}, {"lowast", new Integer(8727)}, {"radic", new Integer(8730)}, {"prop", new Integer(8733)}, {"infin", new Integer(8734)}, {"ang", new Integer(8736)}, {"and", new Integer(8869)}, {"or", new Integer(8870)}, {"cap", new Integer(8745)}, {"cup", new Integer(8746)}, {"int", new Integer(8747)}, {"there4", new Integer(8756)}, {"sim", new Integer(8764)}, {"cong", new Integer(8773)}, {"asymp", new Integer(8773)}, {"ne", new Integer(8800)}, {"equiv", new Integer(8801)}, {"le", new Integer(8804)}, {"ge", new Integer(8805)}, {"sub", new Integer(8834)}, {"sup", new Integer(8835)}, {"nsub", new Integer(8836)}, {"sube", new Integer(8838)}, {"supe", new Integer(8839)}, {"oplus", new Integer(8853)}, {"otimes", new Integer(8855)}, {"perp", new Integer(8869)}, {"sdot", new Integer(8901)}, {"lceil", new Integer(8968)}, {"rceil", new Integer(8969)}, {"lfloor", new Integer(8970)}, {"rfloor", new Integer(8971)}, {"lang", new Integer(9001)}, {"rang", new Integer(9002)}, {"loz", new Integer(9674)}, {"spades", new Integer(9824)}, {"clubs", new Integer(9827)}, {"hearts", new Integer(9829)}, {"diams", new Integer(9830)}};

    public FilterVisitor(HTMLFilter2 htmlfilter, BufferedWriter bufwriter, HTMLOptions options) {
        this.filter = htmlfilter;
        this.options = options;
        this.writer = bufwriter;
    }

    public boolean shouldRecurseSelf() {
        return this.recurse;
    }

    public boolean shouldRecurseChildren() {
        return this.recurse;
    }

    public void visitTag(Tag tag) {
        Iterator i;
        Vector tagAttributes;
        boolean intactTag = this.isIntactTag(tag);
        if (!intactTag) {
            tagAttributes = tag.getAttributesEx();
            i = tagAttributes.iterator();
            while (i.hasNext() && !intactTag) {
                Attribute attribute = (Attribute)i.next();
                String name = attribute.getName();
                String value = attribute.getValue();
                if (name == null || value == null) continue;
                intactTag = this.filter.checkIgnoreTags(name, value);
            }
        }
        if (intactTag) {
            if (this.text) {
                this.endup();
            } else {
                this.flushbefors();
            }
            this.writeout(tag.toHtml());
            if (tag.getEndTag() != null) {
                this.recurse = false;
            }
        } else {
            if (this.isParagraphTag(tag) && this.text) {
                this.endup();
            }
            if (this.isPreformattingTag(tag)) {
                this.preformatting = true;
            }
            this.maybeTranslateAttribute(tag, "abbr");
            this.maybeTranslateAttribute(tag, "alt");
            if (this.options.getTranslateHref()) {
                this.maybeTranslateAttribute(tag, "href");
            }
            if (this.options.getTranslateHreflang()) {
                this.maybeTranslateAttribute(tag, "hreflang");
            }
            if (this.options.getTranslateLang()) {
                this.maybeTranslateAttribute(tag, "lang");
                this.maybeTranslateAttribute(tag, "xml:lang");
            }
            this.maybeTranslateAttribute(tag, "label");
            if ("IMG".equals(tag.getTagName()) && this.options.getTranslateSrc()) {
                this.maybeTranslateAttribute(tag, "src");
            }
            this.maybeTranslateAttribute(tag, "summary");
            this.maybeTranslateAttribute(tag, "title");
            if ("INPUT".equals(tag.getTagName()) && (this.options.getTranslateValue() || "submit".equalsIgnoreCase(tag.getAttribute("type")) || "button".equalsIgnoreCase(tag.getAttribute("type")) || "reset".equalsIgnoreCase(tag.getAttribute("type")) && this.options.getTranslateButtonValue())) {
                this.maybeTranslateAttribute(tag, "value");
            }
            if ("META".equals(tag.getTagName())) {
                tagAttributes = tag.getAttributesEx();
                i = tagAttributes.iterator();
                boolean doSkipMetaTag = false;
                while (i.hasNext() && !doSkipMetaTag) {
                    Attribute attribute = (Attribute)i.next();
                    String name = attribute.getName();
                    String value = attribute.getValue();
                    if (name == null || value == null) continue;
                    doSkipMetaTag = this.filter.checkDoSkipMetaTag(name, value);
                }
                if (!doSkipMetaTag) {
                    this.maybeTranslateAttribute(tag, "content");
                }
            }
            this.queuePrefix(tag);
        }
    }

    protected void maybeTranslateAttribute(Tag tag, String key) {
        String attr = tag.getAttribute(key);
        if (attr != null) {
            String comment = OStrings.getString("HTMLFILTER_TAG") + " " + tag.getTagName() + " " + OStrings.getString("HTMLFILTER_ATTRIBUTE") + " " + key;
            String trans = this.filter.privateProcessEntry(this.entitiesToChars(attr), comment);
            tag.setAttribute(key, this.charsToEntities(trans));
        }
    }

    public void visitStringNode(Text string) {
        this.recurse = true;
        String trimmedtext = string.getText().trim();
        if (trimmedtext.length() > 0) {
            if (this.firstcall && PatternConsts.XML_HEADER.matcher(trimmedtext).matches()) {
                this.writeout(string.toHtml());
                return;
            }
            this.text = true;
            this.firstcall = false;
        }
        if (this.text) {
            this.queueTranslatable(string);
        } else {
            this.queuePrefix(string);
        }
    }

    public void visitRemarkNode(Remark remark) {
        this.recurse = true;
        if (this.text) {
            this.endup();
        }
        if (!this.options.getRemoveComments()) {
            this.writeout(remark.toHtml());
        }
    }

    public void visitEndTag(Tag tag) {
        this.recurse = true;
        if (this.isParagraphTag(tag) && this.text) {
            this.endup();
        }
        if (this.isPreformattingTag(tag)) {
            this.preformatting = false;
        }
        this.queuePrefix(tag);
    }

    public void beginParsing() {
        this.cleanup();
    }

    public void finishedParsing() {
        if (this.text) {
            this.endup();
        } else {
            this.flushbefors();
        }
    }

    private boolean isParagraphTag(Tag tag) {
        String tagname = tag.getTagName();
        return tagname.equals("ADDRESS") || tagname.equals("BLOCKQUOTE") || tagname.equals("BODY") || tagname.equals("CENTER") || tagname.equals("DIV") || tagname.equals("H1") || tagname.equals("H2") || tagname.equals("H3") || tagname.equals("H4") || tagname.equals("H5") || tagname.equals("H6") || tagname.equals("HTML") || tagname.equals("HEAD") || tagname.equals("TITLE") || tagname.equals("TABLE") || tagname.equals("TR") || tagname.equals("TD") || tagname.equals("TH") || tagname.equals("P") || tagname.equals("PRE") || tagname.equals("OL") || tagname.equals("UL") || tagname.equals("LI") || tagname.equals("DL") || tagname.equals("DT") || tagname.equals("DD") || tagname.equals("FORM") || tagname.equals("TEXTAREA") || tagname.equals("FIELDSET") || tagname.equals("LEGEND") || tagname.equals("LABEL") || tagname.equals("SELECT") || tagname.equals("OPTION") || tagname.equals("HR") || tagname.equals("BR") && this.options.getParagraphOnBr();
    }

    private boolean isIntactTag(Tag tag) {
        String tagname = tag.getTagName();
        return tagname.equals("!DOCTYPE") || tagname.equals("STYLE") || tagname.equals("SCRIPT") || tagname.equals("OBJECT") || tagname.equals("EMBED") || tagname.equals("META") && "content-type".equalsIgnoreCase(tag.getAttribute("http-equiv"));
    }

    private boolean isPreformattingTag(Tag tag) {
        String tagname = tag.getTagName();
        return tagname.equals("PRE") || tagname.equals("TEXTAREA");
    }

    private void writeout(String something) {
        try {
            this.writer.write(something);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    protected void endup() {
        String translation;
        String uncompressed;
        ArrayList<Node> all = new ArrayList<Node>();
        all.addAll(this.befors);
        all.addAll(this.translatable);
        int firstgoodlimit = this.befors.size();
        int firstgood = 0;
        while (firstgood < firstgoodlimit) {
            Node good_node = (Node)all.get(firstgood);
            if (!(good_node instanceof Tag)) {
                ++firstgood;
                continue;
            }
            Tag good = (Tag)good_node;
            int recursion = 1;
            boolean found = false;
            for (int i = firstgood + 1; i < all.size(); ++i) {
                Tag cand;
                Node cand_node = (Node)all.get(i);
                if (!(cand_node instanceof Tag) || !(cand = (Tag)cand_node).getTagName().equals(good.getTagName())) continue;
                if (!cand.isEndTag()) {
                    ++recursion;
                    continue;
                }
                if (--recursion != 0) continue;
                if (i < firstgoodlimit) break;
                found = true;
                break;
            }
            if (found) break;
            ++firstgood;
        }
        for (int i = 0; i < firstgood; ++i) {
            Node node = (Node)all.get(i);
            if (node instanceof Tag) {
                this.writeout("<" + node.getText() + ">");
                continue;
            }
            this.writeout(this.compressWhitespace(node.getText()));
        }
        int lastgoodlimit = all.size() - 1;
        all.addAll(this.afters);
        int lastgood = all.size() - 1;
        while (lastgood > lastgoodlimit) {
            Node good_node = (Node)all.get(lastgood);
            if (!(good_node instanceof Tag)) {
                --lastgood;
                continue;
            }
            Tag good = (Tag)good_node;
            int recursion = 1;
            boolean found = false;
            for (int i = lastgood - 1; i >= firstgoodlimit; --i) {
                Tag cand;
                Node cand_node = (Node)all.get(i);
                if (!(cand_node instanceof Tag) || !(cand = (Tag)cand_node).getTagName().equals(good.getTagName())) continue;
                if (cand.isEndTag()) {
                    ++recursion;
                    continue;
                }
                if (--recursion != 0) continue;
                if (i > lastgoodlimit) break;
                found = true;
                break;
            }
            if (found) break;
            --lastgood;
        }
        StringBuffer paragraph = new StringBuffer();
        for (int i = firstgood; i <= lastgood; ++i) {
            Node node = (Node)all.get(i);
            if (node instanceof Tag) {
                this.shortcut((Tag)node, paragraph);
                continue;
            }
            paragraph.append(this.entitiesToChars(node.toHtml()));
        }
        String compressed = uncompressed = paragraph.toString();
        String spacePrefix = "";
        String spacePostfix = "";
        int size = uncompressed.length();
        if (!this.preformatting) {
            int i;
            for (i = 0; i < size; ++i) {
                if (Character.isWhitespace(uncompressed.charAt(i))) continue;
                spacePrefix = uncompressed.substring(0, this.options.getCompressWhitespace() ? Math.min(i, 1) : i);
                break;
            }
            for (i = size - 1; i > 0; --i) {
                if (Character.isWhitespace(uncompressed.charAt(i))) continue;
                spacePostfix = uncompressed.substring(i + 1, this.options.getCompressWhitespace() ? Math.min(i + 2, size) : size);
                break;
            }
            compressed = StaticUtils.compressSpaces(uncompressed);
        }
        if (compressed.equals(translation = this.filter.privateProcessEntry(compressed, null)) && !this.options.getCompressWhitespace()) {
            translation = uncompressed;
        }
        translation = this.charsToEntities(translation);
        translation = this.unshorcutize(translation);
        this.writeout(spacePrefix);
        this.writeout(translation);
        this.writeout(spacePostfix);
        for (int i = lastgood + 1; i < all.size(); ++i) {
            Node node = (Node)all.get(i);
            if (node instanceof Tag) {
                this.writeout("<" + node.getText() + ">");
                continue;
            }
            this.writeout(this.compressWhitespace(node.getText()));
        }
        this.cleanup();
    }

    private void cleanup() {
        this.text = false;
        this.recurse = true;
        this.befors = new ArrayList<Node>();
        this.translatable = new ArrayList<Node>();
        this.afters = new ArrayList<Node>();
        this.s_tags = new ArrayList<Tag>();
        this.s_tag_numbers = new ArrayList<Integer>();
        this.s_shortcuts = new ArrayList<String>();
        this.s_nshortcuts = 0;
    }

    private void shortcut(Tag tag, StringBuffer paragraph) {
        StringBuffer result = new StringBuffer();
        result.append('<');
        int n = -1;
        if (tag.isEndTag()) {
            result.append('/');
            int recursion = 1;
            for (int i = this.s_tags.size() - 1; i >= 0; --i) {
                Tag othertag = this.s_tags.get(i);
                if (!othertag.getTagName().equals(tag.getTagName())) continue;
                if (othertag.isEndTag()) {
                    ++recursion;
                    continue;
                }
                if (--recursion != 0) continue;
                n = this.s_tag_numbers.get(i);
                break;
            }
            if (n < 0) {
                n = this.s_nshortcuts++;
            }
        } else {
            n = this.s_nshortcuts++;
        }
        if ("BR".equals(tag.getTagName())) {
            result.append("br");
        } else {
            result.append(Character.toLowerCase(tag.getTagName().charAt(0)));
        }
        result.append(n);
        if (tag.isEmptyXmlTag()) {
            result.append('/');
        }
        result.append('>');
        String shortcut = result.toString();
        this.s_tags.add(tag);
        this.s_tag_numbers.add(n);
        this.s_shortcuts.add(shortcut);
        paragraph.append(shortcut);
    }

    private String unshorcutize(String str) {
        block2: for (int i = 0; i < this.s_shortcuts.size(); ++i) {
            String shortcut = this.s_shortcuts.get(i);
            int pos = -1;
            while ((pos = str.indexOf(shortcut, pos + 1)) >= 0) {
                Tag tag = this.s_tags.get(i);
                try {
                    str = str.substring(0, pos) + "<" + tag.getText() + ">" + str.substring(pos + shortcut.length());
                }
                catch (StringIndexOutOfBoundsException sioobe) {
                    continue block2;
                }
            }
        }
        return str;
    }

    private void queueTranslatable(Text text) {
        if (text.toHtml().trim().length() > 0) {
            this.translatable.addAll(this.afters);
            this.afters.clear();
            this.translatable.add(text);
        } else {
            this.afters.add(text);
        }
    }

    private void queueTranslatable(Tag tag) {
        this.afters.add(tag);
    }

    protected void queuePrefix(Tag tag) {
        if (this.text) {
            this.queueTranslatable(tag);
        } else if (this.isParagraphTag(tag)) {
            this.flushbefors();
            this.writeout("<" + tag.getText() + ">");
        } else {
            this.befors.add(tag);
        }
    }

    private void queuePrefix(Text text) {
        this.befors.add(text);
    }

    private void flushbefors() {
        for (Node node : this.befors) {
            if (node instanceof Tag) {
                this.writeout("<" + node.getText() + ">");
                continue;
            }
            this.writeout(this.compressWhitespace(node.getText()));
        }
        this.befors.clear();
    }

    private String compressWhitespace(String input) {
        if (this.options.getCompressWhitespace()) {
            Matcher whitespaceMatch = PatternConsts.SPACE_TAB.matcher(input);
            return whitespaceMatch.replaceAll(" ");
        }
        return input;
    }

    protected String entitiesToChars(String str) {
        int strlen = str.length();
        StringBuffer res = new StringBuffer(strlen);
        block7: for (int i = 0; i < strlen; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '&': {
                    if (i + 1 >= strlen) {
                        res.append(ch);
                        continue block7;
                    }
                    char ch1 = str.charAt(i + 1);
                    if (ch1 == '#') {
                        String s_entity;
                        int n;
                        char ch2 = str.charAt(i + 2);
                        if (ch2 == 'x' || ch2 == 'X') {
                            for (n = i + 3; n < strlen && this.isHexDigit(str.charAt(n)); ++n) {
                            }
                            s_entity = str.substring(i + 3, n);
                            try {
                                int n_entity = Integer.parseInt(s_entity, 16);
                                if (n_entity > 0 && n_entity <= 65535) {
                                    res.append((char)n_entity);
                                    if (n < strlen && str.charAt(n) == ';') {
                                        i = n;
                                        continue block7;
                                    }
                                    i = n - 1;
                                    continue block7;
                                }
                                res.append(ch);
                            }
                            catch (NumberFormatException nfe) {
                                res.append(ch);
                            }
                            continue block7;
                        }
                        for (n = i + 2; n < strlen && this.isDecimalDigit(str.charAt(n)); ++n) {
                        }
                        s_entity = str.substring(i + 2, n);
                        try {
                            int n_entity = Integer.parseInt(s_entity, 10);
                            if (n_entity > 0 && n_entity <= 65535) {
                                res.append((char)n_entity);
                                if (n < strlen && str.charAt(n) == ';') {
                                    i = n;
                                    continue block7;
                                }
                                i = n - 1;
                                continue block7;
                            }
                            res.append(ch);
                        }
                        catch (NumberFormatException nfe) {
                            res.append(ch);
                        }
                        continue block7;
                    }
                    if (this.isLatinLetter(ch1)) {
                        int n;
                        for (n = i + 1; n < strlen && (this.isLatinLetter(str.charAt(n)) || this.isDecimalDigit(str.charAt(n))); ++n) {
                        }
                        String s_entity = str.substring(i + 1, n);
                        int n_entity = this.lookupEntity(s_entity);
                        if (n_entity > 0 && n_entity <= 65535) {
                            res.append((char)n_entity);
                            if (n < strlen && str.charAt(n) == ';') {
                                i = n;
                                continue block7;
                            }
                            i = n - 1;
                            continue block7;
                        }
                        res.append(ch);
                        continue block7;
                    }
                    res.append(ch);
                    continue block7;
                }
                default: {
                    res.append(ch);
                }
            }
        }
        return res.toString();
    }

    private boolean isLatinLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private boolean isDecimalDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private boolean isHexDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    private int lookupEntity(String entity) {
        for (int i = 0; i < ENTITIES.length; ++i) {
            Object[] ONENT = ENTITIES[i];
            if (!entity.equals(ONENT[0])) continue;
            return (Integer)ONENT[1];
        }
        return -1;
    }

    protected String charsToEntities(String str) {
        int strlen = str.length();
        StringBuffer res = new StringBuffer(strlen * 5);
        block6: for (int i = 0; i < strlen; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\u00a0': {
                    res.append("&nbsp;");
                    continue block6;
                }
                case '&': {
                    res.append("&amp;");
                    continue block6;
                }
                case '>': {
                    if (i > 0 && str.substring(i - 1, i).contentEquals("?")) {
                        res.append(">");
                        continue block6;
                    }
                    res.append("&gt;");
                    continue block6;
                }
                case '<': {
                    int qMarkPos = str.indexOf(63, i);
                    if (qMarkPos == i + 1) {
                        res.append("<");
                        continue block6;
                    }
                    int gtpos = str.indexOf(62, i);
                    if (gtpos >= 0) {
                        String maybeShortcut = str.substring(i, gtpos + 1);
                        boolean foundShortcut = false;
                        for (String currShortcut : this.s_shortcuts) {
                            if (!maybeShortcut.equals(currShortcut)) continue;
                            foundShortcut = true;
                            break;
                        }
                        if (foundShortcut) {
                            res.append(maybeShortcut);
                            i = gtpos;
                            continue block6;
                        }
                        res.append("&lt;");
                        continue block6;
                    }
                    res.append("&lt;");
                    continue block6;
                }
                default: {
                    res.append(ch);
                }
            }
        }
        String contents = res.toString();
        String encoding = this.filter.getTargetEncoding();
        if (encoding != null) {
            CharsetEncoder charsetEncoder = Charset.forName(encoding).newEncoder();
            int i = 0;
            boolean notfinished = true;
            while (notfinished) {
                while (i < contents.length()) {
                    char x = contents.charAt(i);
                    if (!charsetEncoder.canEncode(x)) {
                        String regexp = x == '[' || x == '\\' || x == '^' || x == '$' || x == '.' || x == '|' || x == '?' || x == '*' || x == '+' || x == '(' || x == ')' ? "\\" + x : "" + x;
                        String replacement = "&#" + x + ';';
                        contents = contents.replaceAll(regexp, replacement);
                        break;
                    }
                    ++i;
                }
                if (i != contents.length()) continue;
                notfinished = false;
            }
        }
        return contents;
    }
}

