/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.threads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import org.omegat.core.Core;

public class CommandMonitor
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(CommandMonitor.class.getName());
    private final InputStream stream;
    private final Process process;
    private final boolean isStdErr;
    private String message = null;

    public static CommandMonitor StdoutMonitor(Process process) {
        return new CommandMonitor(process, false);
    }

    public static CommandMonitor StderrMonitor(Process process) {
        return new CommandMonitor(process, true);
    }

    private CommandMonitor(Process process, boolean isStdErr) {
        this.isStdErr = isStdErr;
        this.process = process;
        this.stream = isStdErr ? process.getErrorStream() : process.getInputStream();
        this.setName("CommandMonitor");
    }

    public void run() {
        InputStreamReader isr = new InputStreamReader(this.stream);
        BufferedReader br = new BufferedReader(isr);
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                if (this.isStdErr) {
                    LOGGER.warning(line);
                } else {
                    LOGGER.info(line);
                }
                this.message = line;
            }
        }
        catch (IOException e) {
            Core.getMainWindow().showStatusMessageRB("CT_ERROR_MONITORING_EXTERNAL_CMD", new Object[0]);
        }
        int exitValue = -1;
        try {
            exitValue = this.process.waitFor();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.isStdErr) {
            if (exitValue > 0 && this.message == null) {
                Core.getMainWindow().showStatusMessageRB("CT_EXTERNAL_CMD_ERROR", exitValue);
            } else if (exitValue > 0) {
                Core.getMainWindow().showStatusMessageRB("CT_EXTERNAL_CMD_ERROR_MSG", exitValue, this.message);
            } else if (exitValue < 0) {
                Core.getMainWindow().showStatusMessageRB("CT_EXTERNAL_CMD_INTERRUPTED", new Object[0]);
            }
        } else if (exitValue == 0) {
            if (this.message == null) {
                Core.getMainWindow().showStatusMessageRB("CT_EXTERNAL_CMD_SUCCESS", exitValue);
            } else {
                Core.getMainWindow().showStatusMessageRB("CT_EXTERNAL_CMD_SUCCESS_MSG", exitValue, this.message);
            }
        }
    }
}

