/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team;

import java.io.File;
import java.net.SocketException;
import java.util.Collection;
import org.omegat.core.team.IRemoteRepository;
import org.omegat.util.Log;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthStoreHandler;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorageOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNGnomeKeyringPasswordProvider;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNRemoteRepository
implements IRemoteRepository {
    File baseDirectory;
    SVNClientManager ourClientManager;
    boolean readOnly;
    ISVNAuthenticationStorageOptions FORCE_SAVE_PLAIN_PASSWORD = new ISVNAuthenticationStorageOptions(){

        public boolean isNonInteractive() throws SVNException {
            return false;
        }

        public ISVNAuthStoreHandler getAuthStoreHandler() throws SVNException {
            return SVNRemoteRepository.this.FORCE_SAVE_PLAIN_PASSWORD_HANDLER;
        }

        public boolean isSSLPassphrasePromptSupported() {
            return false;
        }

        public ISVNGnomeKeyringPasswordProvider getGnomeKeyringPasswordProvider() {
            return null;
        }
    };
    ISVNAuthStoreHandler FORCE_SAVE_PLAIN_PASSWORD_HANDLER = new ISVNAuthStoreHandler(){

        public boolean canStorePlainTextPassphrases(String realm, SVNAuthentication auth) throws SVNException {
            return false;
        }

        public boolean canStorePlainTextPasswords(String realm, SVNAuthentication auth) throws SVNException {
            return true;
        }
    };

    public static boolean isSVNDirectory(File localDirectory) {
        File svnDir = new File(localDirectory, ".svn");
        return svnDir.exists() && svnDir.isDirectory();
    }

    public boolean isFilesLockingAllowed() {
        return true;
    }

    public SVNRemoteRepository(File localDirectory) throws Exception {
        this.baseDirectory = localDirectory;
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager();
        this.ourClientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
    }

    public boolean isChanged(File file) throws Exception {
        SVNStatus status = null;
        try {
            status = this.ourClientManager.getStatusClient().doStatus(file, false);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode().getCode() == 155007) {
                return false;
            }
            throw e;
        }
        if (status == null) {
            return false;
        }
        SVNStatusType statusType = status.getContentsStatus();
        return statusType != SVNStatusType.STATUS_NORMAL && statusType != SVNStatusType.STATUS_UNVERSIONED && statusType != SVNStatusType.STATUS_NONE;
    }

    public boolean isUnderVersionControl(File file) throws Exception {
        SVNStatus status = null;
        try {
            status = this.ourClientManager.getStatusClient().doStatus(file, false);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode().getCode() == 155007) {
                return false;
            }
            throw e;
        }
        if (status == null) {
            return false;
        }
        SVNStatusType statusType = status.getContentsStatus();
        return statusType != SVNStatusType.STATUS_UNVERSIONED && statusType != SVNStatusType.STATUS_NONE;
    }

    public void setCredentials(String username, String password, boolean forceSacePlainPassword) {
        this.ourClientManager.dispose();
        DefaultSVNAuthenticationManager authManager = new DefaultSVNAuthenticationManager(null, true, username, password);
        if (forceSacePlainPassword) {
            authManager.setAuthenticationStorageOptions(this.FORCE_SAVE_PLAIN_PASSWORD);
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        this.ourClientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
    }

    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    public void updateFullProject() throws SocketException, Exception {
        Log.logInfoRB("SVN_START", "update");
        try {
            this.ourClientManager.getUpdateClient().doUpdate(this.baseDirectory, SVNRevision.HEAD, SVNDepth.INFINITY, false, false);
            Log.logInfoRB("SVN_FINISH", "update");
        }
        catch (SVNAuthenticationException ex) {
            Log.logWarningRB("SVN_ERROR", "update", ex.getMessage());
            throw new IRemoteRepository.AuthenticationException((Exception)((Object)ex));
        }
        catch (SVNException ex) {
            Log.logErrorRB("SVN_ERROR", "update", ex.getMessage());
            this.checkNetworkException((Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            Log.logErrorRB("SVN_ERROR", "update", ex.getMessage());
            throw ex;
        }
    }

    public void checkoutFullProject(String repositoryURL) throws Exception {
        Log.logInfoRB("SVN_START", "checkout");
        SVNURL url = SVNURL.parseURIDecoded((String)repositoryURL);
        try {
            this.ourClientManager.getUpdateClient().doCheckout(url, this.baseDirectory, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, false);
            Log.logInfoRB("SVN_FINISH", "checkout");
        }
        catch (SVNAuthenticationException ex) {
            Log.logWarningRB("TEAM_WRONG_AUTHENTICATION", new Object[0]);
            throw new IRemoteRepository.AuthenticationException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            Log.logErrorRB("SVN_ERROR", "checkout", ex.getMessage());
            throw ex;
        }
    }

    public String getBaseRevisionId(File file) throws Exception {
        SVNInfo info = this.ourClientManager.getWCClient().doInfo(file, SVNRevision.BASE);
        return Long.toString(info.getCommittedRevision().getNumber());
    }

    public void restoreBase(File[] files) throws Exception {
        this.ourClientManager.getWCClient().doRevert(files, SVNDepth.EMPTY, null);
    }

    public void download(File[] files) throws SocketException, Exception {
        Log.logInfoRB("SVN_START", "download");
        try {
            this.ourClientManager.getUpdateClient().doUpdate(files, SVNRevision.HEAD, SVNDepth.INFINITY, false, false);
            Log.logInfoRB("SVN_FINISH", "download");
        }
        catch (SVNException ex) {
            Log.logErrorRB("SVN_ERROR", "download", ex.getMessage());
            this.checkNetworkException((Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            Log.logErrorRB("SVN_ERROR", "download", ex.getMessage());
            throw ex;
        }
    }

    public void reset() throws Exception {
        this.ourClientManager.getWCClient().doRevert(new File[]{this.baseDirectory}, SVNDepth.INFINITY, (Collection)null);
    }

    public void upload(File file, String commitMessage) throws SocketException, Exception {
        if (this.readOnly) {
            Log.logInfoRB("SVN_READONLY", new Object[0]);
            return;
        }
        Log.logInfoRB("SVN_START", "upload");
        try {
            this.ourClientManager.getCommitClient().doCommit(new File[]{file}, false, commitMessage, null, null, false, false, SVNDepth.INFINITY);
            Log.logInfoRB("SVN_FINISH", "upload");
        }
        catch (SVNAuthenticationException ex) {
            Log.logWarningRB("SVN_ERROR", "update", ex.getMessage());
            throw new IRemoteRepository.AuthenticationException((Exception)((Object)ex));
        }
        catch (SVNException ex) {
            if (ex.getErrorMessage().getErrorCode() == SVNErrorCode.FS_CONFLICT) {
                Log.logWarningRB("SVN_CONFLICT", new Object[0]);
                return;
            }
            Log.logErrorRB("SVN_ERROR", "upload", ex.getMessage());
            this.checkNetworkException((Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            Log.logErrorRB("SVN_ERROR", "upload", ex.getMessage());
            throw ex;
        }
    }

    void checkNetworkException(Exception ex) throws IRemoteRepository.NetworkException {
        SVNException se;
        if (ex.getCause() instanceof SocketException) {
            throw new IRemoteRepository.NetworkException(ex.getCause());
        }
        if (ex instanceof SVNException && (se = (SVNException)((Object)ex)).getErrorMessage().getErrorCode().getCategory() == 175000) {
            throw new IRemoteRepository.NetworkException(se);
        }
    }
}

