/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team;

import org.omegat.core.Core;
import org.omegat.core.team.IRemoteRepository;
import org.omegat.gui.dialogs.TeamUserPassDialog;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DockingUI;

public class RepositoryUtils {
    public static boolean askForCredentials(IRemoteRepository repository, String message) {
        TeamUserPassDialog userPassDialog = new TeamUserPassDialog(Core.getMainWindow().getApplicationFrame());
        DockingUI.displayCentered(userPassDialog);
        userPassDialog.descriptionTextArea.setText(message);
        userPassDialog.setVisible(true);
        if (userPassDialog.getReturnStatus() == 1) {
            repository.setCredentials(userPassDialog.userText.getText(), new String(userPassDialog.passwordField.getPassword()), userPassDialog.cbForceSavePlainPassword.isSelected());
            repository.setReadOnly(userPassDialog.cbReadOnly.isSelected());
            return true;
        }
        return false;
    }

    public static abstract class AskCredentials {
        public void execute(IRemoteRepository repository) throws Exception {
            boolean firstPass = true;
            while (true) {
                try {
                    this.callRepository();
                }
                catch (IRemoteRepository.AuthenticationException ex) {
                    boolean entered = RepositoryUtils.askForCredentials(repository, OStrings.getString(firstPass ? "TEAM_USERPASS_FIRST" : "TEAM_USERPASS_WRONG"));
                    if (!entered) {
                        throw ex;
                    }
                    firstPass = false;
                    continue;
                }
                break;
            }
        }

        protected abstract void callRepository() throws Exception;
    }
}

