/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.omegat.core.Core;
import org.omegat.core.team.IRemoteRepository;
import org.omegat.gui.dialogs.TeamUserPassDialog;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DockingUI;

public class GITRemoteRepository
implements IRemoteRepository {
    protected static String LOCAL_BRANCH = "master";
    protected static String REMOTE_BRANCH = "origin/master";
    protected static String REMOTE = "origin";
    boolean readOnly;
    File localDirectory;
    protected Repository repository;
    private MyCredentialsProvider myCredentialsProvider;
    static ProgressMonitor gitProgress = new ProgressMonitor(){

        public void update(int completed) {
            System.out.println("update: " + completed);
        }

        public void start(int totalTasks) {
            System.out.println("start: " + totalTasks);
        }

        public boolean isCancelled() {
            return false;
        }

        public void endTask() {
            System.out.println("endTask");
        }

        public void beginTask(String title, int totalWork) {
            System.out.println("beginTask: " + title + " total: " + totalWork);
        }
    };

    public static boolean isGITDirectory(File localDirectory) {
        return GITRemoteRepository.getLocalRepositoryRoot(localDirectory) != null;
    }

    public boolean isFilesLockingAllowed() {
        return false;
    }

    public GITRemoteRepository(File localDirectory) throws Exception {
        try {
            localDirectory = localDirectory.getCanonicalFile();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.localDirectory = localDirectory;
        this.myCredentialsProvider = new MyCredentialsProvider(this);
        CredentialsProvider.setDefault((CredentialsProvider)this.myCredentialsProvider);
        File localRepositoryDirectory = GITRemoteRepository.getLocalRepositoryRoot(localDirectory);
        if (localRepositoryDirectory != null) {
            this.repository = Git.open((File)localRepositoryDirectory).getRepository();
        }
    }

    public void checkoutFullProject(String repositoryURL) throws Exception {
        CloneCommand c = Git.cloneRepository();
        c.setURI(repositoryURL);
        c.setDirectory(this.localDirectory);
        try {
            c.call();
        }
        catch (InvalidRemoteException e) {
            Throwable cause;
            if (this.localDirectory.exists()) {
                GITRemoteRepository.deleteDirectory(this.localDirectory);
            }
            if ((cause = e.getCause()) != null && cause instanceof NoRemoteRepositoryException) {
                IRemoteRepository.BadRepositoryException bre = new IRemoteRepository.BadRepositoryException(((NoRemoteRepositoryException)cause).getLocalizedMessage());
                bre.initCause(e);
                throw bre;
            }
            throw e;
        }
        this.repository = Git.open((File)this.localDirectory).getRepository();
        new Git(this.repository).submoduleInit().call();
        new Git(this.repository).submoduleUpdate().call();
        StoredConfig config = this.repository.getConfig();
        if ("\r\n".equals(FileUtil.LINE_SEPARATOR)) {
            config.setBoolean("core", null, "autocrlf", true);
        } else {
            config.setString("core", null, "autocrlf", "input");
        }
        config.save();
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    GITRemoteRepository.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public boolean isChanged(File file) throws Exception {
        String relativeFile = FileUtil.computeRelativePath(this.repository.getWorkTree(), file);
        Status status = new Git(this.repository).status().call();
        return status.getModified().contains(relativeFile);
    }

    public boolean isUnderVersionControl(File file) throws Exception {
        String relativeFile = FileUtil.computeRelativePath(this.repository.getWorkTree(), file);
        Status status = new Git(this.repository).status().call();
        return status.getUntracked().contains(relativeFile);
    }

    public void setCredentials(String username, String password, boolean forceSavePlainPassword) {
    }

    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    public String getBaseRevisionId(File file) throws Exception {
        RevWalk walk = new RevWalk(this.repository);
        Ref localBranch = this.repository.getRef("HEAD");
        Ref remoteBranch = this.repository.getRef(REMOTE_BRANCH);
        RevCommit headCommit = walk.lookupCommit((AnyObjectId)localBranch.getObjectId());
        RevCommit upstreamCommit = walk.lookupCommit((AnyObjectId)remoteBranch.getObjectId());
        LogCommand cmd = new Git(this.repository).log().addRange((AnyObjectId)upstreamCommit, (AnyObjectId)headCommit);
        Iterable commitsToUse = cmd.call();
        RevCommit last = null;
        Iterator i$ = commitsToUse.iterator();
        while (i$.hasNext()) {
            RevCommit commit;
            last = commit = (RevCommit)i$.next();
        }
        RevCommit commonBase = last != null ? last.getParent(0) : upstreamCommit;
        return commonBase.getName();
    }

    public void restoreBase(File[] files) throws Exception {
        String baseRevisionId = this.getBaseRevisionId(files[0]);
        CheckoutCommand checkoutCommand = new Git(this.repository).checkout();
        for (File f : files) {
            String relativeFileName = FileUtil.computeRelativePath(this.repository.getWorkTree(), f);
            checkoutCommand.addPath(relativeFileName);
        }
        checkoutCommand.call();
        new Git(this.repository).checkout().setName(baseRevisionId).call();
    }

    public void reset() throws Exception {
        new Git(this.repository).reset().setMode(ResetCommand.ResetType.HARD).call();
    }

    public void updateFullProject() throws IRemoteRepository.NetworkException, Exception {
        Log.logInfoRB("GIT_START", "pull");
        try {
            new Git(this.repository).fetch().call();
            new Git(this.repository).checkout().setName(REMOTE_BRANCH).call();
            new Git(this.repository).branchDelete().setBranchNames(new String[]{LOCAL_BRANCH}).setForce(true).call();
            new Git(this.repository).checkout().setStartPoint(REMOTE_BRANCH).setCreateBranch(true).setName(LOCAL_BRANCH).setForce(true).call();
            new Git(this.repository).submoduleUpdate().call();
            Log.logInfoRB("GIT_FINISH", "pull");
        }
        catch (Exception ex) {
            Log.logErrorRB("GIT_ERROR", "pull", ex.getMessage());
            this.checkAndThrowException(ex);
        }
    }

    public void download(File[] files) throws IRemoteRepository.NetworkException, Exception {
        Log.logInfoRB("GIT_START", "download");
        try {
            new Git(this.repository).fetch().call();
            new Git(this.repository).checkout().setName(REMOTE_BRANCH).call();
            new Git(this.repository).branchDelete().setBranchNames(new String[]{LOCAL_BRANCH}).setForce(true).call();
            new Git(this.repository).checkout().setStartPoint(REMOTE_BRANCH).setCreateBranch(true).setName(LOCAL_BRANCH).setForce(true).call();
            Log.logInfoRB("GIT_FINISH", "download");
        }
        catch (Exception ex) {
            Log.logErrorRB("GIT_ERROR", "download", ex.getMessage());
            this.checkAndThrowException(ex);
        }
    }

    public void upload(File file, String commitMessage) throws IRemoteRepository.NetworkException, Exception {
        if (this.readOnly) {
            Log.logInfoRB("GIT_READONLY", new Object[0]);
            return;
        }
        boolean ok = true;
        Log.logInfoRB("GIT_START", "upload");
        try {
            if (!this.isChanged(file)) {
                Log.logInfoRB("GIT_FINISH", "upload(not changed)");
                return;
            }
            String filePattern = FileUtil.computeRelativePath(this.repository.getWorkTree(), file);
            new Git(this.repository).add().addFilepattern(filePattern).call();
            new Git(this.repository).commit().setMessage(commitMessage).call();
            Iterable results = new Git(this.repository).push().setRemote(REMOTE).add(LOCAL_BRANCH).call();
            int count = 0;
            for (PushResult r : results) {
                for (RemoteRefUpdate update : r.getRemoteUpdates()) {
                    ++count;
                    if (update.getStatus() == RemoteRefUpdate.Status.OK) continue;
                    ok = false;
                }
            }
            if (count < 1) {
                ok = false;
            }
            Log.logInfoRB("GIT_FINISH", "upload");
        }
        catch (Exception ex) {
            Log.logErrorRB("GIT_ERROR", "upload", ex.getMessage());
            this.checkAndThrowException(ex);
        }
        if (!ok) {
            Log.logWarningRB("GIT_CONFLICT", new Object[0]);
        }
    }

    private void checkAndThrowException(Exception ex) throws IRemoteRepository.NetworkException, Exception {
        if (ex instanceof TransportException) {
            throw new IRemoteRepository.NetworkException(ex);
        }
        throw ex;
    }

    private static File getLocalRepositoryRoot(File path) {
        if (path == null) {
            return null;
        }
        File possibleControlDir = new File(path, ".git");
        if (possibleControlDir.exists() && possibleControlDir.isDirectory()) {
            return path;
        }
        return GITRemoteRepository.getLocalRepositoryRoot(path.getAbsoluteFile().getParentFile());
    }

    private class MyCredentialsProvider
    extends CredentialsProvider {
        GITRemoteRepository gitRemoteRepository;
        String credentialsFilename;
        private final String pkey_username = "username";
        private final String pkey_password = "password";
        private final String pkey_fingerprint = "RSAkeyfingerprint";
        private String username;
        private char[] password;
        private String fingerprint;
        private boolean saveCredentialsToPlainText = false;

        public MyCredentialsProvider(GITRemoteRepository repo) {
            this.gitRemoteRepository = repo;
            this.readCredentials();
        }

        private void readCredentials() {
            this.credentialsFilename = this.gitRemoteRepository.localDirectory + File.separator + "credentials.properties";
            File credentialsFile = new File(this.credentialsFilename);
            if (credentialsFile.canRead()) {
                Properties p = new Properties();
                try {
                    p.load(new FileInputStream(credentialsFile));
                    this.username = p.getProperty("username");
                    this.password = p.getProperty("password").toCharArray();
                    this.fingerprint = p.getProperty("RSAkeyfingerprint");
                    this.saveCredentialsToPlainText = true;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private void saveCredentialsToPlainTextFile() {
            Properties p = new Properties();
            p.setProperty("username", this.username);
            p.setProperty("password", String.valueOf(this.password));
            if (this.fingerprint != null) {
                p.setProperty("RSAkeyfingerprint", this.fingerprint);
            }
            File credentialsFile = new File(this.credentialsFilename);
            try {
                if (!credentialsFile.exists()) {
                    credentialsFile.createNewFile();
                }
                p.store(new FileOutputStream(credentialsFile), "git remote access credentials for OmegaT project");
            }
            catch (FileNotFoundException e) {
                Core.getMainWindow().displayErrorRB(e, "TEAM_ERROR_SAVE_CREDENTIALS", null, "TF_ERROR");
            }
            catch (IOException e) {
                Core.getMainWindow().displayErrorRB(e, "TEAM_ERROR_SAVE_CREDENTIALS", null, "TF_ERROR");
            }
        }

        public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
            boolean ok = false;
            for (CredentialItem i : items) {
                if (i instanceof CredentialItem.Username) {
                    if (this.username == null && !(ok = this.askCredentials(uri.getUser()))) {
                        throw new UnsupportedCredentialItem(uri, OStrings.getString("TEAM_CREDENTIALS_DENIED"));
                    }
                    ((CredentialItem.Username)i).setValue(this.username);
                    continue;
                }
                if (i instanceof CredentialItem.Password) {
                    if (this.password == null && !(ok = this.askCredentials(uri.getUser()))) {
                        throw new UnsupportedCredentialItem(uri, OStrings.getString("TEAM_CREDENTIALS_DENIED"));
                    }
                    ((CredentialItem.Password)i).setValue(this.password);
                    if (this.password == null) continue;
                    uri.setPass(new String(this.password));
                    continue;
                }
                if (i instanceof CredentialItem.StringType) {
                    if (i.getPromptText().equals("Password: ")) {
                        if (this.password == null && !ok && !(ok = this.askCredentials(uri.getUser()))) {
                            throw new UnsupportedCredentialItem(uri, OStrings.getString("TEAM_CREDENTIALS_DENIED"));
                        }
                        ((CredentialItem.StringType)i).setValue(new String(this.password));
                        continue;
                    }
                } else {
                    if (i instanceof CredentialItem.YesNoType) {
                        int end;
                        int start;
                        String promptText = i.getPromptText();
                        String promptedFingerprint = null;
                        Pattern p = Pattern.compile("The authenticity of host '.*' can't be established\\.\\nRSA key fingerprint is (([0-9a-f]{2}:){15}[0-9a-f]{2})\\.\\nAre you sure you want to continue connecting\\?");
                        Matcher fingerprintMatcher = p.matcher(promptText);
                        if (fingerprintMatcher.find() && (promptedFingerprint = promptText.substring(start = fingerprintMatcher.start(1), end = fingerprintMatcher.end(1))).equals(this.fingerprint)) {
                            ((CredentialItem.YesNoType)i).setValue(true);
                            continue;
                        }
                        int choice = Core.getMainWindow().showConfirmDialog(promptText, null, 0, 2);
                        if (choice == 0) {
                            ((CredentialItem.YesNoType)i).setValue(true);
                            if (promptedFingerprint != null) {
                                this.fingerprint = promptedFingerprint;
                            }
                            if (!this.saveCredentialsToPlainText) continue;
                            this.saveCredentialsToPlainTextFile();
                            continue;
                        }
                        ((CredentialItem.YesNoType)i).setValue(false);
                        continue;
                    }
                    if (i instanceof CredentialItem.InformationalMessage) {
                        Core.getMainWindow().showMessageDialog(i.getPromptText());
                        continue;
                    }
                }
                throw new UnsupportedCredentialItem(uri, i.getClass().getName() + ":" + i.getPromptText());
            }
            return true;
        }

        public boolean isInteractive() {
            return true;
        }

        public boolean supports(CredentialItem ... items) {
            for (CredentialItem i : items) {
                if (i instanceof CredentialItem.Username || i instanceof CredentialItem.Password) continue;
                return false;
            }
            return true;
        }

        private boolean askCredentials(String usernameInUri) {
            TeamUserPassDialog userPassDialog = new TeamUserPassDialog(Core.getMainWindow().getApplicationFrame());
            DockingUI.displayCentered(userPassDialog);
            userPassDialog.descriptionTextArea.setText(OStrings.getString(this.username == null ? "TEAM_USERPASS_FIRST" : "TEAM_USERPASS_WRONG"));
            if (usernameInUri != null && !"".equals(usernameInUri)) {
                userPassDialog.userText.setText(usernameInUri);
                userPassDialog.userText.setEditable(false);
                userPassDialog.userText.setEnabled(false);
            }
            userPassDialog.setVisible(true);
            if (userPassDialog.getReturnStatus() == 1) {
                this.username = userPassDialog.userText.getText();
                this.password = userPassDialog.passwordField.getPassword();
                this.gitRemoteRepository.setReadOnly(userPassDialog.cbReadOnly.isSelected());
                this.saveCredentialsToPlainText = userPassDialog.cbForceSavePlainPassword.isSelected();
                if (this.saveCredentialsToPlainText) {
                    this.saveCredentialsToPlainTextFile();
                }
                return true;
            }
            return false;
        }

        public void reset(URIish uri) {
            this.username = null;
            this.password = null;
        }
    }
}

