/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.BreakIterator;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.IProject;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.Tokenizer;
import org.omegat.util.Log;
import org.omegat.util.PatternConsts;
import org.omegat.util.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics {
    protected static final int PERCENT_EXACT_MATCH = 101;
    protected static final int PERCENT_REPETITIONS = 102;

    public static Map<String, Token[]> buildExternalSourceTexts(final Map<String, Token[]> tokensCache) {
        final HashMap<String, Token[]> res = new HashMap<String, Token[]>();
        IProject project = Core.getProject();
        project.iterateByDefaultTranslations(new IProject.DefaultTranslationsIterator(){

            public void iterate(String source, TMXEntry en) {
                res.put(en.source, Statistics.tokenizeExactlyWithCache(tokensCache, en.source));
            }
        });
        project.iterateByMultipleTranslations(new IProject.MultipleTranslationsIterator(){

            public void iterate(EntryKey source, TMXEntry en) {
                res.put(en.source, Statistics.tokenizeExactlyWithCache(tokensCache, en.source));
            }
        });
        for (ExternalTMX tmFile : project.getTransMemories().values()) {
            for (int i = 0; i < tmFile.getEntries().size(); ++i) {
                TMXEntry tm = tmFile.getEntries().get(i);
                res.put(tm.source, Statistics.tokenizeExactlyWithCache(tokensCache, tm.source));
            }
        }
        return res;
    }

    public static Token[] tokenizeExactlyWithCache(Map<String, Token[]> tokensCache, String str) {
        Token[] result = tokensCache.get(str);
        if (result == null) {
            result = Core.getProject().getSourceTokenizer().tokenizeAllExactly(str);
            tokensCache.put(str, result);
        }
        return result;
    }

    public static int numberOfCharactersWithoutSpaces(String str) {
        int chars = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isSpaceChar(str.charAt(i))) continue;
            ++chars;
        }
        return chars;
    }

    public static int numberOfWords(String str) {
        int len = str.length();
        if (len == 0) {
            return 0;
        }
        int nTokens = 0;
        BreakIterator breaker = Tokenizer.getWordBreaker();
        breaker.setText(str);
        String tokenStr = new String();
        int start = breaker.first();
        int end = breaker.next();
        while (end != -1) {
            tokenStr = str.substring(start, end);
            boolean word = false;
            for (int i = 0; i < tokenStr.length(); ++i) {
                char ch = tokenStr.charAt(i);
                if (!Character.isLetterOrDigit(ch)) continue;
                word = true;
                break;
            }
            if (word && !PatternConsts.OMEGAT_TAG.matcher(tokenStr).matches()) {
                ++nTokens;
            }
            start = end;
            end = breaker.next();
        }
        return nTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStat(String filename, String text) {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8");
            try {
                out.write(DateFormat.getInstance().format(new Date()) + "\n");
                out.write(text);
                out.flush();
            }
            finally {
                out.close();
            }
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }
}

