/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.spellchecker.ISpellChecker;
import org.omegat.core.spellchecker.ISpellCheckerProvider;
import org.omegat.core.spellchecker.SpellCheckerDummy;
import org.omegat.core.spellchecker.SpellCheckerHunspell;
import org.omegat.core.spellchecker.SpellCheckerJMySpell;
import org.omegat.util.Log;
import org.omegat.util.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellChecker
implements ISpellChecker {
    private ISpellCheckerProvider checker;
    private List<String> ignoreList = new ArrayList<String>();
    private List<String> learnedList = new ArrayList<String>();
    private final Set<String> correctWordsCache = new HashSet<String>();
    private final Set<String> incorrectWordsCache = new HashSet<String>();
    private String ignoreFileName;
    private String learnedFileName;

    public SpellChecker() {
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                switch (eventType) {
                    case LOAD: 
                    case CREATE: {
                        SpellChecker.this.initialize();
                        break;
                    }
                    case CLOSE: {
                        SpellChecker.this.destroy();
                    }
                }
                SpellChecker.this.resetCache();
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            public void onNewFile(String activeFileName) {
                SpellChecker.this.resetCache();
            }

            public void onEntryActivated(SourceTextEntry newEntry) {
            }
        });
    }

    @Override
    public void initialize() {
        String language = Core.getProject().getProjectProperties().getTargetLanguage().getLocaleCode();
        String dictionaryDir = Preferences.getPreference("spellcheker_dir");
        if (dictionaryDir != null) {
            String affixName = dictionaryDir + File.separator + language + ".aff";
            String dictionaryName = dictionaryDir + File.separator + language + ".dic";
            String projectDir = Core.getProject().getProjectProperties().getProjectInternal();
            this.ignoreFileName = projectDir + "ignored_words.txt";
            this.ignoreList = new ArrayList<String>();
            this.fillWordList(this.ignoreFileName, this.ignoreList);
            this.learnedFileName = projectDir + "learned_words.txt";
            this.learnedList = new ArrayList<String>();
            this.fillWordList(this.learnedFileName, this.learnedList);
            this.checker = null;
            if (new File(dictionaryName).exists()) {
                try {
                    this.checker = new SpellCheckerHunspell(language, dictionaryName, affixName);
                }
                catch (Exception ex) {
                    Log.log("Error loading hunspell: " + ex.getMessage());
                }
                catch (Error err) {
                    Log.log("Error loading hunspell: " + err.getMessage());
                }
                if (this.checker == null) {
                    try {
                        this.checker = new SpellCheckerJMySpell(language, dictionaryName, affixName);
                    }
                    catch (Exception ex) {
                        Log.log("Error loading jmyspell: " + ex.getMessage());
                    }
                }
            }
            if (this.checker == null) {
                this.checker = new SpellCheckerDummy();
                Log.log("No spell checker loaded");
            }
            for (String w : this.learnedList) {
                this.checker.learnWord(w);
            }
        }
    }

    @Override
    public void destroy() {
        this.saveWordLists();
        this.checker.destroy();
        this.checker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCache() {
        SpellChecker spellChecker = this;
        synchronized (spellChecker) {
            this.incorrectWordsCache.clear();
            this.correctWordsCache.clear();
        }
    }

    @Override
    public void saveWordLists() {
        this.dumpWordList(this.ignoreList, this.ignoreFileName);
        this.dumpWordList(this.learnedList, this.learnedFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillWordList(String filename, List<String> list) {
        BufferedReader br = null;
        try {
            String thisLine;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            while ((thisLine = br.readLine()) != null) {
                list.add(thisLine);
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpWordList(List<String> list, String filename) {
        if (filename == null) {
            return;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            for (String text : list) {
                bw.write(text);
                bw.newLine();
            }
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCorrect(String word) {
        if (this.checker == null) {
            return true;
        }
        SpellChecker spellChecker = this;
        synchronized (spellChecker) {
            if (this.incorrectWordsCache.contains(word)) {
                return false;
            }
            if (this.correctWordsCache.contains(word)) {
                return true;
            }
        }
        boolean isCorrect = this.learnedList.contains(word) || this.ignoreList.contains(word) ? true : this.checker.isCorrect(word);
        SpellChecker spellChecker2 = this;
        synchronized (spellChecker2) {
            if (isCorrect) {
                this.correctWordsCache.add(word);
            } else {
                this.incorrectWordsCache.add(word);
            }
        }
        return isCorrect;
    }

    @Override
    public List<String> suggest(String word) {
        if (this.isCorrect(word)) {
            return Collections.EMPTY_LIST;
        }
        return this.checker.suggest(word);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ignoreWord(String word) {
        if (!this.ignoreList.contains(word)) {
            this.ignoreList.add(word);
            SpellChecker spellChecker = this;
            synchronized (spellChecker) {
                this.incorrectWordsCache.remove(word);
                this.correctWordsCache.add(word);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void learnWord(String word) {
        if (!this.learnedList.contains(word)) {
            this.learnedList.add(word);
            this.checker.learnWord(word);
            SpellChecker spellChecker = this;
            synchronized (spellChecker) {
                this.incorrectWordsCache.remove(word);
                this.correctWordsCache.add(word);
            }
        }
    }
}

