/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.segmentation.Rule;
import org.omegat.core.segmentation.SRX;
import org.omegat.util.Language;
import org.omegat.util.PatternConsts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Segmenter {
    public static SRX srx;
    private static Pattern DEFAULT_BEFOREBREAK_PATTERN;
    private static final Set<String> CJK_LANGUAGES;

    private Segmenter() {
    }

    public static List<String> segment(Language lang, String paragraph, List<StringBuffer> spaces, List<Rule> brules) {
        List<String> segments = Segmenter.breakParagraph(lang, paragraph, brules);
        ArrayList<String> sentences = new ArrayList<String>(segments.size());
        if (spaces == null) {
            spaces = new ArrayList<StringBuffer>();
        }
        spaces.clear();
        for (String one : segments) {
            int e;
            int b;
            int len = one.length();
            StringBuffer bs = new StringBuffer();
            for (b = 0; b < len && Character.isWhitespace(one.charAt(b)); ++b) {
                bs.append(one.charAt(b));
            }
            StringBuffer es = new StringBuffer();
            for (e = len - 1; e >= b && Character.isWhitespace(one.charAt(e)); --e) {
                es.append(one.charAt(e));
            }
            es.reverse();
            String trimmed = one.substring(b, e + 1);
            sentences.add(trimmed);
            if (spaces == null) continue;
            spaces.add(bs);
            spaces.add(es);
        }
        return sentences;
    }

    private static List<String> breakParagraph(Language lang, String paragraph, List<Rule> brules) {
        List<Rule> rules = srx.lookupRulesForLanguage(lang);
        if (brules == null) {
            brules = new ArrayList<Rule>();
        }
        TreeSet<BreakPosition> dontbreakpositions = new TreeSet<BreakPosition>();
        TreeSet<BreakPosition> breakpositions = new TreeSet<BreakPosition>();
        for (int i = rules.size() - 1; i >= 0; --i) {
            Rule rule = rules.get(i);
            List<BreakPosition> rulebreaks = Segmenter.getBreaks(paragraph, rule);
            if (rule.isBreakRule()) {
                breakpositions.addAll(rulebreaks);
                dontbreakpositions.removeAll(rulebreaks);
                continue;
            }
            dontbreakpositions.addAll(rulebreaks);
            breakpositions.removeAll(rulebreaks);
        }
        breakpositions.removeAll(dontbreakpositions);
        ArrayList<String> segments = new ArrayList<String>();
        brules.clear();
        int prevpos = 0;
        for (BreakPosition bposition : breakpositions) {
            String oneseg = paragraph.substring(prevpos, bposition.position);
            segments.add(oneseg);
            brules.add(bposition.reason);
            prevpos = bposition.position;
        }
        try {
            String oneseg = paragraph.substring(prevpos);
            if (oneseg.trim().length() == 0 && segments.size() > 0) {
                String prev = (String)segments.get(segments.size() - 1);
                prev = prev + oneseg;
                segments.set(segments.size() - 1, prev);
            } else {
                segments.add(oneseg);
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            // empty catch block
        }
        return segments;
    }

    private static List<BreakPosition> getBreaks(String paragraph, Rule rule) {
        ArrayList<BreakPosition> res = new ArrayList<BreakPosition>();
        Matcher bbm = null;
        if (rule.getBeforebreak() != null) {
            bbm = rule.getCompiledBeforebreak().matcher(paragraph);
        }
        Matcher abm = null;
        if (rule.getAfterbreak() != null) {
            abm = rule.getCompiledAfterbreak().matcher(paragraph);
        }
        if (bbm == null && abm == null) {
            return res;
        }
        if (abm != null && !abm.find()) {
            return res;
        }
        if (bbm == null) {
            bbm = DEFAULT_BEFOREBREAK_PATTERN.matcher(paragraph);
        }
        while (bbm.find()) {
            int bbe = bbm.end();
            if (abm == null) {
                res.add(new BreakPosition(bbe, rule));
                continue;
            }
            int abs = abm.start();
            while (abs < bbe) {
                boolean found = abm.find();
                if (!found) {
                    return res;
                }
                abs = abm.start();
            }
            if (abs != bbe) continue;
            res.add(new BreakPosition(bbe, rule));
        }
        return res;
    }

    public static String glue(Language sourceLang, Language targetLang, List<String> sentences, List<StringBuffer> spaces, List<Rule> brules) {
        if (sentences.size() <= 0) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        res.append(sentences.get(0));
        for (int i = 1; i < sentences.size(); ++i) {
            StringBuffer sp = new StringBuffer();
            sp.append(spaces.get(2 * i - 1));
            sp.append(spaces.get(2 * i));
            if (CJK_LANGUAGES.contains(targetLang.getLanguageCode().toUpperCase(Locale.ENGLISH))) {
                Rule rule = brules.get(i - 1);
                char lastChar = res.charAt(res.length() - 1);
                if (!(lastChar == '.' || PatternConsts.SPACY_REGEX.matcher(rule.getBeforebreak()).matches() && PatternConsts.SPACY_REGEX.matcher(rule.getAfterbreak()).matches())) {
                    sp.setLength(0);
                }
            } else if (CJK_LANGUAGES.contains(sourceLang.getLanguageCode().toUpperCase(Locale.ENGLISH)) && sp.length() == 0) {
                sp.append(" ");
            }
            res.append(sp);
            res.append(sentences.get(i));
        }
        return res.toString();
    }

    public static void segmentEntries(boolean needResegment, Language sourceLang, String sourceEntry, Language targetLang, String targetEntry, List<String> sourceSegments, List<String> targetSegments) {
        if (needResegment) {
            List<String> srcSegments = Segmenter.segment(sourceLang, sourceEntry, null, null);
            List<String> tarSegments = Segmenter.segment(targetLang, targetEntry, null, null);
            if (srcSegments.size() == tarSegments.size()) {
                sourceSegments.addAll(srcSegments);
                targetSegments.addAll(tarSegments);
                return;
            }
        }
        sourceSegments.add(sourceEntry);
        targetSegments.add(targetEntry);
    }

    static {
        DEFAULT_BEFOREBREAK_PATTERN = Pattern.compile(".", 32);
        CJK_LANGUAGES = new HashSet<String>();
        CJK_LANGUAGES.add("ZH");
        CJK_LANGUAGES.add("JA");
        CJK_LANGUAGES.add("KO");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BreakPosition
    implements Comparable<BreakPosition> {
        int position;
        Rule reason;

        BreakPosition(int position, Rule reason) {
            this.position = position;
            this.reason = reason;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BreakPosition)) {
                return false;
            }
            BreakPosition that = (BreakPosition)obj;
            return this.position == that.position;
        }

        public int hashCode() {
            return this.position;
        }

        @Override
        public int compareTo(BreakPosition that) {
            return this.position - that.position;
        }
    }
}

