/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.ITokenizer;
import org.omegat.core.matching.WordIterator;
import org.omegat.util.PatternConsts;
import org.omegat.util.Token;

public class Tokenizer
implements ITokenizer {
    private static Map<String, Token[]> tokenCache = new HashMap<String, Token[]>(5000);
    private static final Token[] EMPTY_TOKENS_LIST = new Token[0];

    public Tokenizer() {
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                    Map map = tokenCache;
                    synchronized (map) {
                        tokenCache.clear();
                    }
                }
            }
        });
    }

    public Token[] tokenizeWordsForSpelling(String str) {
        return Tokenizer.tokenizeTextNoCache(str, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token[] tokenizeWords(String strOrig, ITokenizer.StemmingMode stemmingMode) {
        Token[] result;
        Map<String, Token[]> map = tokenCache;
        synchronized (map) {
            result = tokenCache.get(strOrig);
        }
        if (result != null) {
            return result;
        }
        result = Tokenizer.tokenizeTextNoCache(strOrig, false);
        map = tokenCache;
        synchronized (map) {
            tokenCache.put(strOrig, result);
        }
        return result;
    }

    public Token[] tokenizeAllExactly(String strOrig) {
        return Tokenizer.tokenizeTextNoCache(strOrig, true);
    }

    private static Token[] tokenizeTextNoCache(String strOrig, boolean all) {
        if (strOrig.length() == 0) {
            return EMPTY_TOKENS_LIST;
        }
        ArrayList<Token> tokens = new ArrayList<Token>(64);
        String str = strOrig.toLowerCase();
        BreakIterator breaker = Tokenizer.getWordBreaker();
        breaker.setText(str);
        int start = breaker.first();
        int end = breaker.next();
        while (end != -1) {
            String tokenStr = str.substring(start, end);
            boolean word = false;
            for (int i = 0; i < tokenStr.length(); ++i) {
                char ch = tokenStr.charAt(i);
                if (!Character.isLetter(ch)) continue;
                word = true;
                break;
            }
            if (all || word && !PatternConsts.OMEGAT_TAG.matcher(tokenStr).matches()) {
                Token token = new Token(tokenStr, start);
                tokens.add(token);
            }
            start = end;
            end = breaker.next();
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    public static BreakIterator getWordBreaker() {
        return new WordIterator();
    }

    public static boolean isContains(Token[] tokensList, Token tokenForCheck) {
        for (Token t : tokensList) {
            if (!tokenForCheck.equals(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainsAll(Token[] tokensList, Token[] listForFind) {
        for (Token t : listForFind) {
            if (Tokenizer.isContains(tokensList, t)) continue;
            return false;
        }
        return true;
    }
}

