/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.util.LFileCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarDict
implements IDictionary {
    protected final File ifoFile;
    protected static final String UTF8 = "UTF-8";
    protected static final int BUFFER_SIZE = 65536;
    protected final String contentType;

    public StarDict(File ifoFile) throws Exception {
        this.ifoFile = ifoFile;
        Map<String, String> header = this.readIFO(ifoFile);
        String version = header.get("version");
        if (!"2.4.2".equals(version)) {
            throw new Exception("Invalid version of dictionary: " + version);
        }
        this.contentType = header.get("sametypesequence");
        if (!("g".equals(this.contentType) || "m".equals(this.contentType) || "x".equals(this.contentType) || "h".equals(this.contentType))) {
            throw new Exception("Invalid type of dictionary: " + this.contentType);
        }
    }

    @Override
    public Map<String, Object> readHeader() throws IOException {
        int b;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String f = this.ifoFile.getPath();
        if (f.endsWith(".ifo")) {
            f = f.substring(0, f.length() - 4);
        }
        File idxFile = new File(f + ".idx");
        File dataFile = new File(f + ".dict");
        byte[] idxBytes = this.readFile(idxFile);
        byte[] dataBytes = this.readFile(dataFile);
        DataInputStream idx = new DataInputStream(new ByteArrayInputStream(idxBytes));
        ByteArrayOutputStream mem = new ByteArrayOutputStream();
        while ((b = idx.read()) != -1) {
            if (b == 0) {
                String key = new String(mem.toByteArray(), 0, mem.size(), UTF8);
                mem.reset();
                int bodyOffset = idx.readInt();
                int bodyLength = idx.readInt();
                String text = this.readArticleText(dataBytes, bodyOffset, bodyLength);
                this.addArticle(key, text, result);
                continue;
            }
            mem.write(b);
        }
        return result;
    }

    private void addArticle(String key, String text, Map<String, Object> result) {
        String[] data = result.get(key);
        if (data == null) {
            data = text;
        } else if (data instanceof String[]) {
            String[] dobj = data;
            String[] d = new String[dobj.length + 1];
            System.arraycopy(dobj, 0, d, 0, dobj.length);
            d[d.length - 1] = text;
            data = d;
        } else {
            String[] d = new String[]{(String)data, text};
            data = d;
        }
        result.put(key, data);
    }

    @Override
    public String readArticle(String word, Object articleData) {
        return (String)articleData;
    }

    private String readArticleText(byte[] data, int off, int len) throws UnsupportedEncodingException {
        return new String(data, off, len, UTF8).replace("\n", "<br>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(File file) throws IOException {
        FilterInputStream in;
        if (file.exists()) {
            in = new BufferedInputStream(new FileInputStream(file), 65536);
        } else {
            File gzFile = new File(file.getPath() + ".gz");
            if (!gzFile.exists()) {
                gzFile = new File(file.getPath() + ".dz");
            }
            if (gzFile.exists()) {
                in = new GZIPInputStream(new BufferedInputStream(new FileInputStream(gzFile), 65536));
            } else {
                throw new FileNotFoundException(file.getPath());
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(65536);
        try {
            LFileCopy.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            ((InputStream)in).close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readIFO(File ifoFile) throws Exception {
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ifoFile), UTF8));
        try {
            String line = null;
            String first = rd.readLine();
            if (!"StarDict's dict ifo file".equals(first)) {
                throw new Exception("Invalid header of .ifo file: " + first);
            }
            TreeMap<String, String> result = new TreeMap<String, String>();
            while ((line = rd.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                int pos = line.indexOf(61);
                if (pos < 0) {
                    throw new Exception("Invalid format of .ifo file: " + line);
                }
                result.put(line.substring(0, pos), line.substring(pos + 1));
            }
            TreeMap<String, String> treeMap = result;
            return treeMap;
        }
        finally {
            rd.close();
        }
    }
}

