/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.omegat.core.dictionaries.IDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LingvoDSL
implements IDictionary {
    protected static final String CHARSET = "UTF-16";
    protected static final Pattern RE_SKIP = Pattern.compile("\\[.+?\\]");
    protected final File file;

    public LingvoDSL(File file) {
        this.file = file;
    }

    @Override
    public Map<String, Object> readHeader() throws Exception {
        String s;
        HashMap<String, Object> result = new HashMap<String, Object>();
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), CHARSET));
        StringBuilder word = new StringBuilder();
        StringBuilder trans = new StringBuilder();
        while ((s = rd.readLine()) != null) {
            if (s.length() == 0 || s.charAt(0) == '#') continue;
            if (Character.isWhitespace((s = RE_SKIP.matcher(s).replaceAll("")).charAt(0))) {
                trans.append(s).append('\n');
                continue;
            }
            if (word.length() > 0) {
                result.put(word.toString(), trans.toString());
                word.setLength(0);
                trans.setLength(0);
            }
            word.append(s);
        }
        if (word.length() > 0) {
            result.put(word.toString(), trans.toString());
        }
        return result;
    }

    @Override
    public String readArticle(String word, Object articleData) throws Exception {
        return (String)articleData;
    }
}

