/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.Map;
import org.omegat.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMXEntry {
    public final String source;
    public final String translation;
    public final String changer;
    public final long changeDate;
    public final String note;
    public final boolean defaultTranslation;
    public final Map<String, String> properties;

    public TMXEntry(String source, String translation, String changer, long changeDate, String note, boolean defaultTranslation, Map<String, String> properties) {
        this.source = source;
        this.translation = translation;
        this.changer = changer;
        this.changeDate = changeDate;
        this.note = note;
        this.defaultTranslation = defaultTranslation;
        this.properties = properties;
    }

    public TMXEntry(String source, String translation, String changer, long changeDate, String note, boolean defaultTranslation) {
        this(source, translation, changer, changeDate, note, defaultTranslation, null);
    }

    public boolean isTranslated() {
        return this.translation != null;
    }

    public boolean hasNote() {
        return this.note != null;
    }

    public boolean equalsTranslation(TMXEntry other) {
        if (other == null) {
            return false;
        }
        if (this.changeDate != other.changeDate) {
            return false;
        }
        if (!StringUtil.equalsWithNulls(this.translation, other.translation)) {
            return false;
        }
        if (!StringUtil.equalsWithNulls(this.changer, other.changer)) {
            return false;
        }
        return StringUtil.equalsWithNulls(this.note, other.note);
    }
}

