/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import com.martiansoftware.jsap.CommandLineTokenizer;
import gen.core.filters.Filters;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.KnownException;
import org.omegat.core.data.CommandVarExpansion;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.data.TranslateEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.ITokenizer;
import org.omegat.core.matching.Tokenizer;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.core.statistics.CalcStandardStatistics;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.core.team.IRemoteRepository;
import org.omegat.core.team.RepositoryUtils;
import org.omegat.core.threads.CommandMonitor;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IAlignCallback;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryReaderTSV;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.RuntimePreferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.UIThreadsUtil;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealProject
implements IProject {
    protected final ProjectProperties m_config;
    private final IRemoteRepository repository;
    private boolean isOnlineMode;
    private FileChannel lockChannel;
    private FileLock lock;
    private boolean m_modifiedFlag;
    private List<SourceTextEntry> allProjectEntries = new ArrayList<SourceTextEntry>(4096);
    private final StatisticsInfo hotStat = new StatisticsInfo();
    private final ITokenizer sourceTokenizer;
    private final ITokenizer targetTokenizer;
    private DirectoryMonitor tmMonitor;
    private DirectoryMonitor tmOtherLanguagesMonitor;
    private Map<String, ExternalTMX> transMemories = new TreeMap<String, ExternalTMX>();
    private Map<Language, ProjectTMX> otherTargetLangTMs = new TreeMap<Language, ProjectTMX>();
    protected ProjectTMX projectTMX;
    private Set<String> existSource = new HashSet<String>();
    private Set<EntryKey> existKeys = new HashSet<EntryKey>();
    protected final List<IProject.FileInfo> projectFilesList = new ArrayList<IProject.FileInfo>();
    private static final TMXEntry EMPTY_TRANSLATION = new TMXEntry("", null, null, 0L, null, true);
    private boolean allowTranslationEqualToSource = Preferences.isPreference("wf_allowTransEqualToSrc");
    private Stack<Process> processCache = new Stack();
    ProjectTMX.CheckOrphanedCallback checkOrphanedCallback = new ProjectTMX.CheckOrphanedCallback(){

        public boolean existSourceInProject(String src) {
            return RealProject.this.existSource.contains(src);
        }

        public boolean existEntryInProject(EntryKey key) {
            return RealProject.this.existKeys.contains(key);
        }
    };

    public RealProject(ProjectProperties props) {
        this(props, null);
    }

    public RealProject(ProjectProperties props, IRemoteRepository repository) {
        this.m_config = props;
        this.repository = repository;
        this.sourceTokenizer = this.createTokenizer(true);
        this.targetTokenizer = this.createTokenizer(false);
    }

    @Override
    public IRemoteRepository getRepository() {
        return this.repository;
    }

    @Override
    public void saveProjectProperties() throws Exception {
        this.unlockProject();
        ProjectFileStorage.writeProjectFile(this.m_config);
        this.lockProject();
        Preferences.setPreference("source_lang", this.m_config.getSourceLanguage().toString());
        Preferences.setPreference("target_lang", this.m_config.getTargetLanguage().toString());
    }

    public void createProject() {
        Log.logInfoRB("LOG_DATAENGINE_CREATE_START", new Object[0]);
        UIThreadsUtil.mustNotBeSwingThread();
        this.lockProject();
        try {
            this.createDirectory(this.m_config.getProjectRoot(), null);
            this.createDirectory(this.m_config.getProjectInternal(), "omegat");
            this.createDirectory(this.m_config.getSourceRoot(), "source");
            this.createDirectory(this.m_config.getGlossaryRoot(), "glossary");
            this.createDirectory(this.m_config.getTMRoot(), "tm");
            this.createDirectory(this.m_config.getTMAutoRoot(), "auto");
            this.createDirectory(this.m_config.getDictRoot(), "dictionary");
            this.createDirectory(this.m_config.getTargetRoot(), "target");
            this.saveProjectProperties();
            Segmenter.srx = this.m_config.getProjectSRX();
            if (Segmenter.srx == null) {
                Segmenter.srx = Preferences.getSRX();
            }
            this.loadTranslations();
            this.loadTM();
            this.loadOtherLanguages();
            this.allProjectEntries = Collections.unmodifiableList(this.allProjectEntries);
        }
        catch (Exception e) {
            Log.logErrorRB(e, "CT_ERROR_CREATING_PROJECT", new Object[0]);
            Core.getMainWindow().displayErrorRB(e, "CT_ERROR_CREATING_PROJECT", new Object[0]);
        }
        Log.logInfoRB("LOG_DATAENGINE_CREATE_END", new Object[0]);
    }

    public void loadProject(boolean onlineMode) {
        Log.logInfoRB("LOG_DATAENGINE_LOAD_START", new Object[0]);
        UIThreadsUtil.mustNotBeSwingThread();
        this.lockProject();
        this.isOnlineMode = onlineMode;
        try {
            Preferences.setPreference("current_folder", new File(this.m_config.getProjectRoot()).getParentFile().getAbsolutePath());
            Preferences.save();
            Core.getMainWindow().showStatusMessageRB("CT_LOADING_PROJECT", new Object[0]);
            Filters filterMasterConfig = FilterMaster.loadConfig(this.m_config.getProjectInternal());
            if (filterMasterConfig == null) {
                filterMasterConfig = FilterMaster.loadConfig(StaticUtils.getConfigDir());
            }
            if (filterMasterConfig == null) {
                filterMasterConfig = FilterMaster.createDefaultFiltersConfig();
            }
            Core.setFilterMaster(new FilterMaster(filterMasterConfig));
            Segmenter.srx = this.m_config.getProjectSRX();
            if (Segmenter.srx == null) {
                Segmenter.srx = Preferences.getSRX();
            }
            this.loadSourceFiles();
            this.loadTranslations();
            this.importTranslationsFromSources();
            this.loadTM();
            this.loadOtherLanguages();
            String stat = CalcStandardStatistics.buildProjectStats(this, this.hotStat);
            String fn = this.m_config.getProjectInternal() + "project_stats.txt";
            Statistics.writeStat(fn, stat);
            this.allProjectEntries = Collections.unmodifiableList(this.allProjectEntries);
            Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
            this.m_modifiedFlag = false;
        }
        catch (Exception e) {
            Log.logErrorRB(e, "TF_LOAD_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(e, "TF_LOAD_ERROR", new Object[0]);
        }
        catch (OutOfMemoryError oome) {
            this.allProjectEntries.clear();
            this.projectFilesList.clear();
            this.transMemories.clear();
            this.projectTMX = null;
            System.gc();
            Object[] args = new Object[]{Runtime.getRuntime().maxMemory() / 1024L / 1024L};
            Log.logErrorRB("OUT_OF_MEMORY", args);
            Log.log(oome);
            Core.getMainWindow().showErrorDialogRB("OUT_OF_MEMORY", args, "TF_ERROR");
            System.exit(0);
        }
        Log.logInfoRB("LOG_DATAENGINE_LOAD_END", new Object[0]);
    }

    public Map<String, TMXEntry> align(ProjectProperties props, File translatedDir) throws Exception {
        FilterMaster fm = Core.getFilterMaster();
        ArrayList<String> srcFileList = new ArrayList<String>();
        File root = new File(this.m_config.getSourceRoot());
        StaticUtils.buildFileList(srcFileList, root, true);
        AlignFilesCallback alignFilesCallback = new AlignFilesCallback(props);
        String srcRoot = this.m_config.getSourceRoot();
        for (String filename : srcFileList) {
            String midName = filename.substring(srcRoot.length());
            fm.alignFile(srcRoot, midName, translatedDir.getPath(), new FilterContext(props), alignFilesCallback);
        }
        return alignFilesCallback.data;
    }

    @Override
    public boolean isProjectLoaded() {
        return true;
    }

    @Override
    public StatisticsInfo getStatistics() {
        return this.hotStat;
    }

    @Override
    public void closeProject() {
        this.flushProcessCache();
        this.tmMonitor.fin();
        this.tmOtherLanguagesMonitor.fin();
        this.unlockProject();
        Log.logInfoRB("LOG_DATAENGINE_CLOSE", new Object[0]);
    }

    protected void lockProject() {
        if (!RuntimePreferences.isProjectLockingEnabled()) {
            return;
        }
        if (this.repository != null && !this.repository.isFilesLockingAllowed()) {
            return;
        }
        try {
            File lockFile = new File(this.m_config.getProjectRoot(), "omegat.project");
            this.lockChannel = new RandomAccessFile(lockFile, "rw").getChannel();
            this.lock = this.lockChannel.lock();
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    protected void unlockProject() {
        if (!RuntimePreferences.isProjectLockingEnabled()) {
            return;
        }
        if (this.repository != null && !this.repository.isFilesLockingAllowed()) {
            return;
        }
        try {
            this.lock.release();
            this.lockChannel.close();
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    @Override
    public void compileProject(String sourcePattern) throws IOException, TranslationException {
        this.compileProject(sourcePattern, true);
    }

    public void compileProject(String sourcePattern, boolean doPostProcessing) throws IOException, TranslationException {
        Log.logInfoRB("LOG_DATAENGINE_COMPILE_START", new Object[0]);
        UIThreadsUtil.mustNotBeSwingThread();
        Pattern FILE_PATTERN = Pattern.compile(sourcePattern);
        try {
            String fname = this.m_config.getProjectRoot() + this.m_config.getProjectName() + "-omegat" + ".tmx";
            this.projectTMX.exportTMX(this.m_config, new File(fname), false, false, false);
            fname = this.m_config.getProjectRoot() + this.m_config.getProjectName() + "-level1" + ".tmx";
            this.projectTMX.exportTMX(this.m_config, new File(fname), true, false, false);
            fname = this.m_config.getProjectRoot() + this.m_config.getProjectName() + "-level2" + ".tmx";
            this.projectTMX.exportTMX(this.m_config, new File(fname), false, true, false);
        }
        catch (Exception e) {
            Log.logErrorRB("CT_ERROR_CREATING_TMX", new Object[0]);
            Log.log(e);
            throw new IOException(OStrings.getString("CT_ERROR_CREATING_TMX") + "\n" + e.getMessage());
        }
        ArrayList<String> fileList = new ArrayList<String>(256);
        String srcRoot = this.m_config.getSourceRoot();
        String locRoot = this.m_config.getTargetRoot();
        StaticUtils.buildDirList(fileList, new File(srcRoot));
        for (String filename : fileList) {
            String destFileName = locRoot + filename.substring(srcRoot.length());
            File destFile = new File(destFileName);
            if (destFile.exists() || destFile.mkdir()) continue;
            throw new IOException(OStrings.getString("CT_ERROR_CREATING_TARGET_DIR") + destFileName);
        }
        FilterMaster fm = Core.getFilterMaster();
        fileList.clear();
        StaticUtils.buildFileList(fileList, new File(srcRoot), true);
        TranslateFilesCallback translateFilesCallback = new TranslateFilesCallback();
        for (String filename : fileList) {
            String midName = filename.substring(srcRoot.length());
            Matcher fileMatch = FILE_PATTERN.matcher(midName);
            if (!fileMatch.matches()) continue;
            Core.getMainWindow().showStatusMessageRB("CT_COMPILE_FILE_MX", midName);
            translateFilesCallback.fileStarted(midName);
            fm.translateFile(srcRoot, midName, locRoot, new FilterContext(this.m_config), translateFilesCallback);
            translateFilesCallback.fileFinished();
        }
        Core.getMainWindow().showStatusMessageRB("CT_COMPILE_DONE_MX", new Object[0]);
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.COMPILE);
        if (doPostProcessing) {
            this.flushProcessCache();
            if (Preferences.isPreference("allow_project_extern_cmd")) {
                this.doExternalCommand(this.m_config.getExternalCommand());
            }
            this.doExternalCommand(Preferences.getPreference("external_command"));
        }
        Log.logInfoRB("LOG_DATAENGINE_COMPILE_END", new Object[0]);
    }

    private void doExternalCommand(String command) {
        if (command == null || command.length() == 0) {
            return;
        }
        Core.getMainWindow().showStatusMessageRB("CT_START_EXTERNAL_CMD", new Object[0]);
        CommandVarExpansion expander = new CommandVarExpansion(command);
        command = expander.expandVariables(this.m_config);
        Log.log("Executing command: " + command);
        try {
            Process p = Runtime.getRuntime().exec(CommandLineTokenizer.tokenize((String)command));
            this.processCache.push(p);
            CommandMonitor stdout = CommandMonitor.StdoutMonitor(p);
            CommandMonitor stderr = CommandMonitor.StderrMonitor(p);
            stdout.start();
            stderr.start();
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            String message = cause == null ? e.getLocalizedMessage() : cause.getLocalizedMessage();
            Core.getMainWindow().showStatusMessageRB("CT_ERROR_STARTING_EXTERNAL_CMD", message);
        }
    }

    private void flushProcessCache() {
        while (!this.processCache.isEmpty()) {
            Process p = this.processCache.pop();
            try {
                p.exitValue();
            }
            catch (IllegalThreadStateException ex) {
                p.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void saveProject() {
        Log.logInfoRB("LOG_DATAENGINE_SAVE_START", new Object[0]);
        UIThreadsUtil.mustNotBeSwingThread();
        Core.getAutoSave().disable();
        try {
            Core.getMainWindow().getMainMenu().getProjectMenu().setEnabled(false);
            try {
                Preferences.save();
                String s = this.m_config.getProjectInternal() + "project_save.tmx";
                try {
                    this.saveProjectProperties();
                    this.projectTMX.save(this.m_config, s, this.isProjectModified());
                    if (this.repository != null) {
                        Core.getMainWindow().showStatusMessageRB("TEAM_SYNCHRONIZE", new Object[0]);
                        this.rebaseProject();
                    }
                    this.m_modifiedFlag = false;
                }
                catch (KnownException ex) {
                    throw ex;
                }
                catch (Exception e) {
                    Log.logErrorRB(e, "CT_ERROR_SAVING_PROJ", new Object[0]);
                    Core.getMainWindow().displayErrorRB(e, "CT_ERROR_SAVING_PROJ", new Object[0]);
                }
                String stat = CalcStandardStatistics.buildProjectStats(this, this.hotStat);
                String fn = this.m_config.getProjectInternal() + "project_stats.txt";
                Statistics.writeStat(fn, stat);
            }
            finally {
                Core.getMainWindow().getMainMenu().getProjectMenu().setEnabled(true);
            }
            CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.SAVE);
        }
        finally {
            Core.getAutoSave().enable();
        }
        Log.logInfoRB("LOG_DATAENGINE_SAVE_END", new Object[0]);
    }

    private void rebaseProject() throws Exception {
        File filenameGlossarywithLocalChangesOnHead;
        File filenameTMXwithLocalChangesOnHead;
        boolean updateGlossary;
        File[] modifiedFiles;
        List<GlossaryEntry> glossaryEntries = null;
        List<GlossaryEntry> baseGlossaryEntries = null;
        List<GlossaryEntry> headGlossaryEntries = null;
        String projectTMXFilename = this.m_config.getProjectInternal() + "project_save.tmx";
        final File projectTMXFile = new File(projectTMXFilename);
        boolean needUpload = false;
        String glossaryFilename = this.m_config.getWriteableGlossary();
        final File glossaryFile = new File(glossaryFilename);
        if (this.repository.isUnderVersionControl(glossaryFile)) {
            glossaryEntries = GlossaryReaderTSV.read(glossaryFile);
            modifiedFiles = new File[]{projectTMXFile, glossaryFile};
            updateGlossary = true;
        } else {
            modifiedFiles = new File[]{projectTMXFile};
            updateGlossary = false;
        }
        if (this.isProjectModified() || this.repository.isChanged(glossaryFile) || this.repository.isChanged(projectTMXFile)) {
            needUpload = true;
        }
        String baseRevTMX = this.repository.getBaseRevisionId(projectTMXFile);
        String baseRevGlossary = null;
        if (updateGlossary) {
            baseRevGlossary = this.repository.getBaseRevisionId(glossaryFile);
        }
        File filenameTMXwithLocalChangesOnBase = new File(projectTMXFilename + "-based_on_" + baseRevTMX + ".new");
        File filenameGlossarywithLocalChangesOnBase = null;
        this.projectTMX.exportTMX(this.m_config, filenameTMXwithLocalChangesOnBase, false, false, true);
        if (updateGlossary) {
            filenameGlossarywithLocalChangesOnBase = new File(glossaryFilename + "-based_on_" + baseRevGlossary + ".new");
            if (filenameGlossarywithLocalChangesOnBase.exists()) {
                filenameGlossarywithLocalChangesOnBase.delete();
                filenameGlossarywithLocalChangesOnBase.createNewFile();
            }
            for (GlossaryEntry ge : glossaryEntries) {
                GlossaryReaderTSV.append(filenameGlossarywithLocalChangesOnBase, ge);
            }
        }
        this.repository.restoreBase(modifiedFiles);
        ProjectTMX baseTMX = new ProjectTMX(this.m_config.getSourceLanguage(), this.m_config.getTargetLanguage(), this.m_config.isSentenceSegmentingEnabled(), projectTMXFile, null);
        if (updateGlossary) {
            baseGlossaryEntries = GlossaryReaderTSV.read(glossaryFile);
        }
        try {
            this.repository.reset();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.repository.download(modifiedFiles);
            this.setOnlineMode();
        }
        catch (IRemoteRepository.NetworkException ex) {
            this.setOfflineMode();
            needUpload = false;
        }
        catch (Exception ex) {
            needUpload = false;
        }
        String headRevTMX = this.repository.getBaseRevisionId(projectTMXFile);
        if (headRevTMX.equals(baseRevTMX)) {
            filenameTMXwithLocalChangesOnHead = filenameTMXwithLocalChangesOnBase;
            filenameTMXwithLocalChangesOnBase = null;
            baseTMX = null;
        } else {
            ProjectTMX headTMX = new ProjectTMX(this.m_config.getSourceLanguage(), this.m_config.getTargetLanguage(), this.m_config.isSentenceSegmentingEnabled(), projectTMXFile, null);
            this.projectTMX.calculateDeltaAndApply(baseTMX, headTMX);
            filenameTMXwithLocalChangesOnHead = new File(projectTMXFilename + "-based_on_" + headRevTMX + ".new");
            this.projectTMX.exportTMX(this.m_config, filenameTMXwithLocalChangesOnHead, false, false, true);
            headTMX = null;
        }
        if (updateGlossary) {
            String headRevGlossary = this.repository.getBaseRevisionId(glossaryFile);
            if (headRevGlossary.equals(baseRevGlossary)) {
                filenameGlossarywithLocalChangesOnHead = filenameGlossarywithLocalChangesOnBase;
                filenameGlossarywithLocalChangesOnBase = null;
                baseGlossaryEntries = null;
            } else {
                headGlossaryEntries = GlossaryReaderTSV.read(glossaryFile);
                ArrayList<GlossaryEntry> deltaAddedGlossaryLocal = new ArrayList<GlossaryEntry>(glossaryEntries);
                deltaAddedGlossaryLocal.removeAll(baseGlossaryEntries);
                ArrayList<GlossaryEntry> deltaRemovedGlossaryLocal = new ArrayList<GlossaryEntry>(baseGlossaryEntries);
                deltaRemovedGlossaryLocal.removeAll(glossaryEntries);
                headGlossaryEntries.addAll(deltaAddedGlossaryLocal);
                headGlossaryEntries.removeAll(deltaRemovedGlossaryLocal);
                filenameGlossarywithLocalChangesOnHead = new File(glossaryFilename + "-based_on_" + headRevGlossary + ".new");
                for (GlossaryEntry ge : headGlossaryEntries) {
                    GlossaryReaderTSV.append(filenameGlossarywithLocalChangesOnHead, ge);
                }
                headGlossaryEntries = null;
                baseGlossaryEntries = null;
                glossaryEntries = null;
            }
        } else {
            filenameGlossarywithLocalChangesOnHead = null;
        }
        projectTMXFile.delete();
        if (!filenameTMXwithLocalChangesOnHead.renameTo(projectTMXFile)) {
            throw new IOException("Error rename new file to tmx");
        }
        if (filenameTMXwithLocalChangesOnBase != null && !filenameTMXwithLocalChangesOnBase.delete()) {
            throw new IOException("Error remove old file");
        }
        if (updateGlossary) {
            glossaryFile.delete();
            if (!filenameGlossarywithLocalChangesOnHead.renameTo(glossaryFile)) {
                throw new IOException("Error rename new file to glossary");
            }
            if (filenameGlossarywithLocalChangesOnBase != null && !filenameGlossarywithLocalChangesOnBase.delete()) {
                throw new IOException("Error remove old glossary file");
            }
        }
        if (needUpload) {
            final String author = Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name"));
            try {
                new RepositoryUtils.AskCredentials(){

                    public void callRepository() throws Exception {
                        RealProject.this.repository.upload(projectTMXFile, "Translated by " + author);
                        if (updateGlossary) {
                            RealProject.this.repository.upload(glossaryFile, "Added glossaryitem(s) by " + author);
                        }
                    }
                }.execute(this.repository);
                this.setOnlineMode();
            }
            catch (IRemoteRepository.NetworkException ex) {
                this.setOfflineMode();
            }
            catch (Exception ex) {
                throw new KnownException(ex, "TEAM_SYNCHRONIZATION_ERROR", new Object[0]);
            }
        }
    }

    private void createDirectory(String dir, String dirType) throws IOException {
        File d = new File(dir);
        if (!d.isDirectory() && !d.mkdirs()) {
            StringBuilder msg = new StringBuilder(OStrings.getString("CT_ERROR_CREATE"));
            if (dirType != null) {
                msg.append("\n(.../").append(dirType).append("/)");
            }
            throw new IOException(msg.toString());
        }
    }

    private void loadTranslations() throws Exception {
        File tmxFile = new File(this.m_config.getProjectInternal() + "project_save.tmx");
        try {
            Core.getMainWindow().showStatusMessageRB("CT_LOAD_TMX", new Object[0]);
            this.projectTMX = new ProjectTMX(this.m_config.getSourceLanguage(), this.m_config.getTargetLanguage(), this.m_config.isSentenceSegmentingEnabled(), tmxFile, this.checkOrphanedCallback);
            if (tmxFile.exists()) {
                FileUtil.backupFile(tmxFile);
                FileUtil.removeOldBackups(tmxFile);
            }
        }
        catch (SAXParseException ex) {
            Log.logErrorRB(ex, "TMXR_FATAL_ERROR_WHILE_PARSING", ex.getLineNumber(), ex.getColumnNumber());
            throw ex;
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "TMXR_EXCEPTION_WHILE_PARSING", tmxFile.getAbsolutePath(), Log.getLogLocation());
            throw ex;
        }
    }

    private void loadSourceFiles() throws IOException, InterruptedIOException, TranslationException {
        long st = System.currentTimeMillis();
        FilterMaster fm = Core.getFilterMaster();
        ArrayList<String> srcFileList = new ArrayList<String>();
        File root = new File(this.m_config.getSourceRoot());
        StaticUtils.buildFileList(srcFileList, root, true);
        Collections.sort(srcFileList, new FileNameComparator());
        for (String filename : srcFileList) {
            String filepath = filename.substring(this.m_config.getSourceRoot().length());
            Core.getMainWindow().showStatusMessageRB("CT_LOAD_FILE_MX", filepath);
            LoadFilesCallback loadFilesCallback = new LoadFilesCallback(this.existSource, this.existKeys);
            IProject.FileInfo fi = new IProject.FileInfo();
            fi.filePath = filepath;
            loadFilesCallback.setCurrentFile(fi);
            IFilter filter = fm.loadFile(filename, new FilterContext(this.m_config), loadFilesCallback);
            loadFilesCallback.fileFinished();
            if (filter == null || fi.entries.size() <= 0) continue;
            fi.filterClass = filter.getClass();
            fi.filterFileFormatName = filter.getFileFormatName();
            try {
                fi.fileEncoding = filter.getInEncodingLastParsedFile();
            }
            catch (Error e) {
                fi.fileEncoding = "";
            }
            this.projectFilesList.add(fi);
        }
        this.findNonUniqueSegments();
        Core.getMainWindow().showStatusMessageRB("CT_LOAD_SRC_COMPLETE", new Object[0]);
        long en = System.currentTimeMillis();
        Log.log("Load project source files: " + (en - st) + "ms");
    }

    protected void findNonUniqueSegments() {
        HashMap<String, SourceTextEntry> exists = new HashMap<String, SourceTextEntry>(16384);
        for (IProject.FileInfo fi : this.projectFilesList) {
            for (int i = 0; i < fi.entries.size(); ++i) {
                SourceTextEntry ste = fi.entries.get(i);
                SourceTextEntry prevSte = (SourceTextEntry)exists.get(ste.getSrcText());
                if (prevSte == null) {
                    ste.duplicate = SourceTextEntry.DUPLICATE.NONE;
                } else if (prevSte.duplicate == SourceTextEntry.DUPLICATE.NONE) {
                    prevSte.duplicate = SourceTextEntry.DUPLICATE.FIRST;
                    ste.duplicate = SourceTextEntry.DUPLICATE.NEXT;
                } else {
                    ste.duplicate = SourceTextEntry.DUPLICATE.NEXT;
                }
                if (prevSte != null) continue;
                exists.put(ste.getSrcText(), ste);
            }
        }
    }

    void importTranslationsFromSources() {
        HashMap<String, String> allowToImport = new HashMap<String, String>();
        for (IProject.FileInfo fi : this.projectFilesList) {
            for (int i = 0; i < fi.entries.size(); ++i) {
                TMXEntry tr;
                SourceTextEntry ste = fi.entries.get(i);
                if (ste.getSourceTranslation() == null || ste.isSourceTranslationFuzzy() || ste.getSrcText().equals(ste.getSourceTranslation()) && !this.allowTranslationEqualToSource) continue;
                if (this.m_config.isSupportDefaultTranslations()) {
                    TMXEntry enDefault = this.projectTMX.getDefaultTranslation(ste.getSrcText());
                    if (enDefault == null) {
                        tr = new TMXEntry(ste.getSrcText(), ste.getSourceTranslation(), null, 0L, null, true);
                        this.projectTMX.setTranslation(ste, tr, true);
                        allowToImport.put(ste.getSrcText(), ste.getSourceTranslation());
                        continue;
                    }
                    String justImported = (String)allowToImport.get(ste.getSrcText());
                    if (justImported == null || ste.getSourceTranslation().equals(justImported)) continue;
                    TMXEntry tr2 = new TMXEntry(ste.getSrcText(), ste.getSourceTranslation(), null, 0L, null, false);
                    this.projectTMX.setTranslation(ste, tr2, false);
                    continue;
                }
                TMXEntry en = this.projectTMX.getMultipleTranslation(ste.getKey());
                if (en != null) continue;
                tr = new TMXEntry(ste.getSrcText(), ste.getSourceTranslation(), null, 0L, null, false);
                this.projectTMX.setTranslation(ste, tr, false);
            }
        }
    }

    private void loadTM() throws IOException {
        final File tmRoot = new File(this.m_config.getTMRoot());
        this.tmMonitor = new DirectoryMonitor(tmRoot, new DirectoryMonitor.Callback(){

            public void fileChanged(File file) {
                if (!file.getName().endsWith(".tmx") && !file.getName().endsWith(".tmx.gz")) {
                    return;
                }
                if (file.getPath().startsWith(RealProject.this.m_config.getTMOtherLangRoot())) {
                    return;
                }
                TreeMap<String, ExternalTMX> newTransMemories = new TreeMap<String, ExternalTMX>(RealProject.this.transMemories);
                if (file.exists()) {
                    try {
                        ExternalTMX newTMX = new ExternalTMX(RealProject.this.m_config, file, Preferences.isPreference("ext_tmx_show_level2"), Preferences.isPreference("ext_tmx_use_slash"));
                        newTransMemories.put(file.getPath(), newTMX);
                        if (FileUtil.computeRelativePath(tmRoot, file).startsWith("auto/")) {
                            RealProject.this.appendFromAutoTMX(newTMX);
                        }
                    }
                    catch (Exception e) {
                        String filename = file.getPath();
                        Log.logErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                        Core.getMainWindow().displayErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                    }
                } else {
                    newTransMemories.remove(file.getPath());
                }
                RealProject.this.transMemories = newTransMemories;
            }
        });
        this.tmMonitor.checkChanges();
        this.tmMonitor.start();
    }

    private void loadOtherLanguages() throws IOException {
        File tmOtherLanguagesRoot = new File(this.m_config.getTMOtherLangRoot());
        this.tmOtherLanguagesMonitor = new DirectoryMonitor(tmOtherLanguagesRoot, new DirectoryMonitor.Callback(){

            public void fileChanged(File file) {
                if (!file.getName().matches("[A-Z]{2}([-_][A-Z]{2})?\\.tmx")) {
                    return;
                }
                Language targetLanguage = new Language(file.getName().substring(0, file.getName().length() - 4));
                TreeMap<Language, ProjectTMX> newOtherTargetLangTMs = new TreeMap<Language, ProjectTMX>(RealProject.this.otherTargetLangTMs);
                if (file.exists()) {
                    try {
                        ProjectTMX newTMX = new ProjectTMX(RealProject.this.m_config.getSourceLanguage(), targetLanguage, RealProject.this.m_config.isSentenceSegmentingEnabled(), file, RealProject.this.checkOrphanedCallback);
                        newOtherTargetLangTMs.put(targetLanguage, newTMX);
                    }
                    catch (Exception e) {
                        String filename = file.getPath();
                        Log.logErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                        Core.getMainWindow().displayErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                    }
                } else {
                    newOtherTargetLangTMs.remove(targetLanguage);
                }
                RealProject.this.otherTargetLangTMs = newOtherTargetLangTMs;
            }
        });
        this.tmOtherLanguagesMonitor.checkChanges();
        this.tmOtherLanguagesMonitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendFromAutoTMX(ExternalTMX tmx) {
        HashSet<String> existSources = new HashSet<String>(this.allProjectEntries.size());
        for (SourceTextEntry ste : this.allProjectEntries) {
            existSources.add(ste.getSrcText());
        }
        ProjectTMX projectTMX = this.projectTMX;
        synchronized (projectTMX) {
            for (TMXEntry e : tmx.getEntries()) {
                if (!existSources.contains(e.source) || this.projectTMX.defaults.containsKey(e.source)) continue;
                this.projectTMX.defaults.put(e.source, e);
            }
        }
    }

    @Override
    public List<SourceTextEntry> getAllEntries() {
        return this.allProjectEntries;
    }

    @Override
    public TMXEntry getTranslationInfo(SourceTextEntry ste) {
        TMXEntry r = this.projectTMX.getMultipleTranslation(ste.getKey());
        if (r == null) {
            r = this.projectTMX.getDefaultTranslation(ste.getSrcText());
        }
        if (r == null) {
            r = EMPTY_TRANSLATION;
        }
        return r;
    }

    @Override
    public ProjectProperties getProjectProperties() {
        return this.m_config;
    }

    @Override
    public boolean isProjectModified() {
        return this.m_modifiedFlag;
    }

    @Override
    public void setTranslation(SourceTextEntry entry, String trans, String note, boolean isDefault) {
        TMXEntry newTrEntry;
        TMXEntry prevTrEntry;
        String author = Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name"));
        TMXEntry tMXEntry = prevTrEntry = isDefault ? this.projectTMX.getDefaultTranslation(entry.getSrcText()) : this.projectTMX.getMultipleTranslation(entry.getKey());
        if (prevTrEntry == null) {
            prevTrEntry = EMPTY_TRANSLATION;
        }
        if (StringUtil.equalsWithNulls(prevTrEntry.translation, trans)) {
            if (StringUtil.nvl(prevTrEntry.note, "").equals(StringUtil.nvl(note, ""))) {
                return;
            }
            newTrEntry = new TMXEntry(prevTrEntry.source, prevTrEntry.translation, prevTrEntry.changer, prevTrEntry.changeDate, StringUtil.isEmpty(note) ? null : note, prevTrEntry.defaultTranslation);
        } else {
            newTrEntry = trans == null && StringUtil.isEmpty(note) ? null : new TMXEntry(entry.getSrcText(), trans, author, System.currentTimeMillis(), StringUtil.isEmpty(note) ? null : note, isDefault);
        }
        this.m_modifiedFlag = true;
        this.projectTMX.setTranslation(entry, newTrEntry, isDefault);
        int diff = prevTrEntry.translation == null ? 0 : -1;
        this.hotStat.numberofTranslatedSegments += (diff += trans == null ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateByDefaultTranslations(IProject.DefaultTranslationsIterator it) {
        Map.Entry[] entries;
        ProjectTMX projectTMX = this.projectTMX;
        synchronized (projectTMX) {
            Set<Map.Entry<String, TMXEntry>> set = this.projectTMX.defaults.entrySet();
            entries = set.toArray(new Map.Entry[set.size()]);
        }
        for (Map.Entry en : entries) {
            it.iterate((String)en.getKey(), (TMXEntry)en.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateByMultipleTranslations(IProject.MultipleTranslationsIterator it) {
        Map.Entry[] entries;
        ProjectTMX projectTMX = this.projectTMX;
        synchronized (projectTMX) {
            Set<Map.Entry<EntryKey, TMXEntry>> set = this.projectTMX.alternatives.entrySet();
            entries = set.toArray(new Map.Entry[set.size()]);
        }
        for (Map.Entry en : entries) {
            it.iterate((EntryKey)en.getKey(), (TMXEntry)en.getValue());
        }
    }

    @Override
    public boolean isOrphaned(String source) {
        return !this.checkOrphanedCallback.existSourceInProject(source);
    }

    @Override
    public boolean isOrphaned(EntryKey entry) {
        return !this.checkOrphanedCallback.existEntryInProject(entry);
    }

    @Override
    public Map<String, ExternalTMX> getTransMemories() {
        return this.transMemories;
    }

    @Override
    public Map<Language, ProjectTMX> getOtherTargetLanguageTMs() {
        return this.otherTargetLangTMs;
    }

    @Override
    public ITokenizer getSourceTokenizer() {
        return this.sourceTokenizer;
    }

    @Override
    public ITokenizer getTargetTokenizer() {
        return this.targetTokenizer;
    }

    protected ITokenizer createTokenizer(boolean forSource) {
        ITokenizer t;
        block6: {
            String className = forSource ? Core.getParams().get("ITokenizer") : Core.getParams().get("ITokenizerTarget");
            t = null;
            try {
                if (className == null) break block6;
                for (Class<?> c : PluginUtils.getTokenizerClasses()) {
                    if (!c.getName().equals(className)) continue;
                    t = (ITokenizer)c.newInstance();
                    break;
                }
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        if (t == null) {
            t = forSource ? new Tokenizer() : this.sourceTokenizer;
        }
        if (forSource) {
            Log.log("Source tokenizer: " + t.getClass().getName());
        } else {
            Log.log("Target tokenizer: " + t.getClass().getName());
        }
        return t;
    }

    @Override
    public List<IProject.FileInfo> getProjectFiles() {
        return Collections.unmodifiableList(this.projectFilesList);
    }

    protected String patchFileNameForEntryKey(String filename) {
        String f = Core.getParams().get("alternate-filename-from");
        String t = Core.getParams().get("alternate-filename-to");
        String fn = filename.replace('\\', '/');
        if (f != null && t != null) {
            fn = fn.replaceAll(f, t);
        }
        return fn;
    }

    void setOnlineMode() {
        if (!this.isOnlineMode) {
            Log.logInfoRB("VCS_ONLINE", new Object[0]);
            Core.getMainWindow().displayWarningRB("VCS_ONLINE", new Object[0]);
        }
        this.isOnlineMode = true;
    }

    void setOfflineMode() {
        if (this.isOnlineMode) {
            Log.logInfoRB("VCS_OFFLINE", new Object[0]);
            Core.getMainWindow().displayWarningRB("VCS_OFFLINE", new Object[0]);
        }
        this.isOnlineMode = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileNameComparator
    implements Comparator<String> {
        FileNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            Collator localCollator = Collator.getInstance(Locale.getDefault());
            localCollator.setStrength(0);
            return localCollator.compare(o1, o2);
        }
    }

    static class AlignFilesCallback
    implements IAlignCallback {
        Map<String, TMXEntry> data = new HashMap<String, TMXEntry>();
        private ProjectProperties config;

        public AlignFilesCallback(ProjectProperties props) {
            this.config = props;
        }

        public void addTranslation(String id, String source, String translation, boolean isFuzzy, String path, IFilter filter) {
            if (source != null && translation != null) {
                ParseEntry.ParseEntryResult spr = new ParseEntry.ParseEntryResult();
                String sourceS = ParseEntry.stripSomeChars(source, spr, this.config.isRemoveTags());
                String transS = ParseEntry.stripSomeChars(translation, spr, this.config.isRemoveTags());
                if (this.config.isSentenceSegmentingEnabled()) {
                    List<String> segmentsSource = Segmenter.segment(this.config.getSourceLanguage(), sourceS, null, null);
                    List<String> segmentsTranslation = Segmenter.segment(this.config.getTargetLanguage(), transS, null, null);
                    if (segmentsTranslation.size() != segmentsSource.size()) {
                        if (isFuzzy) {
                            transS = "[" + filter.getFuzzyMark() + "] " + transS;
                        }
                        this.data.put(sourceS, new TMXEntry(sourceS, transS, null, 0L, null, true));
                    } else {
                        for (int i = 0; i < segmentsSource.size(); i = (int)((short)(i + 1))) {
                            String oneSrc = segmentsSource.get(i);
                            String oneTrans = segmentsTranslation.get(i);
                            if (isFuzzy) {
                                oneTrans = "[" + filter.getFuzzyMark() + "] " + oneTrans;
                            }
                            this.data.put(sourceS, new TMXEntry(oneSrc, oneTrans, null, 0L, null, true));
                        }
                    }
                } else {
                    if (isFuzzy) {
                        transS = "[" + filter.getFuzzyMark() + "] " + transS;
                    }
                    this.data.put(sourceS, new TMXEntry(sourceS, transS, null, 0L, null, true));
                }
            }
        }
    }

    private class TranslateFilesCallback
    extends TranslateEntry {
        private String currentFile;

        public TranslateFilesCallback() {
            super(RealProject.this.m_config);
        }

        protected void fileStarted(String fn) {
            this.currentFile = RealProject.this.patchFileNameForEntryKey(fn);
            super.fileStarted();
        }

        protected String getSegmentTranslation(String id, int segmentIndex, String segmentSource, String prevSegment, String nextSegment, String path) {
            EntryKey ek = new EntryKey(this.currentFile, segmentSource, id, prevSegment, nextSegment, path);
            TMXEntry tr = RealProject.this.projectTMX.getMultipleTranslation(ek);
            if (tr == null) {
                tr = RealProject.this.projectTMX.getDefaultTranslation(ek.sourceText);
            }
            return tr != null ? tr.translation : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LoadFilesCallback
    extends ParseEntry {
        private IProject.FileInfo fileInfo;
        private String entryKeyFilename;
        private final Set<String> existSource;
        private final Set<EntryKey> existKeys;

        public LoadFilesCallback(Set<String> existSource, Set<EntryKey> existKeys) {
            super(RealProject.this.m_config);
            this.existSource = existSource;
            this.existKeys = existKeys;
        }

        @Override
        public void setCurrentFile(IProject.FileInfo fi) {
            this.fileInfo = fi;
            super.setCurrentFile(fi);
            this.entryKeyFilename = RealProject.this.patchFileNameForEntryKey(this.fileInfo.filePath);
        }

        @Override
        public void fileFinished() {
            super.fileFinished();
            this.fileInfo = null;
        }

        @Override
        protected void addSegment(String id, short segmentIndex, String segmentSource, String segmentTranslation, boolean segmentTranslationFuzzy, String comment, String prevSegment, String nextSegment, String path) {
            if (segmentSource.length() == 0 || segmentSource.trim().length() == 0) {
                throw new RuntimeException("Segment must not be empty");
            }
            EntryKey ek = new EntryKey(this.entryKeyFilename, segmentSource, id, prevSegment, nextSegment, path);
            SourceTextEntry srcTextEntry = new SourceTextEntry(ek, RealProject.this.allProjectEntries.size() + 1, comment, segmentTranslation);
            srcTextEntry.setSourceTranslationFuzzy(segmentTranslationFuzzy);
            RealProject.this.allProjectEntries.add(srcTextEntry);
            this.fileInfo.entries.add(srcTextEntry);
            this.existSource.add(segmentSource);
            this.existKeys.add(srcTextEntry.getKey());
        }
    }
}

