/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.ArrayList;
import java.util.List;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.segmentation.Rule;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.IParseCallback;
import org.omegat.util.Language;
import org.omegat.util.PatternConsts;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public abstract class ParseEntry
implements IParseCallback {
    private final ProjectProperties m_config;
    private List<ParseEntryQueueItem> parseQueue = new ArrayList<ParseEntryQueueItem>();

    public ParseEntry(ProjectProperties m_config) {
        this.m_config = m_config;
    }

    protected void setCurrentFile(IProject.FileInfo fi) {
    }

    protected void fileFinished() {
        for (ParseEntryQueueItem item : this.parseQueue) {
            this.addSegment(item.id, item.segmentIndex, item.segmentSource, item.segmentTranslation, item.segmentTranslationFuzzy, item.comment, item.prevSegment, item.nextSegment, item.path);
        }
        this.parseQueue.clear();
    }

    public void linkPrevNextSegments() {
        for (int i = 0; i < this.parseQueue.size(); ++i) {
            ParseEntryQueueItem item = this.parseQueue.get(i);
            try {
                item.prevSegment = this.parseQueue.get((int)(i - 1)).segmentSource;
            }
            catch (IndexOutOfBoundsException ex) {
                item.prevSegment = "";
            }
            try {
                item.nextSegment = this.parseQueue.get((int)(i + 1)).segmentSource;
                continue;
            }
            catch (IndexOutOfBoundsException ex) {
                item.nextSegment = "";
            }
        }
    }

    public void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, String path, IFilter filter) {
        if (StringUtil.isEmpty(source)) {
            return;
        }
        ParseEntryResult tmp = new ParseEntryResult();
        source = ParseEntry.stripSomeChars(source, tmp, this.m_config.isRemoveTags());
        if (translation != null) {
            translation = ParseEntry.stripSomeChars(translation, tmp, this.m_config.isRemoveTags());
        }
        if (this.m_config.isSentenceSegmentingEnabled()) {
            ArrayList<StringBuffer> spaces = new ArrayList<StringBuffer>();
            ArrayList<Rule> brules = new ArrayList<Rule>();
            Language sourceLang = this.m_config.getSourceLanguage();
            List<String> segments = Segmenter.segment(sourceLang, source, spaces, brules);
            if (segments.size() == 1) {
                this.internalAddSegment(id, (short)0, segments.get(0), translation, isFuzzy, comment, path);
            } else {
                for (short i = 0; i < segments.size(); i = (short)(i + 1)) {
                    String onesrc = segments.get(i);
                    this.internalAddSegment(id, i, onesrc, null, false, comment, path);
                }
            }
        } else {
            this.internalAddSegment(id, (short)0, source, translation, isFuzzy, comment, path);
        }
    }

    public void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, IFilter filter) {
        this.addEntry(id, source, translation, isFuzzy, comment, null, filter);
    }

    private void internalAddSegment(String id, short segmentIndex, String segmentSource, String segmentTranslation, boolean segmentTranslationFuzzy, String comment, String path) {
        if (segmentSource.length() == 0 || segmentSource.trim().length() == 0) {
            return;
        }
        ParseEntryQueueItem item = new ParseEntryQueueItem();
        item.id = id;
        item.segmentIndex = segmentIndex;
        item.segmentSource = segmentSource;
        item.segmentTranslation = segmentTranslation;
        item.segmentTranslationFuzzy = segmentTranslationFuzzy;
        item.comment = comment;
        item.path = path;
        this.parseQueue.add(item);
    }

    protected abstract void addSegment(String var1, short var2, String var3, String var4, boolean var5, String var6, String var7, String var8, String var9);

    static String stripSomeChars(String src, ParseEntryResult per, boolean removeTags) {
        int b;
        String r = src;
        int len = r.length();
        for (b = 0; b < len && (Character.isWhitespace(r.charAt(b)) || r.charAt(b) == '\u00a0'); ++b) {
        }
        per.spacesAtBegin = b;
        int pos = len - 1;
        int e = 0;
        while (pos >= b && (Character.isWhitespace(r.charAt(pos)) || r.charAt(pos) == '\u00a0')) {
            --pos;
            ++e;
        }
        per.spacesAtEnd = e;
        boolean bl = per.crlf = (r = r.substring(b, pos + 1)).indexOf("\r\n") > 0;
        if (per.crlf) {
            r = r.replace("\r\n", "\n");
        }
        boolean bl2 = per.cr = r.indexOf("\r") > 0;
        if (per.cr) {
            r = r.replace("\r", "\n");
        }
        if (removeTags) {
            r = PatternConsts.OMEGAT_TAG.matcher(r).replaceAll("");
        }
        r = StaticUtils.fixChars(r);
        return r;
    }

    protected static class ParseEntryQueueItem {
        String id;
        short segmentIndex;
        String segmentSource;
        String segmentTranslation;
        boolean segmentTranslationFuzzy;
        String comment;
        String prevSegment;
        String nextSegment;
        String path;

        protected ParseEntryQueueItem() {
        }
    }

    public static class ParseEntryResult {
        public boolean crlf;
        public boolean cr;
        int spacesAtBegin;
        int spacesAtEnd;
    }
}

