/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXReader2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalTMX {
    private final String name;
    private final List<TMXEntry> entries;

    public ExternalTMX(String name, List<TMXEntry> entries) {
        this.name = name;
        this.entries = entries;
    }

    public ExternalTMX(final ProjectProperties props, File file, boolean extTmxLevel2, boolean useSlash) throws Exception {
        this.name = file.getName();
        this.entries = new ArrayList<TMXEntry>();
        TMXReader2.LoadCallback loader = new TMXReader2.LoadCallback(){

            public boolean onEntry(TMXReader2.ParsedTu tu, TMXReader2.ParsedTuv tuvSource, TMXReader2.ParsedTuv tuvTarget, boolean isParagraphSegtype) {
                if (tuvSource == null) {
                    return false;
                }
                if (tuvTarget != null) {
                    this.addTuv(tu, tuvSource, tuvTarget, isParagraphSegtype);
                } else {
                    for (int i = 0; i < tu.tuvs.size(); ++i) {
                        if (tu.tuvs.get(i) == tuvSource) continue;
                        this.addTuv(tu, tuvSource, tu.tuvs.get(i), isParagraphSegtype);
                    }
                }
                return true;
            }

            private void addTuv(TMXReader2.ParsedTu tu, TMXReader2.ParsedTuv tuvSource, TMXReader2.ParsedTuv tuvTarget, boolean isParagraphSegtype) {
                String changer = StringUtil.nvl(tuvTarget.changeid, tuvTarget.creationid, tu.changeid, tu.creationid);
                long dt = StringUtil.nvlLong(tuvTarget.changedate, tuvTarget.creationdate, tu.changedate, tu.creationdate);
                ArrayList<String> sources = new ArrayList<String>();
                ArrayList<String> targets = new ArrayList<String>();
                Segmenter.segmentEntries(props.isSentenceSegmentingEnabled() && isParagraphSegtype, props.getSourceLanguage(), tuvSource.text, props.getTargetLanguage(), tuvTarget.text, sources, targets);
                for (int i = 0; i < sources.size(); ++i) {
                    TMXEntry te = new TMXEntry((String)sources.get(i), (String)targets.get(i), changer, dt, tu.note, true, tu.props);
                    ExternalTMX.this.entries.add(te);
                }
            }
        };
        new TMXReader2().readTMX(file, props.getSourceLanguage(), props.getTargetLanguage(), props.isSentenceSegmentingEnabled(), false, extTmxLevel2, useSlash, loader);
    }

    public String getName() {
        return this.name;
    }

    public List<TMXEntry> getEntries() {
        return this.entries;
    }
}

