/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.ArrayList;
import java.util.Map;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.util.StringUtil;
import org.omegat.util.VarExpansion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandVarExpansion
extends VarExpansion<ProjectProperties> {
    public static final String PROJECT_NAME = "${projectName}";
    public static final String PROJECT_ROOT = "${projectRoot}";
    public static final String SOURCE_ROOT = "${sourceRoot}";
    public static final String TARGET_ROOT = "${targetRoot}";
    public static final String GLOSSARY_ROOT = "${glossaryRoot}";
    public static final String WRITABLE_GLOSSARY_FILE = "${glossaryFile}";
    public static final String TM_ROOT = "${tmRoot}";
    public static final String TM_AUTO_ROOT = "${tmAutoRoot}";
    public static final String DICT_ROOT = "${dictRoot}";
    public static final String TM_OTHER_LANG_ROOT = "${tmOtherLangRoot}";
    public static final String SOURCE_LANGUAGE = "${sourceLang}";
    public static final String TARGET_LANGUAGE = "${targetLang}";
    public static final String[] COMMAND_VARIABLES;

    public CommandVarExpansion(String template) {
        super(template);
    }

    @Override
    public String expandVariables(ProjectProperties props) {
        String localTemplate = this.template;
        localTemplate = localTemplate.replace(PROJECT_NAME, props.getProjectName());
        localTemplate = localTemplate.replace(PROJECT_ROOT, props.getProjectRoot());
        localTemplate = localTemplate.replace(SOURCE_ROOT, props.getSourceRoot());
        localTemplate = localTemplate.replace(TARGET_ROOT, props.getTargetRoot());
        localTemplate = localTemplate.replace(GLOSSARY_ROOT, props.getGlossaryRoot());
        localTemplate = localTemplate.replace(WRITABLE_GLOSSARY_FILE, props.getWriteableGlossary());
        localTemplate = localTemplate.replace(TM_ROOT, props.getTMRoot());
        localTemplate = localTemplate.replace(TM_AUTO_ROOT, props.getTMAutoRoot());
        localTemplate = localTemplate.replace(DICT_ROOT, props.getDictRoot());
        localTemplate = localTemplate.replace(TM_OTHER_LANG_ROOT, props.getTMOtherLangRoot());
        localTemplate = localTemplate.replace(SOURCE_LANGUAGE, props.getSourceLanguage().getLanguage());
        localTemplate = localTemplate.replace(TARGET_LANGUAGE, props.getTargetLanguage().getLanguage());
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            localTemplate = localTemplate.replace(CommandVarExpansion.fixEnvarName(e.getKey()), e.getValue());
        }
        String currentFile = Core.getEditor().getCurrentFile();
        if (!StringUtil.isEmpty(currentFile)) {
            String sourceRoot = props.getSourceRoot();
            localTemplate = this.expandFileName(localTemplate, sourceRoot + currentFile, sourceRoot);
        }
        return localTemplate;
    }

    private static String fixEnvarName(String varname) {
        return String.format("${%s}", varname);
    }

    static {
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(PROJECT_NAME);
        vars.add(PROJECT_ROOT);
        vars.add(SOURCE_ROOT);
        vars.add(TARGET_ROOT);
        vars.add(GLOSSARY_ROOT);
        vars.add(WRITABLE_GLOSSARY_FILE);
        vars.add(TM_ROOT);
        vars.add(TM_AUTO_ROOT);
        vars.add(DICT_ROOT);
        vars.add(TM_OTHER_LANG_ROOT);
        vars.add(SOURCE_LANGUAGE);
        vars.add(TARGET_LANGUAGE);
        vars.add("${filePath}");
        vars.add("${fileShortPath}");
        vars.add("${fileName}");
        vars.add("${fileNameOnly}");
        vars.add("${fileExtension}");
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            vars.add(CommandVarExpansion.fixEnvarName(e.getKey()));
        }
        COMMAND_VARIABLES = vars.toArray(new String[0]);
    }
}

