/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IEditorEventListener;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.util.Log;

public class CoreEvents {
    private static final List<IProjectEventListener> projectEventListeners = new ArrayList<IProjectEventListener>();
    private static final List<IApplicationEventListener> applicationEventListeners = new ArrayList<IApplicationEventListener>();
    private static final List<IEntryEventListener> entryEventListeners = new ArrayList<IEntryEventListener>();
    private static final List<IFontChangedEventListener> fontChangedEventListeners = new ArrayList<IFontChangedEventListener>();
    private static final List<IEditorEventListener> editorEventListeners = new ArrayList<IEditorEventListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProjectChangeListener(IProjectEventListener listener) {
        List<IProjectEventListener> list = projectEventListeners;
        synchronized (list) {
            projectEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterProjectChangeListener(IProjectEventListener listener) {
        List<IProjectEventListener> list = projectEventListeners;
        synchronized (list) {
            projectEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerApplicationEventListener(IApplicationEventListener listener) {
        List<IApplicationEventListener> list = applicationEventListeners;
        synchronized (list) {
            applicationEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterApplicationEventListener(IApplicationEventListener listener) {
        List<IApplicationEventListener> list = applicationEventListeners;
        synchronized (list) {
            applicationEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerEntryEventListener(IEntryEventListener listener) {
        List<IEntryEventListener> list = entryEventListeners;
        synchronized (list) {
            entryEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterEntryEventListener(IEntryEventListener listener) {
        List<IEntryEventListener> list = entryEventListeners;
        synchronized (list) {
            entryEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFontChangedEventListener(IFontChangedEventListener listener) {
        List<IFontChangedEventListener> list = fontChangedEventListeners;
        synchronized (list) {
            fontChangedEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterFontChangedEventListener(IFontChangedEventListener listener) {
        List<IFontChangedEventListener> list = fontChangedEventListeners;
        synchronized (list) {
            fontChangedEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerEditorEventListener(IEditorEventListener listener) {
        List<IEditorEventListener> list = editorEventListeners;
        synchronized (list) {
            editorEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterEditorEventListener(IEditorEventListener listener) {
        List<IEditorEventListener> list = editorEventListeners;
        synchronized (list) {
            editorEventListeners.remove(listener);
        }
    }

    public static void fireProjectChange(final IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_PROJECT_CHANGE", new Object[]{eventType});
                List list = projectEventListeners;
                synchronized (list) {
                    for (IProjectEventListener listener : projectEventListeners) {
                        listener.onProjectChanged(eventType);
                    }
                }
            }
        });
    }

    public static void fireApplicationStartup() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_APPLICATION_STARTUP", new Object[0]);
                List list = applicationEventListeners;
                synchronized (list) {
                    for (IApplicationEventListener listener : applicationEventListeners) {
                        listener.onApplicationStartup();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireApplicationShutdown() {
        Log.logInfoRB("LOG_INFO_EVENT_APPLICATION_SHUTDOWN", new Object[0]);
        List<IApplicationEventListener> list = applicationEventListeners;
        synchronized (list) {
            for (IApplicationEventListener listener : applicationEventListeners) {
                listener.onApplicationShutdown();
            }
        }
    }

    public static void fireEntryNewFile(final String activeFileName) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_ENTRY_NEWFILE", activeFileName);
                List list = entryEventListeners;
                synchronized (list) {
                    for (IEntryEventListener listener : entryEventListeners) {
                        listener.onNewFile(activeFileName);
                    }
                }
            }
        });
    }

    public static void fireEntryActivated(final SourceTextEntry newEntry) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_ENTRY_ACTIVATED", new Object[0]);
                List list = entryEventListeners;
                synchronized (list) {
                    for (IEntryEventListener listener : entryEventListeners) {
                        listener.onEntryActivated(newEntry);
                    }
                }
            }
        });
    }

    public static void fireFontChanged(final Font newFont) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_FONT_CHANGED", new Object[0]);
                List list = fontChangedEventListeners;
                synchronized (list) {
                    for (IFontChangedEventListener listener : fontChangedEventListeners) {
                        listener.onFontChanged(newFont);
                    }
                }
            }
        });
    }

    public static void fireEditorNewWord(final String newWord) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List list = editorEventListeners;
                synchronized (list) {
                    for (IEditorEventListener listener : editorEventListeners) {
                        listener.onNewWord(newWord);
                    }
                }
            }
        });
    }
}

