/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.omegat.core.data.IProject;
import org.omegat.core.data.NotLoadedProject;
import org.omegat.core.spellchecker.ISpellChecker;
import org.omegat.core.spellchecker.SpellChecker;
import org.omegat.core.threads.IAutoSave;
import org.omegat.core.threads.SaveThread;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.comments.CommentsTextArea;
import org.omegat.gui.dictionaries.DictionariesTextArea;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.mark.BidiMarkerFactory;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.NBSPMarker;
import org.omegat.gui.editor.mark.RemoveTagMarker;
import org.omegat.gui.editor.mark.TagMarker;
import org.omegat.gui.editor.mark.WhitespaceMarkerFactory;
import org.omegat.gui.exttrans.MachineTranslateTextArea;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.gui.main.ConsoleWindow;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.matches.IMatcher;
import org.omegat.gui.matches.MatchesTextArea;
import org.omegat.gui.multtrans.MultipleTransPane;
import org.omegat.gui.notes.INotes;
import org.omegat.gui.notes.NotesTextArea;
import org.omegat.gui.tagvalidation.ITagValidation;
import org.omegat.gui.tagvalidation.TagValidationTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Core {
    private static IProject currentProject;
    private static IMainWindow mainWindow;
    protected static IEditor editor;
    private static ITagValidation tagValidation;
    private static IMatcher matcher;
    private static ISpellChecker spellChecker;
    private static FilterMaster filterMaster;
    private static IAutoSave saveThread;
    private static GlossaryTextArea glossary;
    private static MachineTranslateTextArea machineTranslatePane;
    private static DictionariesTextArea dictionaries;
    private static MultipleTransPane multiple;
    private static INotes notes;
    private static CommentsTextArea comments;
    private static Map<String, String> cmdLineParams;
    private static final List<IMarker> markers;

    public static IProject getProject() {
        return currentProject;
    }

    public static void setProject(IProject newCurrentProject) {
        currentProject = newCurrentProject;
    }

    public static IMainWindow getMainWindow() {
        return mainWindow;
    }

    public static IEditor getEditor() {
        return editor;
    }

    public static ITagValidation getTagValidation() {
        return tagValidation;
    }

    public static IMatcher getMatcher() {
        return matcher;
    }

    public static ISpellChecker getSpellChecker() {
        return spellChecker;
    }

    public static FilterMaster getFilterMaster() {
        return filterMaster;
    }

    public static void setFilterMaster(FilterMaster newFilterMaster) {
        filterMaster = newFilterMaster;
    }

    public static MachineTranslateTextArea getMachineTranslatePane() {
        return machineTranslatePane;
    }

    public static IAutoSave getAutoSave() {
        return saveThread;
    }

    public static GlossaryTextArea getGlossary() {
        return glossary;
    }

    public static INotes getNotes() {
        return notes;
    }

    public static void initializeGUI(Map<String, String> params) throws Exception {
        cmdLineParams = params;
        currentProject = new NotLoadedProject();
        MainWindow me = new MainWindow();
        mainWindow = me;
        Core.registerMarker(new TagMarker());
        Core.registerMarker(new RemoveTagMarker());
        Core.registerMarker(new NBSPMarker());
        Core.registerMarker(new WhitespaceMarkerFactory.SpaceMarker());
        Core.registerMarker(new WhitespaceMarkerFactory.TabMarker());
        Core.registerMarker(new WhitespaceMarkerFactory.LFMarker());
        Core.registerMarker(new BidiMarkerFactory.RLMMarker());
        Core.registerMarker(new BidiMarkerFactory.LRMMarker());
        Core.registerMarker(new BidiMarkerFactory.PDFMarker());
        Core.registerMarker(new BidiMarkerFactory.LROMarker());
        Core.registerMarker(new BidiMarkerFactory.RLOMarker());
        editor = new EditorController(me);
        tagValidation = new TagValidationTool(me);
        matcher = new MatchesTextArea(me);
        glossary = new GlossaryTextArea();
        notes = new NotesTextArea(me);
        comments = new CommentsTextArea(me);
        machineTranslatePane = new MachineTranslateTextArea();
        dictionaries = new DictionariesTextArea();
        spellChecker = new SpellChecker();
        multiple = new MultipleTransPane();
        SaveThread th = new SaveThread();
        saveThread = th;
        th.start();
    }

    public static void initializeConsole(Map<String, String> params) throws Exception {
        cmdLineParams = params;
        tagValidation = new TagValidationTool();
        currentProject = new NotLoadedProject();
        mainWindow = new ConsoleWindow();
    }

    protected static void setMainWindow(IMainWindow mainWindow) {
        Core.mainWindow = mainWindow;
    }

    protected static void setCurrentProject(IProject currentProject) {
        Core.currentProject = currentProject;
    }

    public static void registerMarker(IMarker marker) {
        markers.add(marker);
    }

    public static List<IMarker> getMarkers() {
        return markers;
    }

    public static Map<String, String> getParams() {
        return cmdLineParams;
    }

    static {
        markers = new ArrayList<IMarker>();
    }
}

