/*
 * Decompiled with CFR 0.152.
 */
package org.omegat;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.omegat.convert.ConvertConfigs;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.tagvalidation.ITagValidation;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.RuntimePreferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXWriter;

public class Main {
    protected static final Pattern PARAM = Pattern.compile("\\-\\-([A-Za-z\\-]+)(=(.+))?");
    protected static File projectLocation = null;
    protected static final Map<String, String> params = new TreeMap<String, String>();
    protected static RUN_MODE runMode = RUN_MODE.GUI;

    public static void main(String[] args) {
        String configDir;
        for (String arg : args) {
            Matcher m = PARAM.matcher(arg);
            if (m.matches()) {
                params.put(m.group(1), m.group(3));
                continue;
            }
            if (arg.startsWith("resource-bundle=")) {
                params.put("resource-bundle", arg.substring(16));
                continue;
            }
            File f = new File(arg);
            if (!f.exists() || !f.isDirectory()) continue;
            projectLocation = f;
        }
        runMode = RUN_MODE.parse(params.get("mode"));
        String resourceBundle = params.get("resource-bundle");
        if (resourceBundle != null) {
            OStrings.loadBundle(resourceBundle);
        }
        if ((configDir = params.get("config-dir")) != null) {
            RuntimePreferences.setConfigDir(configDir);
        }
        if (params.containsKey("quiet")) {
            RuntimePreferences.setQuietMode(true);
        }
        if (params.containsKey("disable-project-locking")) {
            RuntimePreferences.setProjectLockingEnabled(false);
        }
        Log.log("\n===================================================================\n" + OStrings.getDisplayVersion() + " (" + new Date() + ") " + " Locale " + Locale.getDefault());
        Log.logRB("LOG_STARTUP_INFO", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("java.home"));
        System.setProperty("http.user", OStrings.getDisplayVersion());
        ConvertConfigs.convert();
        PluginUtils.loadPlugins(params);
        switch (runMode) {
            case GUI: {
                Main.runGUI();
                break;
            }
            case CONSOLE_TRANSLATE: {
                Main.runConsoleTranslate();
                break;
            }
            case CONSOLE_CREATEPSEUDOTRANSLATETMX: {
                Main.runCreatePseudoTranslateTMX();
                break;
            }
            case CONSOLE_ALIGN: {
                Main.runConsoleAlign();
            }
        }
    }

    protected static void runGUI() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "OmegaT");
        Log.log("Docking Framework version: " + DockingDesktop.getDockingFrameworkVersion());
        Log.log("");
        try {
            UIManager.getInstalledLookAndFeels();
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            Log.logErrorRB("MAIN_ERROR_CANT_INIT_OSLF", new Object[0]);
        }
        try {
            Core.initializeGUI(params);
        }
        catch (Throwable ex) {
            Log.log(ex);
            Main.showError(ex);
        }
        CoreEvents.fireApplicationStartup();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Core.getMainWindow().getApplicationFrame().setVisible(true);
                if (projectLocation != null) {
                    ProjectUICommands.projectOpen(projectLocation);
                }
            }
        });
    }

    protected static void runConsoleTranslate() {
        Log.log("Console mode");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        try {
            Core.initializeConsole(params);
        }
        catch (Throwable ex) {
            Main.showError(ex);
        }
        try {
            RealProject p = Main.selectProjectConsoleMode(true);
            Main.validateTagsConsoleMode();
            System.out.println(OStrings.getString("CONSOLE_TRANSLATING"));
            String sourceMask = params.get("source-pattern");
            if (sourceMask != null) {
                p.compileProject(sourceMask, false);
            } else {
                p.compileProject(".*", false);
            }
            p.closeProject();
            System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        }
        catch (Exception e) {
            System.err.println("An error has occured: " + e.toString());
            System.exit(1);
        }
    }

    private static void validateTagsConsoleMode() {
        String tagValidation = params.get("tag-validation");
        if ("abort".equalsIgnoreCase(tagValidation)) {
            System.out.println(OStrings.getString("CONSOLE_VALIDATING_TAGS"));
            ITagValidation aTagValidation = Core.getTagValidation();
            if (!aTagValidation.validateTags()) {
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_FAIL"));
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_ABORT"));
                System.exit(1);
            }
        } else if ("warn".equalsIgnoreCase(tagValidation)) {
            System.out.println(OStrings.getString("CONSOLE_VALIDATING_TAGS"));
            ITagValidation aTagValidation = Core.getTagValidation();
            if (!aTagValidation.validateTags()) {
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_FAIL"));
            }
        }
    }

    protected static void runCreatePseudoTranslateTMX() {
        Log.log("Console mode");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        try {
            Core.initializeConsole(params);
        }
        catch (Throwable ex) {
            Main.showError(ex);
        }
        try {
            RealProject p = Main.selectProjectConsoleMode(true);
            Main.validateTagsConsoleMode();
            System.out.println(OStrings.getString("CONSOLE_CREATE_PSEUDOTMX"));
            ProjectProperties m_config = p.getProjectProperties();
            List<SourceTextEntry> entries = p.getAllEntries();
            String pseudoTranslateTMXFilename = params.get("pseudotranslatetmx");
            PSEUDO_TRANSLATE_TYPE pseudoTranslateType = PSEUDO_TRANSLATE_TYPE.parse(params.get("pseudotranslatetype"));
            String fname = pseudoTranslateTMXFilename != null && pseudoTranslateTMXFilename.length() > 0 ? (!pseudoTranslateTMXFilename.endsWith(".tmx") ? pseudoTranslateTMXFilename + "." + ".tmx" : pseudoTranslateTMXFilename) : "";
            HashMap<String, TMXEntry> data = new HashMap<String, TMXEntry>();
            for (SourceTextEntry ste : entries) {
                switch (pseudoTranslateType) {
                    case EQUAL: {
                        data.put(ste.getSrcText(), new TMXEntry(ste.getSrcText(), ste.getSrcText(), null, 0L, null, true));
                        break;
                    }
                    case EMPTY: {
                        data.put(ste.getSrcText(), new TMXEntry(ste.getSrcText(), "", null, 0L, null, true));
                    }
                }
            }
            try {
                TMXWriter.buildTMXFile(fname, false, false, m_config, data);
            }
            catch (IOException e) {
                Log.logErrorRB("CT_ERROR_CREATING_TMX", new Object[0]);
                Log.log(e);
                throw new IOException(OStrings.getString("CT_ERROR_CREATING_TMX") + "\n" + e.getMessage());
            }
            p.closeProject();
            System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        }
        catch (Exception e) {
            System.err.println("An error has occured: " + e.toString());
            System.exit(1);
        }
    }

    public static void runConsoleAlign() {
        String dir;
        Log.log("Alignment mode");
        Log.log("");
        if (projectLocation == null) {
            System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
            System.exit(1);
        }
        if ((dir = params.get("alignDir")) == null) {
            System.out.println(OStrings.getString("CONSOLE_TRANSLATED_FILES_LOC_UNDEFINED"));
            System.exit(1);
        }
        System.out.println(OStrings.getString("INITIALIZING"));
        try {
            Core.initializeConsole(params);
        }
        catch (Throwable ex) {
            Main.showError(ex);
        }
        try {
            RealProject p = Main.selectProjectConsoleMode(false);
            Main.validateTagsConsoleMode();
            System.out.println(StaticUtils.format(OStrings.getString("CONSOLE_ALIGN_AGAINST"), dir));
            Map<String, TMXEntry> data = p.align(p.getProjectProperties(), new File(dir));
            String tmxFile = p.getProjectProperties().getProjectInternal() + "align.tmx";
            TMXWriter.buildTMXFile(tmxFile, false, false, p.getProjectProperties(), data);
            System.out.println(OStrings.getString("FINISHED"));
        }
        catch (Exception e) {
            System.err.println("An error has occured: " + e.toString());
            System.exit(1);
        }
    }

    private static RealProject selectProjectConsoleMode(boolean loadProject) {
        System.out.println(OStrings.getString("CONSOLE_LOADING_PROJECT"));
        ProjectProperties projectProperties = null;
        try {
            projectProperties = ProjectFileStorage.loadProjectProperties(projectLocation);
            projectProperties.verifyProject();
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
            System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
            System.exit(1);
        }
        RealProject p = new RealProject(projectProperties);
        if (loadProject) {
            p.loadProject(true);
        }
        Core.setProject(p);
        return p;
    }

    public static void showError(Throwable ex) {
        String msg = StringUtil.isEmpty(ex.getMessage()) ? ex.getClass().getName() : ex.getMessage();
        switch (runMode) {
            case GUI: {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), msg, OStrings.getString("STARTUP_ERRORBOX_TITLE"), 0);
                break;
            }
            case CONSOLE_TRANSLATE: {
                System.err.println(msg);
            }
        }
        System.exit(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PSEUDO_TRANSLATE_TYPE {
        EQUAL,
        EMPTY;


        public static PSEUDO_TRANSLATE_TYPE parse(String s) {
            try {
                return PSEUDO_TRANSLATE_TYPE.valueOf(s.toUpperCase(Locale.ENGLISH).replace('-', '_'));
            }
            catch (Exception ex) {
                return EQUAL;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RUN_MODE {
        GUI,
        CONSOLE_TRANSLATE,
        CONSOLE_CREATEPSEUDOTRANSLATETMX,
        CONSOLE_ALIGN;


        public static RUN_MODE parse(String s) {
            try {
                return RUN_MODE.valueOf(s.toUpperCase(Locale.ENGLISH).replace('-', '_'));
            }
            catch (Exception ex) {
                return GUI;
            }
        }
    }
}

