/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.toolbars;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class RolloverIcon
implements Icon {
    private int shadowWidth = 1;
    private int shadowHeight = 1;
    private Icon icon;
    private Icon shadowIcon;

    public RolloverIcon(Icon icon) {
        this.icon = icon;
        this.shadowIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
    }

    public int getIconHeight() {
        return this.icon.getIconWidth();
    }

    public int getIconWidth() {
        return this.icon.getIconHeight();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color highlight = UIManager.getColor("controlLtHighlight");
        Color shadow = UIManager.getColor("controlShadow");
        g.setColor(highlight);
        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
        this.shadowIcon.paintIcon(c, g, x + this.shadowWidth - 1, y + this.shadowHeight - 1);
        this.icon.paintIcon(c, g, x - 1, y - 1);
    }
}

