/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DockViewAsTab;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import java.awt.Point;
import javax.swing.UIManager;

public class MaximizedDockViewAsTab
extends DockViewAsTab {
    public MaximizedDockViewAsTab(Dockable dockable) {
        super(dockable);
    }

    protected void configureMaximizeButton() {
        if (this.isRestoreButtonDisplayed) {
            this.maximizeSmartIcon.setIcon(UIManager.getIcon("DockViewTitleBar.restore"));
            this.maximizeSmartIcon.setPressedIcon(UIManager.getIcon("DockViewTitleBar.restore.pressed"));
            this.maximizeSmartIcon.setRolloverIcon(UIManager.getIcon("DockViewTitleBar.restore.rollover"));
            this.maximizeAction.putValue("ShortDescription", UIManager.get("DockViewTitleBar.restoreButtonText"));
        }
    }

    protected void configureFloatButton() {
        this.isFloatButtonDisplayed = false;
    }

    protected void configureHideButton() {
        this.isHideButtonDisplayed = false;
    }

    protected void configureCloseButton() {
        this.isCloseButtonDisplayed = false;
    }

    protected DockViewAsTab.TabHeader createTabHeader() {
        return new MaximizedTabHeader();
    }

    public void processDockableDrag(DockDragEvent event) {
        event.rejectDrag();
    }

    public void processDockableDrop(DockDropEvent event) {
        event.rejectDrop();
    }

    protected class MaximizedTabHeader
    extends DockViewAsTab.TabHeader {
        protected MaximizedTabHeader() {
        }

        public boolean startDragComponent(Point p) {
            Dockable target = this.getDockable();
            int targetState = target.getDockKey().getDockableState();
            if (targetState == 2) {
                if (DockingUtilities.isChildOfCompoundDockable(target)) {
                    return false;
                }
            } else if (targetState == 1) {
                Dockable max;
                boolean isChildOfMaximizedContainer = false;
                if (MaximizedDockViewAsTab.this.desktop != null && (max = MaximizedDockViewAsTab.this.desktop.getMaximizedDockable()) != null && max.getComponent().getParent().isAncestorOf(this)) {
                    isChildOfMaximizedContainer = true;
                }
                if (isChildOfMaximizedContainer) {
                    return false;
                }
            } else if (targetState == 3) {
                return false;
            }
            return true;
        }
    }
}

