/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.RelativeDockablePosition;

public class DockableState
implements Comparable {
    private Dockable dockable;
    private static final String[] stateNames = new String[]{"CLOSED", "DOCKED", "HIDDEN", "MAXIMIZED", "FLOATING"};
    public static final int STATE_CLOSED = 0;
    public static final int STATE_DOCKED = 1;
    public static final int STATE_HIDDEN = 2;
    public static final int STATE_MAXIMIZED = 3;
    public static final int STATE_FLOATING = 4;
    private int state;
    private RelativeDockablePosition position;
    private DockingDesktop desktop;

    public DockableState() {
        this.position = new RelativeDockablePosition();
    }

    public DockableState(DockingDesktop desktop, Dockable dockable, int state) {
        this.desktop = desktop;
        this.dockable = dockable;
        this.state = state;
        this.position = new RelativeDockablePosition();
    }

    public DockableState(DockingDesktop desktop, Dockable dockable, int state, RelativeDockablePosition position) {
        this.desktop = desktop;
        this.dockable = dockable;
        this.state = state;
        this.position = position;
    }

    public DockableState(DockableState copy, RelativeDockablePosition position) {
        this.desktop = copy.desktop;
        this.dockable = copy.dockable;
        this.state = copy.state;
        this.position = position;
    }

    public int compareTo(Object object) {
        if (object instanceof DockableState) {
            return this.dockable.getDockKey().getName().compareTo(((DockableState)object).dockable.getDockKey().getName());
        }
        return -1;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public boolean isDocked() {
        return this.state == 1;
    }

    public boolean isHidden() {
        return this.state == 2;
    }

    public boolean isClosed() {
        return this.state == 0;
    }

    public boolean isFloating() {
        return this.state == 4;
    }

    public boolean isMaximized() {
        return this.state == 3;
    }

    public int getState() {
        return this.state;
    }

    public RelativeDockablePosition getPosition() {
        return this.position;
    }

    public String toString() {
        return "DockableState [" + this.dockable.getDockKey() + ", state=" + stateNames[this.state] + ", position=" + this.position;
    }

    public static String getStateName(int state) {
        return stateNames[state];
    }

    public DockingDesktop getDesktop() {
        return this.desktop;
    }

    public void setDesktop(DockingDesktop desktop) {
        this.desktop = desktop;
    }
}

