/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.part;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wb.core.gef.policy.TabOrderContainerEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.LayoutPolicyUtils;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.policies.IRefreshableEditPolicy;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.part.ControlEditPart;
import org.eclipse.wb.internal.swt.gef.policy.layout.DefaultLayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.policy.layout.DropLayoutEditPolicy;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;

public class CompositeEditPart
extends ControlEditPart {
    private final CompositeInfo m_composite;
    private LayoutInfo m_currentLayout;

    public CompositeEditPart(CompositeInfo composite) {
        super(composite);
        this.m_composite = composite;
    }

    protected void drawCustomBorder(Figure figure, Graphics graphics) {
        try {
            if (this.m_composite.shouldDrawDotsBorder()) {
                graphics.setForegroundColor(IColorConstants.gray);
                graphics.setLineStyle(3);
                Rectangle area = figure.getClientArea();
                graphics.drawRectangle(0, 0, area.width - 1, area.height - 1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void addChildVisual(EditPart childPart, int index) {
        super.addChildVisual(childPart, this.getFigure().getChildren().size() - index);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        if (this.m_composite.hasLayout()) {
            this.installEditPolicy((EditPolicy)new DropLayoutEditPolicy(this.m_composite));
        }
        this.installEditPolicy("tab container role", (EditPolicy)new TabOrderContainerEditPolicy());
    }

    @Override
    protected void refreshEditPolicies() {
        super.refreshEditPolicies();
        if (this.m_composite.hasLayout()) {
            LayoutInfo layout = this.m_composite.getLayout();
            if (layout != this.m_currentLayout) {
                try {
                    LayoutEditPolicy policy;
                    this.m_currentLayout = layout;
                    if (layout.getDescription().getComponentClass() != null && !InstanceScope.INSTANCE.getNode("layout.available").getBoolean(layout.getDescription().getComponentClass().getName(), true)) {
                        this.m_currentLayout = this.m_composite.getDefaultCompositeInfo();
                        this.m_composite.setLayout(this.m_currentLayout);
                    }
                    if ((policy = LayoutPolicyUtils.createLayoutEditPolicy((EditPart)this, (Object)this.m_currentLayout)) == null) {
                        policy = new DefaultLayoutEditPolicy();
                    }
                    this.installEditPolicy("LayoutEditPolicy", (EditPolicy)policy);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                EditPolicy policy = this.getEditPolicy("LayoutEditPolicy");
                if (policy instanceof IRefreshableEditPolicy) {
                    ((IRefreshableEditPolicy)policy).refreshEditPolicy();
                }
            }
        }
    }
}

