/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.wizards.actions;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.UiMessages;

public abstract class AbstractOpenWizardAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private final Class<?>[] fActivatedOnTypes;
    private final boolean fAcceptEmptySelection;
    private final boolean fNoChecking;

    public AbstractOpenWizardAction(String label, boolean acceptEmptySelection) {
        this(label, null, acceptEmptySelection);
    }

    public AbstractOpenWizardAction(String label, Class<?>[] activatedOnTypes, boolean acceptEmptySelection) {
        super(label);
        this.fActivatedOnTypes = activatedOnTypes;
        this.fAcceptEmptySelection = acceptEmptySelection;
        this.fNoChecking = false;
    }

    protected AbstractOpenWizardAction() {
        this.fActivatedOnTypes = null;
        this.fAcceptEmptySelection = true;
        this.fNoChecking = true;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        IWorkbench workbench = this.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] openWindows = workbench.getWorkbenchWindows();
            int i = 0;
            while (i < openWindows.length) {
                if (!openWindows[i].getShell().isDisposed()) {
                    window = openWindows[i];
                    break;
                }
                ++i;
            }
        }
        return window;
    }

    protected IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    private boolean isOfAcceptedType(Object obj) {
        if (this.fActivatedOnTypes != null) {
            int i = 0;
            while (i < this.fActivatedOnTypes.length) {
                if (this.fActivatedOnTypes[i].isInstance(obj)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private boolean isEnabled(IStructuredSelection selection) {
        for (Object obj : selection) {
            if (this.isOfAcceptedType(obj) && this.shouldAcceptElement(obj)) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldAcceptElement(Object obj) {
        return true;
    }

    protected abstract Wizard createWizard();

    protected IStructuredSelection getCurrentSelection() {
        IWorkbenchWindow window = this.getWorkbenchWindow();
        if (window != null) {
            IEditorInput editorInput;
            IEditorPart activeEditor;
            ISelection selection = window.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                return (IStructuredSelection)selection;
            }
            if (selection instanceof ITextSelection && (activeEditor = DesignerPlugin.getActiveEditor()) != null && (editorInput = activeEditor.getEditorInput()) instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                return new StructuredSelection((Object)fileEditorInput.getFile());
            }
        }
        return StructuredSelection.EMPTY;
    }

    public void run() {
        if (!this.fNoChecking && !this.canActionBeAdded()) {
            return;
        }
        if (!this.checkWorkspace()) {
            return;
        }
        Wizard wizard = this.createWizard();
        if (wizard instanceof IWorkbenchWizard) {
            ((IWorkbenchWizard)wizard).init(this.getWorkbench(), this.getCurrentSelection());
        }
        WizardDialog dialog = new WizardDialog(this.getWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        String title = wizard.getWindowTitle();
        if (title != null) {
            dialog.getShell().setText(title);
        }
        dialog.open();
    }

    public boolean canActionBeAdded() {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null || selection.isEmpty()) {
            return this.fAcceptEmptySelection;
        }
        return this.isEnabled(selection);
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected boolean checkWorkspace() {
        return true;
    }

    protected final boolean checkWorkspaceNotEmpty() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().getProjects().length == 0) {
            String message;
            String title;
            Shell shell = this.getWorkbenchWindow().getShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)(title = UiMessages.AbstractOpenWizardAction_emptyWorkspaceTitle), (String)(message = UiMessages.AbstractOpenWizardAction_emptyWorkspaceMessage))) {
                new NewProjectAction().run();
                return workspace.getRoot().getProjects().length != 0;
            }
            return false;
        }
        return true;
    }
}

