/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.console;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.lsp4e.debug.console.DSPStreamsProxy;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4j.debug.ProcessEventArguments;

public class DSPProcess
implements IProcess {
    private final DSPDebugTarget target;
    private final DSPStreamsProxy proxy;
    private final ProcessEventArguments processArgs;
    private final Optional<ProcessHandle> handle;
    private boolean terminated;

    public DSPProcess(DSPDebugTarget target) {
        this(target, null);
    }

    public DSPProcess(DSPDebugTarget dspDebugTarget, ProcessEventArguments args) {
        this.target = dspDebugTarget;
        this.proxy = new DSPStreamsProxy(this.target.getDebugProtocolServer());
        this.processArgs = args;
        this.handle = args != null && args.getSystemProcessId() != null ? ProcessHandle.of(args.getSystemProcessId().intValue()) : Optional.empty();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.handle)) {
            return this.handle.orElse(null);
        }
        return this.target.getAdapter(adapter);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.handle.map(h -> !h.isAlive()).orElse(this.terminated);
    }

    public void terminate() throws DebugException {
        this.terminated = true;
        this.handle.ifPresent(h -> {
            h.destroy();
            CompletableFuture.runAsync(() -> {
                boolean bl = h.destroyForcibly();
            }, CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS));
        });
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
        this.target.terminate();
    }

    public String getLabel() {
        if (this.processArgs != null && this.processArgs.getName() != null) {
            return this.processArgs.getName();
        }
        return this.target.getName();
    }

    public ILaunch getLaunch() {
        return this.target.getLaunch();
    }

    public DSPStreamsProxy getStreamsProxy() {
        return this.proxy;
    }

    public void setAttribute(String key, String value) {
    }

    public String getAttribute(String key) {
        if (ATTR_PROCESS_ID.equals(key)) {
            return this.handle.map(ProcessHandle::pid).map(Object::toString).orElse(null);
        }
        return null;
    }

    public int getExitValue() throws DebugException {
        if (this.handle.isPresent() && !this.handle.get().isAlive()) {
            throw new DebugException(Status.error((String)(String.valueOf(this.handle.get().pid()) + " is still running")));
        }
        return 0;
    }
}

