/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.typeHierarchy;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyView;
import org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyItemLabelProvider;
import org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyViewContentProvider;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class TypeHierarchyView
extends CallHierarchyView {
    public static final String ID = "org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyView";
    TypeHierarchyViewContentProvider contentProvider = new TypeHierarchyViewContentProvider();

    @Override
    public void createPartControl(Composite parent) {
        FilteredTree filteredTree = new FilteredTree(parent, 2048, new PatternFilter(), true, false){

            protected Composite createFilterControls(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.horizontalSpacing = 0;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                composite.setLayout((Layout)layout);
                Composite filterControls = super.createFilterControls(composite);
                filterControls.setLayoutData((Object)new GridData(4, 0, true, false));
                this.createToolBar(composite);
                return composite;
            }

            private void createToolBar(Composite composite) {
                ToolBar toolbar = new ToolBar(composite, 540676);
                final ToolItem hierchyModeItem = new ToolItem(toolbar, 8);
                this.updateHierarchyModeItem(hierchyModeItem, TypeHierarchyView.this.contentProvider.showSuperTypes);
                hierchyModeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).TypeHierarchyView.this.contentProvider.showSuperTypes = !(this).TypeHierarchyView.this.contentProvider.showSuperTypes;
                        this.updateHierarchyModeItem(hierchyModeItem, (this).TypeHierarchyView.this.contentProvider.showSuperTypes);
                        this.getViewer().refresh();
                    }
                });
            }

            private void updateHierarchyModeItem(ToolItem hierchyModeItem, boolean showSuperTypes) {
                hierchyModeItem.setImage(LSPImages.getImage(showSuperTypes ? "IMG_SUBTYPE" : "IMG_SUPERTYPE"));
                hierchyModeItem.setToolTipText(showSuperTypes ? Messages.typeHierarchy_show_subtypes : Messages.typeHierarchy_show_supertypes);
            }
        };
        this.treeViewer = filteredTree.getViewer();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TypeHierarchyItemLabelProvider());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getControl().setEnabled(false);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TypeHierarchyItem item = (TypeHierarchyItem)((IStructuredSelection)event.getSelection()).getFirstElement();
                LSPEclipseUtils.open(item.getUri(), item.getSelectionRange());
            }
        });
    }
}

