import { TextDocument } from 'vscode-languageserver-textdocument';
import { JSONDocument } from './jsonParser07';
import { Document, LineCounter } from 'yaml';
import { ASTNode } from '../jsonASTTypes';
import { ParserOptions } from './yamlParser07';
import { Node } from 'yaml';
import { YAMLDocDiagnostic } from '../utils/parseUtils';
import { ApplicableSchema } from './json-schema07-validator';
import { JSONSchema } from '../jsonSchema';
import { TextBuffer } from '../utils/textBuffer';
/**
 * These documents are collected into a final YAMLDocument
 * and passed to the `parseYAML` caller.
 */
export declare class SingleYAMLDocument extends JSONDocument {
    private lineCounter;
    private _internalDocument;
    root: ASTNode;
    currentDocIndex: number;
    private _lineComments;
    constructor(lineCounter?: LineCounter);
    private collectLineComments;
    set internalDocument(document: Document);
    get internalDocument(): Document;
    get lineComments(): string[];
    set lineComments(val: string[]);
    get errors(): YAMLDocDiagnostic[];
    get warnings(): YAMLDocDiagnostic[];
    getSchemas(schema: any, doc: any, node: any): any[];
    getNodeFromPosition(positionOffset: number): Node | undefined;
    findClosestNode(offset: number, textBuffer: TextBuffer): Node;
    private getProperParentByIndentation;
    getParent(node: Node): Node | undefined;
    /**
     * Match JSON Schemas to this document
     * @param schema the JSON Schema
     * @returns array of matching schemas
     */
    matchSchemas(schema: JSONSchema): ApplicableSchema[];
}
/**
 * Contains the SingleYAMLDocuments, to be passed
 * to the `parseYAML` caller.
 */
export declare class YAMLDocument {
    documents: SingleYAMLDocument[];
    private errors;
    private warnings;
    constructor(documents: SingleYAMLDocument[]);
}
export declare class YamlDocuments {
    private cache;
    /**
     * Get cached YAMLDocument
     * @param document TextDocument to parse
     * @param customTags YAML custom tags
     * @param addRootObject if true and document is empty add empty object {} to force schema usage
     * @returns the YAMLDocument
     */
    getYamlDocument(document: TextDocument, parserOptions?: ParserOptions, addRootObject?: boolean): YAMLDocument;
    /**
     * For test purpose only!
     */
    clear(): void;
    private ensureCache;
}
export declare const yamlDocumentsCache: YamlDocuments;
