/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.signing;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.signing.GpgConfigurationException;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgObjectSigner;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.GpgSignatureVerifier;
import org.eclipse.jgit.lib.GpgSignatureVerifierFactory;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.ObjectBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.TemporaryBuffer;

public class ExternalGpgSigner
extends GpgSigner
implements GpgObjectSigner {
    private static final String PINENTRY_USER_DATA = "PINENTRY_USER_DATA";
    private static final String GPG_TTY = "GPG_TTY";
    private static final byte[] SIGNATURE_START = "-----BEGIN PGP SIGNATURE-----".getBytes(StandardCharsets.US_ASCII);
    private static final PathScanner FROM_PATH = new PathScanner();

    private static void runProcess(ProcessBuilder process, InputStream in, ResultHandler stdout, ResultHandler stderr) throws IOException, CanceledException {
        String command = process.command().stream().collect(Collectors.joining(" "));
        FS.ExecutionResult result = null;
        int code = 0;
        try {
            try {
                if (GitTraceLocation.GPG.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "Spawning process: " + command);
                    GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "Environment: " + process.environment());
                }
                result = FS.DETECTED.execute(process, in);
                code = result.getRc();
                if (GitTraceLocation.GPG.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "stderr:\n" + ExternalGpgSigner.toString(result.getStderr()));
                    GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "stdout:\n" + ExternalGpgSigner.toString(result.getStdout()));
                    GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "Spawned process exited with exit code " + code);
                }
                if (code != 0) {
                    if (stderr != null) {
                        stderr.accept(result.getStderr());
                    }
                    throw new IOException(MessageFormat.format(CoreText.ExternalGpgSigner_processFailed, command, String.valueOf(Integer.toString(code)) + ": " + ExternalGpgSigner.toString(result.getStderr())));
                }
                stdout.accept(result.getStdout());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(MessageFormat.format(CoreText.ExternalGpgSigner_processInterrupted, command), e);
            }
            catch (IOException e) {
                if (GitTraceLocation.GPG.isActive()) {
                    if (result != null) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "stderr:\n" + ExternalGpgSigner.toString(result.getStderr()));
                        GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "stdout:\n" + ExternalGpgSigner.toString(result.getStdout()));
                    }
                    GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "Spawned process failed: " + command, (Throwable)e);
                }
                if (code != 0) {
                    throw e;
                }
                if (result != null) {
                    throw new IOException(MessageFormat.format(CoreText.ExternalGpgSigner_processFailed, command, ExternalGpgSigner.toString(result.getStderr())), e);
                }
                throw new IOException(MessageFormat.format(CoreText.ExternalGpgSigner_processFailed, command, e.getLocalizedMessage()), e);
            }
        }
        finally {
            if (result != null) {
                if (result.getStderr() != null) {
                    result.getStderr().destroy();
                }
                if (result.getStdout() != null) {
                    result.getStdout().destroy();
                }
            }
        }
    }

    private static String toString(TemporaryBuffer b) {
        if (b != null) {
            try {
                return new String(b.toByteArray(4000), Charset.defaultCharset());
            }
            catch (IOException e) {
                Activator.logWarning(CoreText.ExternalGpgSigner_bufferError, e);
            }
        }
        return "";
    }

    public void sign(CommitBuilder commit, String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        this.signObject((ObjectBuilder)commit, gpgSigningKey, committer, null, null);
    }

    public void signObject(ObjectBuilder object, String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider, GpgConfig config) throws CanceledException {
        try {
            String keySpec = gpgSigningKey;
            if (StringUtils.isEmptyOrNull((String)gpgSigningKey)) {
                keySpec = String.valueOf('<') + committer.getEmailAddress() + '>';
            }
            String program = config != null ? config.getProgram() : null;
            object.setGpgSignature(new GpgSignature(this.signWithGpg(object.build(), keySpec, program)));
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean canLocateSigningKey(String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        return this.canLocateSigningKey(gpgSigningKey, committer, null, null);
    }

    public boolean canLocateSigningKey(String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider, GpgConfig config) throws CanceledException {
        String program;
        String string = program = config != null ? config.getProgram() : null;
        if (StringUtils.isEmptyOrNull((String)program) && StringUtils.isEmptyOrNull((String)(program = FROM_PATH.getGpg()))) {
            return false;
        }
        String keySpec = gpgSigningKey;
        if (StringUtils.isEmptyOrNull((String)keySpec)) {
            keySpec = String.valueOf('<') + committer.getEmailAddress() + '>';
        }
        ProcessBuilder process = new ProcessBuilder(new String[0]);
        process.command(program, "--locate-keys", "--with-colons", "--batch", "--no-tty", keySpec);
        this.gpgEnvironment(process);
        try {
            boolean[] result = new boolean[1];
            ExternalGpgSigner.runProcess(process, null, b -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (BufferedReader r = new BufferedReader(new InputStreamReader(b.openInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    boolean keyFound = false;
                    while ((line = r.readLine()) != null) {
                        String[] fields;
                        if (!line.startsWith("pub:") && !line.startsWith("sub:") || (fields = line.split(":")).length <= 11 || fields[11].indexOf(115) < 0) continue;
                        keyFound = true;
                        break;
                    }
                    blArray[0] = keyFound;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }, null);
            if (!result[0] && !StringUtils.isEmptyOrNull((String)gpgSigningKey)) {
                Activator.logWarning(MessageFormat.format(CoreText.ExternalGpgSigner_noKeyFound, gpgSigningKey), null);
            }
            return result[0];
        }
        catch (IOException e) {
            Activator.logError(e.getLocalizedMessage(), e);
            return false;
        }
    }

    private byte[] signWithGpg(byte[] data, String keySpec, String gpgProgram) throws IOException, CanceledException {
        String program = gpgProgram;
        if (StringUtils.isEmptyOrNull((String)program) && StringUtils.isEmptyOrNull((String)(program = FROM_PATH.getGpg()))) {
            throw new IOException(CoreText.ExternalGpgSigner_gpgNotFound);
        }
        ProcessBuilder process = new ProcessBuilder(new String[0]);
        process.command(program, "-bsau", keySpec, "--batch", "--no-tty", "--status-fd", "2", "--output", "-");
        this.gpgEnvironment(process);
        Throwable throwable = null;
        Object var7_8 = null;
        try (ByteArrayInputStream dataIn = new ByteArrayInputStream(data);){
            class Holder {
                byte[] rawData;

                Holder() {
                }
            }
            Holder result = new Holder();
            ExternalGpgSigner.runProcess(process, dataIn, b -> {
                GpgSignatureVerifierFactory factory = GpgSignatureVerifierFactory.getDefault();
                boolean isValid = false;
                if (factory == null) {
                    byte[] fromGpg = b.toByteArray(SIGNATURE_START.length);
                    isValid = Arrays.equals(fromGpg, SIGNATURE_START);
                    if (isValid) {
                        holder.rawData = b.toByteArray();
                    }
                } else {
                    byte[] fromGpg = b.toByteArray();
                    GpgSignatureVerifier verifier = factory.getVerifier();
                    try {
                        try {
                            GpgSignatureVerifier.SignatureVerification verification = verifier.verify(data, fromGpg);
                            boolean bl = isValid = verification != null && verification.getVerified();
                            if (isValid) {
                                holder.rawData = fromGpg;
                            }
                        }
                        catch (JGitInternalException e) {
                            throw new IOException(e.getLocalizedMessage(), e);
                        }
                    }
                    finally {
                        verifier.clear();
                    }
                }
                if (!isValid) {
                    throw new IOException(MessageFormat.format(CoreText.ExternalGpgSigner_noSignature, ExternalGpgSigner.toString(b)));
                }
            }, e -> {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (BufferedReader r = new BufferedReader(new InputStreamReader(e.openInputStream(), StandardCharsets.UTF_8));){
                        String line;
                        boolean pinentry = false;
                        while ((line = r.readLine()) != null) {
                            if (!pinentry && line.startsWith("[GNUPG:] PINENTRY_LAUNCHED")) {
                                pinentry = true;
                                this.checkTerminalPrompt(line);
                                continue;
                            }
                            if (!pinentry) continue;
                            if (line.startsWith("[GNUPG:] FAILURE sign")) {
                                throw new CanceledException(CoreText.ExternalGpgSigner_signingCanceled);
                            }
                            if (!line.startsWith("[GNUPG:]")) continue;
                            pinentry = false;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return result.rawData;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void gpgEnvironment(ProcessBuilder process) {
        try {
            Map<String, String> childEnv = process.environment();
            String value = childEnv.get(PINENTRY_USER_DATA);
            if (!StringUtils.isEmptyOrNull((String)value)) {
                childEnv.remove(PINENTRY_USER_DATA);
            }
            if (!StringUtils.isEmptyOrNull((String)(value = childEnv.get(GPG_TTY)))) {
                childEnv.remove(GPG_TTY);
            }
        }
        catch (IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
            Activator.logWarning(CoreText.ExternalGpgSigner_environmentError, e);
        }
    }

    private void checkTerminalPrompt(String gpgTraceLine) {
        String pinentryType;
        String[] parts = gpgTraceLine.split(" ");
        if (parts.length > 3 && "[GNUPG:]".equals(parts[0]) && "PINENTRY_LAUNCHED".equals(parts[1]) && ("tty".equals(pinentryType = parts[3]) || "curses".equals(pinentryType))) {
            throw new GpgConfigurationException(MessageFormat.format(CoreText.ExternalGpgSigner_ttyInput, gpgTraceLine));
        }
    }

    private static class PathScanner {
        private String gpg;

        private PathScanner() {
        }

        synchronized String getGpg() {
            if (this.gpg == null) {
                this.gpg = PathScanner.findGpg();
            }
            return this.gpg.isEmpty() ? null : this.gpg;
        }

        private static String findGpg() {
            String bash;
            SystemReader system = SystemReader.getInstance();
            String path = system.getenv("PATH");
            String exe = null;
            if (system.isMacOS() && (bash = PathScanner.searchPath(path, "bash")) != null) {
                ProcessBuilder process = new ProcessBuilder(new String[0]);
                process.command(bash, "--login", "-c", "which gpg");
                process.directory(FS.DETECTED.userHome());
                String[] result = new String[1];
                try {
                    ExternalGpgSigner.runProcess(process, null, b -> {
                        Throwable throwable = null;
                        Object var3_4 = null;
                        try (BufferedReader r = new BufferedReader(new InputStreamReader(b.openInputStream(), Charset.defaultCharset()));){
                            stringArray[0] = r.readLine();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }, null);
                }
                catch (IOException | CanceledException e) {
                    Activator.logWarning(CoreText.ExternalGpgSigner_cannotSearch, e);
                }
                exe = result[0];
            }
            if (exe == null) {
                exe = PathScanner.searchPath(path, system.isWindows() ? "gpg.exe" : "gpg");
            }
            return exe == null ? "" : exe;
        }

        private static String searchPath(String path, String name) {
            if (StringUtils.isEmptyOrNull((String)path)) {
                return null;
            }
            String[] stringArray = path.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                File exe = new File(p, name);
                try {
                    if (exe.isFile() && exe.canExecute()) {
                        return exe.getAbsolutePath();
                    }
                }
                catch (SecurityException e) {
                    Activator.logWarning(MessageFormat.format(CoreText.ExternalGpgSigner_skipNotAccessiblePath, exe.getPath()), e);
                }
                ++n2;
            }
            return null;
        }
    }

    private static interface ResultHandler {
        public void accept(TemporaryBuffer var1) throws IOException, CanceledException;
    }
}

