/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.block;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.AsciiDocBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.util.LanguageSupport;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.TableAttributes;
import org.eclipse.mylyn.wikitext.parser.TableCellAttributes;
import org.eclipse.mylyn.wikitext.parser.TableRowAttributes;

public class TableBlock
extends AsciiDocBlock {
    private TableFormat format;
    private String separator;
    private int cellsCount = 0;
    private List<TableCellAttributes> colsAttribute;
    private boolean hasHeader = false;
    private boolean cellBlockIsOpen = false;
    private int cellSpan = 1;

    public TableBlock() {
        super(Pattern.compile("^(\\||,|:)===\\s*"));
    }

    @Override
    protected void processBlockStart() {
        String options;
        String separator;
        if (this.startDelimiter.startsWith(",")) {
            this.format = TableFormat.COMMA_SEPARATED_VALUES;
            this.hasHeader = true;
        } else if (this.startDelimiter.startsWith(":")) {
            this.format = TableFormat.DELIMITER_SEPARATED_VALUES;
            this.hasHeader = true;
        } else {
            this.format = TableFormat.PREFIX_SEPARATED_VALUES;
            this.separator = "|";
        }
        Map<String, String> lastProperties = this.getAsciiDocState().getLastProperties(Collections.emptyList());
        this.colsAttribute = LanguageSupport.computeColumnsAttributeList(lastProperties.get("cols"));
        String formatProperty = lastProperties.get("format");
        if (formatProperty != null) {
            switch (formatProperty) {
                case "dsv": {
                    this.format = TableFormat.DELIMITER_SEPARATED_VALUES;
                    break;
                }
                case "csv": {
                    this.format = TableFormat.COMMA_SEPARATED_VALUES;
                }
            }
        }
        if ((separator = lastProperties.get("separator")) != null) {
            this.separator = separator;
        }
        if ((options = lastProperties.get("options")) != null) {
            this.hasHeader = options.contains("header");
        }
        TableAttributes tableAttributes = new TableAttributes();
        tableAttributes.setWidth(lastProperties.get("width"));
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, (Attributes)tableAttributes);
    }

    private final boolean isColFormatKnown() {
        return !this.colsAttribute.isEmpty();
    }

    private final boolean isFirstRow() {
        return this.colsAttribute.isEmpty() || this.cellsCount < this.colsAttribute.size();
    }

    @Override
    protected void processBlockContent(String line) {
        if (!line.trim().isEmpty()) {
            if (!this.isColFormatKnown() && !this.cellBlockIsOpen) {
                TableRowAttributes tableRowAttributes = new TableRowAttributes();
                this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, (Attributes)tableRowAttributes);
            }
            int offset = 0;
            Matcher rowCellMatcher = this.createRowCellMatcher(line);
            while (offset <= line.length()) {
                boolean found = rowCellMatcher.find();
                int endOffset = found ? rowCellMatcher.start() : line.length();
                String fullCellContent = line.substring(offset, endOffset);
                String cellContent = fullCellContent.trim();
                int contentOffset = offset + fullCellContent.indexOf(cellContent);
                if (this.format == TableFormat.PREFIX_SEPARATED_VALUES) {
                    this.handleCellContent(cellContent, contentOffset, offset == 0 && !cellContent.isEmpty());
                    if (found) {
                        if (!this.isColFormatKnown() && offset == 0 && endOffset == 0 && (this.cellsCount > 0 || this.cellBlockIsOpen)) {
                            this.colsAttribute = LanguageSupport.createDefaultColumnsAttributeList(this.cellsCount + this.cellSpan);
                        }
                        this.closeCellBlockIfNeeded();
                        String spanGroup = rowCellMatcher.group(1);
                        this.cellSpan = spanGroup != null && !spanGroup.isEmpty() ? Integer.parseInt(spanGroup.substring(0, spanGroup.length() - 1)) : 1;
                        String alignGroup = rowCellMatcher.group(2);
                        this.openCellBlock(alignGroup == null ? "" : alignGroup);
                    }
                } else {
                    if (!found && !this.isColFormatKnown()) {
                        this.colsAttribute = LanguageSupport.createDefaultColumnsAttributeList(this.cellsCount + 1);
                    }
                    this.openCellBlock("");
                    this.handleCellContent(cellContent, contentOffset, false);
                    this.closeCellBlockIfNeeded();
                }
                offset = found ? rowCellMatcher.end() : line.length() + 1;
            }
        }
    }

    private Matcher createRowCellMatcher(String line) {
        String delimiter = this.getCellSeparator();
        switch (this.format) {
            case COMMA_SEPARATED_VALUES: {
                String regex = ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
                return Pattern.compile(regex).matcher(line);
            }
            case DELIMITER_SEPARATED_VALUES: {
                return Pattern.compile("(?<!\\\\)" + Pattern.quote(delimiter)).matcher(line);
            }
        }
        return Pattern.compile("(\\d+\\+)?([<^>])?(?<!\\\\)" + Pattern.quote(delimiter)).matcher(line);
    }

    private String getCellSeparator() {
        switch (this.format) {
            case COMMA_SEPARATED_VALUES: {
                return ",";
            }
            case DELIMITER_SEPARATED_VALUES: {
                return ":";
            }
        }
        return this.separator;
    }

    private void openCellBlock(String alignCode) {
        this.closeCellBlockIfNeeded();
        if (this.isColFormatKnown() && this.cellsCount % this.colsAttribute.size() == 0) {
            TableRowAttributes tableRowAttributes = new TableRowAttributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, (Attributes)tableRowAttributes);
        }
        TableCellAttributes attributes = this.colsAttribute.isEmpty() ? new TableCellAttributes() : (TableCellAttributes)this.colsAttribute.get(this.cellsCount % this.colsAttribute.size()).clone();
        attributes.setColspan(this.cellSpan > 1 ? Integer.toString(this.cellSpan) : null);
        switch (alignCode) {
            case "<": {
                attributes.setAlign("left");
                break;
            }
            case "^": {
                attributes.setAlign("center");
                break;
            }
            case ">": {
                attributes.setAlign("right");
                break;
            }
        }
        this.builder.beginBlock(this.hasHeader && this.isFirstRow() ? DocumentBuilder.BlockType.TABLE_CELL_HEADER : DocumentBuilder.BlockType.TABLE_CELL_NORMAL, (Attributes)attributes);
        this.cellBlockIsOpen = true;
    }

    private void handleCellContent(String cellContent, int positionInLine, boolean append) {
        String blockContent;
        if (!this.cellBlockIsOpen) {
            return;
        }
        String string = blockContent = append ? " " : "";
        if (this.format == TableFormat.COMMA_SEPARATED_VALUES) {
            blockContent = cellContent.startsWith("\"") && cellContent.endsWith("\"") ? blockContent + cellContent.substring(1, cellContent.length() - 1).replaceAll("\"\"", "\"") : blockContent + cellContent;
        } else {
            String delimiter = this.getCellSeparator();
            blockContent = blockContent + cellContent.replaceAll("\\\\" + Pattern.quote(delimiter), delimiter);
        }
        this.markupLanguage.emitMarkupLine(this.parser, this.state, positionInLine, blockContent, 0);
    }

    @Override
    protected void processBlockEnd() {
        this.closeCellBlockIfNeeded();
        if (!this.isColFormatKnown() && this.cellsCount > 0 || this.isColFormatKnown() && this.cellsCount % this.colsAttribute.size() != 0) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    private void closeCellBlockIfNeeded() {
        if (this.cellBlockIsOpen) {
            this.builder.endBlock();
            this.cellBlockIsOpen = false;
            this.cellsCount += this.cellSpan;
            if (!this.colsAttribute.isEmpty() && this.cellsCount % this.colsAttribute.size() == 0) {
                this.builder.endBlock();
            }
        }
    }

    private static enum TableFormat {
        PREFIX_SEPARATED_VALUES,
        DELIMITER_SEPARATED_VALUES,
        COMMA_SEPARATED_VALUES;

    }
}

