/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.violation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.wtp.releng.tools.component.IFileLocation;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationChildrenIterator;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.IZipLocation;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PluginVisitor
implements ILocationVisitor {
    private List pluginIds = new ArrayList();

    public Collection getPluginIds() {
        return new ArrayList(this.pluginIds);
    }

    public boolean accept(ILocation location) {
        String locationName = location.getName();
        if (locationName.endsWith("MANIFEST.MF")) {
            this.acceptManifest(location);
        } else {
            if (Location.isArchive(locationName)) {
                return this.acceptSingleJar(location);
            }
            if (locationName.endsWith(".classpath")) {
                this.acceptDotClasspath(location);
            }
        }
        if (location instanceof IZipLocation) {
            return true;
        }
        return location instanceof IFileLocation && ((IFileLocation)location).getFile().isDirectory();
    }

    private void acceptManifest(ILocation location) {
        try {
            String bundleName;
            Manifest manifest = new Manifest(location.getInputStream());
            Attributes attrs = manifest.getMainAttributes();
            String bundleNameAttr = attrs.getValue(new Attributes.Name("Bundle-SymbolicName"));
            if (bundleNameAttr != null && (bundleName = new StringTokenizer(bundleNameAttr, ";").nextToken().trim()) != null && bundleName.length() > 0 && !this.pluginIds.contains(bundleName)) {
                this.pluginIds.add(bundleName);
            }
        }
        catch (IOException iOException) {}
    }

    private boolean acceptSingleJar(ILocation location) {
        ILocationChildrenIterator it = location.childIterator();
        boolean pluginAdded = false;
        ILocation child = it.next();
        while (child != null) {
            String name = child.getName();
            if (name.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                try {
                    String bundleName;
                    Manifest manifest = new Manifest(child.getInputStream());
                    Attributes attrs = manifest.getMainAttributes();
                    String bundleNameAttr = attrs.getValue(new Attributes.Name("Bundle-SymbolicName"));
                    if (bundleNameAttr != null && (bundleName = new StringTokenizer(bundleNameAttr, ";").nextToken().trim()) != null && bundleName.length() > 0 && !this.pluginIds.contains(bundleName)) {
                        this.pluginIds.add(bundleName);
                        pluginAdded = true;
                    }
                }
                catch (IOException iOException) {}
            }
            child = it.next();
        }
        if (!pluginAdded && Location.getExtension(location.getName()).equalsIgnoreCase("jar")) {
            try {
                String bundleName;
                Attributes attrs;
                String bundleNameAttr;
                JarInputStream jis = new JarInputStream(location.getInputStream());
                Manifest manifest = jis.getManifest();
                if (manifest != null && (bundleNameAttr = (attrs = manifest.getMainAttributes()).getValue(new Attributes.Name("Bundle-SymbolicName"))) != null && (bundleName = new StringTokenizer(bundleNameAttr, ";").nextToken().trim()) != null && bundleName.length() > 0 && !this.pluginIds.contains(bundleName)) {
                    this.pluginIds.add(bundleName);
                    pluginAdded = true;
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private void acceptDotClasspath(ILocation location) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(location.getInputStream());
            Element root = doc.getDocumentElement();
            if (root.getTagName().equals("classpath")) {
                NodeList cpEntries = root.getElementsByTagName("classpathentry");
                int i = 0;
                while (i < cpEntries.getLength()) {
                    int j;
                    String absPath;
                    String s;
                    String id;
                    Element cpEntry = (Element)cpEntries.item(i);
                    String kind = cpEntry.getAttribute("kind");
                    if (kind != null && kind.equals("output") && (id = (s = (absPath = location.getAbsolutePath().replace('\\', '/')).substring(0, j = absPath.lastIndexOf(47))).substring(s.lastIndexOf(47) + 1, j)) != null && id.length() > 0 && !this.pluginIds.contains(id)) {
                        this.pluginIds.add(id);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {}
    }
}

