/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.internal.core.util.ClassFileReader;
import org.eclipse.wtp.releng.tools.component.IClassVisitor;
import org.eclipse.wtp.releng.tools.component.IFileLocation;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationChildrenIterator;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.IZipLocation;
import org.eclipse.wtp.releng.tools.component.adopters.Java2API;
import org.eclipse.wtp.releng.tools.component.internal.ComponentDepends;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Plugin2API
implements ILocationVisitor,
IClassVisitor {
    private Collection src;
    private String outputDir;
    private Map lib2pluginId = new HashMap();
    private boolean visitPlugins;
    private List visitedPlugins;
    private ComponentXML cachedCompXML;
    private static final String COMPONENT_XML = "/component.xml";
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String FRAGMENT_XML = "fragment.xml";
    private static final String MANIFEST_MF = "MANIFEST.MF";
    private static final String DOT_CLASSPATH = ".classpath";
    private static final String CLASS = ".class";
    private static final String PLUGIN = "plugin";
    private static final String ID = "id";
    private static final String RUNTIME = "runtime";
    private static final String LIBRARY = "library";
    private static final String NAME = "name";
    private static final String FRAGMENT = "fragment";
    private static final String META_INF_MANIFEST = "META-INF/MANIFEST.MF";
    private static final String CLASSPATH = "classpath";
    private static final String CLASSPATHENTRY = "classpathentry";
    private static final String KIND = "kind";
    private static final String OUTPUT = "output";
    private static final String PATH = "path";
    private static final String JAR = "jar";

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = this.addTrailingSeperator(outputDir);
    }

    protected String addTrailingSeperator(String s) {
        if (s != null && !s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    public Collection getSrc() {
        return this.src;
    }

    public void setSrc(String aSrc) {
        this.src = new ArrayList(1);
        this.src.add(aSrc);
    }

    public void setSrc(Collection aSrc) {
        this.src = aSrc;
    }

    public void execute() {
        Java2API java2API = new Java2API();
        java2API.setOutputDir(this.outputDir);
        java2API.setDefaultExclusive(false);
        Iterator it = this.src.iterator();
        while (it.hasNext()) {
            java2API.setSrc((String)it.next());
            java2API.execute();
        }
        this.visitedPlugins = java2API.getVisitedPlugins();
        it = this.src.iterator();
        while (it.hasNext()) {
            this.visitPlugins = true;
            ILocation srcLocation = Location.createLocation(new File((String)it.next()));
            srcLocation.accept(this);
            this.visitPlugins = false;
            srcLocation.accept(this);
        }
    }

    public boolean visit(String pluginId, ILocation classLoc) {
        try {
            IClassFileReader reader = this.read(classLoc);
            String className = new String(reader.getClassName()).replace('/', '.');
            int i = className.lastIndexOf(46);
            String pkgName = i != -1 ? className.substring(0, i) : "";
            ComponentXML compXML = this.getComponentXML(pluginId);
            if (compXML.getPackage(pkgName) == null) {
                Package pkg = new Package();
                pkg.setName(pkgName);
                pkg.setApi(Boolean.TRUE);
                pkg.setExclusive(Boolean.FALSE);
                compXML.addPackage(pkg);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassFormatException cfe) {
            throw new RuntimeException(cfe);
        }
        return true;
    }

    private IClassFileReader read(ILocation classLoc) throws IOException, ClassFormatException {
        ClassFileReader classFileReader;
        ByteArrayOutputStream baos;
        block11: {
            InputStream is = null;
            baos = null;
            try {
                byte[] b = new byte[8192];
                baos = new ByteArrayOutputStream(8192);
                is = classLoc.getInputStream();
                int read = is.read(b);
                while (read != -1) {
                    baos.write(b, 0, read);
                    read = is.read(b);
                }
                is.close();
                baos.close();
                classFileReader = new ClassFileReader(baos.toByteArray(), 47);
                Object var6_7 = null;
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var6_8 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (baos == null) break block13;
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (baos != null) {
            try {
                baos.close();
            }
            catch (IOException iOException) {}
        }
        return classFileReader;
    }

    private ComponentXML getComponentXML(String id) throws IOException {
        if (this.cachedCompXML != null) {
            if (this.cachedCompXML.getName().equals(id)) {
                return this.cachedCompXML;
            }
            this.cachedCompXML.save();
        }
        StringBuffer sb = new StringBuffer(this.outputDir);
        sb.append(id);
        sb.append(COMPONENT_XML);
        File file = new File(sb.toString());
        this.cachedCompXML = new ComponentXML();
        this.cachedCompXML.setName(id);
        this.cachedCompXML.setLocation(new FileLocation(file));
        Plugin plugin = new Plugin();
        plugin.setId(id);
        this.cachedCompXML.addPlugin(plugin);
        ComponentDepends compDepends = new ComponentDepends();
        compDepends.setUnrestricted(Boolean.TRUE);
        this.cachedCompXML.setComponentDepends(compDepends);
        if (file.exists()) {
            this.cachedCompXML.load();
        }
        return this.cachedCompXML;
    }

    public boolean accept(ILocation location) {
        String locationName = location.getName();
        if (this.visitPlugins) {
            if (locationName.endsWith(MANIFEST_MF)) {
                this.acceptManifest(location);
            } else {
                if (Location.isArchive(locationName)) {
                    return this.acceptSingleJar(location);
                }
                if (locationName.endsWith(DOT_CLASSPATH)) {
                    this.acceptDotClasspath(location);
                }
            }
        } else {
            String id;
            String idTemp = (String)this.lib2pluginId.get(locationName.replace('\\', '/'));
            if (idTemp == null) {
                idTemp = (String)this.lib2pluginId.get(location.getAbsolutePath().replace('\\', '/'));
            }
            if ((id = idTemp) != null) {
                location.accept(new ILocationVisitor(){

                    public boolean accept(ILocation aLocation) {
                        if (aLocation.getName().endsWith(Plugin2API.CLASS)) {
                            Plugin2API.this.visit(id, aLocation);
                        }
                        return true;
                    }
                });
            }
        }
        if (location instanceof IZipLocation) {
            return true;
        }
        return location instanceof IFileLocation && ((IFileLocation)location).getFile().isDirectory();
    }

    private void acceptManifest(ILocation location) {
        String locationName = location.getName();
        try {
            String bundleCPAttr;
            String bundleName;
            Manifest manifest = new Manifest(location.getInputStream());
            Attributes attrs = manifest.getMainAttributes();
            String bundleNameAttr = attrs.getValue(new Attributes.Name("Bundle-SymbolicName"));
            if (bundleNameAttr != null && !this.visitedPlugins.contains(bundleName = new StringTokenizer(bundleNameAttr, ";").nextToken().trim()) && (bundleCPAttr = attrs.getValue("Bundle-ClassPath")) != null) {
                StringTokenizer cp = new StringTokenizer(bundleCPAttr, ",");
                while (cp.hasMoreTokens()) {
                    String path = cp.nextToken().trim();
                    if (path == null || path.length() <= 0) continue;
                    StringBuffer sb = new StringBuffer();
                    if (locationName.equalsIgnoreCase(MANIFEST_MF)) {
                        locationName = location.getAbsolutePath();
                    }
                    sb.append(locationName.substring(0, locationName.length() - META_INF_MANIFEST.length() - 1));
                    sb.append("/");
                    sb.append(path);
                    this.lib2pluginId.put(sb.toString().replace('\\', '/'), bundleName);
                }
            }
        }
        catch (IOException iOException) {}
    }

    private boolean acceptSingleJar(ILocation location) {
        String bundleName;
        ILocationChildrenIterator it = location.childIterator();
        ILocation child = it.next();
        while (child != null) {
            String name = child.getName();
            if (name.equalsIgnoreCase(META_INF_MANIFEST)) {
                try {
                    Manifest manifest = new Manifest(child.getInputStream());
                    Attributes attrs = manifest.getMainAttributes();
                    bundleName = attrs.getValue(new Attributes.Name("Bundle-SymbolicName"));
                    if (bundleName != null && !this.visitedPlugins.contains(bundleName = new StringTokenizer(bundleName, ";").nextToken().trim())) {
                        this.lib2pluginId.put(location.getName().replace('\\', '/'), bundleName);
                        return false;
                    }
                }
                catch (IOException iOException) {}
            }
            child = it.next();
        }
        if (Location.getExtension(location.getName()).equalsIgnoreCase(JAR)) {
            try {
                Attributes attrs;
                String bundleNameAttr;
                JarInputStream jis = new JarInputStream(location.getInputStream());
                Manifest manifest = jis.getManifest();
                if (manifest != null && (bundleNameAttr = (attrs = manifest.getMainAttributes()).getValue(new Attributes.Name("Bundle-SymbolicName"))) != null && !this.visitedPlugins.contains(bundleNameAttr) && (bundleName = new StringTokenizer(bundleNameAttr, ";").nextToken().trim()) != null) {
                    bundleName = new StringTokenizer(bundleName, ";").nextToken().trim();
                    this.lib2pluginId.put(location.getName().replace('\\', '/'), bundleName);
                    return false;
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private void acceptDotClasspath(ILocation location) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(location.getInputStream());
            Element root = doc.getDocumentElement();
            if (root.getTagName().equals(CLASSPATH)) {
                NodeList cpEntries = root.getElementsByTagName(CLASSPATHENTRY);
                int i = 0;
                while (i < cpEntries.getLength()) {
                    Element cpEntry = (Element)cpEntries.item(i);
                    String kind = cpEntry.getAttribute(KIND);
                    if (kind != null && kind.equals(OUTPUT)) {
                        String path = cpEntry.getAttribute(PATH);
                        String absPath = location.getAbsolutePath().replace('\\', '/');
                        StringBuffer lib = new StringBuffer();
                        int j = absPath.lastIndexOf(47);
                        String s = absPath.substring(0, j);
                        String id = s.substring(s.lastIndexOf(47) + 1, j);
                        if (!this.visitedPlugins.contains(id)) {
                            lib.append(s);
                            lib.append('/');
                            lib.append(path);
                            this.lib2pluginId.put(lib.toString(), id);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {}
    }
}

