/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.results.BuildResults;
import org.eclipse.test.internal.performance.results.SQL_Results;
import org.eclipse.test.internal.performance.results.ScenarioResults;

public class DB_Results {
    static final boolean DEBUG = false;
    static final boolean LOG = false;
    private static final String DERBY = "derby";
    private static final String CLOUDSCAPE = "cloudscape";
    private static DB_Results fgDefault;
    private Connection fConnection;
    private SQL_Results fSQL;
    private boolean fIsEmbedded;
    private String fDBType;
    static final StringWriter DEBUG_STR_WRITER;
    static final PrintWriter DEBUG_WRITER;
    static final StringWriter LOG_STR_WRITER;
    static final LogWriter LOG_WRITER;
    private static String[] CONFIGS;
    private static String[] COMPONENTS;
    private static String[] BUILDS;
    private static int BUILDS_LENGTH;
    private static String[] SCENARII;
    private static String[] COMMENTS;
    private static final int MAX_CONFIGS = 5;
    private static final String[] SUPPORTED_VMS;
    private static final String[] SUPPORTED_COMPONENTS;

    static {
        DEBUG_STR_WRITER = null;
        DEBUG_WRITER = null;
        LOG_STR_WRITER = new StringWriter();
        LOG_WRITER = new LogWriter();
        SUPPORTED_VMS = new String[]{"sun"};
        SUPPORTED_COMPONENTS = new String[]{"org.eclipse.ant", "org.eclipse.compare", "org.eclipse.core", "org.eclipse.help", "org.eclipse.jdt.core", "org.eclipse.jdt.debug", "org.eclipse.jdt.text", "org.eclipse.jdt.ui", "org.eclipse.jface", "org.eclipse.osgi", "org.eclipse.pde.ui", "org.eclipse.swt", "org.eclipse.team", "org.eclipse.ua", "org.eclipse.ui", "org.eclipse.wst", "org.eclipse.jst", "org.eclipse.jpt"};
    }

    private DB_Results() {
    }

    static synchronized DB_Results getDefault() {
        if (fgDefault == null) {
            fgDefault = new DB_Results();
            fgDefault.connect();
            if (PerformanceTestPlugin.getDefault() == null) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        DB_Results.shutdown();
                    }
                });
            }
        }
        return fgDefault;
    }

    public static void shutdown() {
        if (fgDefault != null) {
            fgDefault.disconnect();
            fgDefault = null;
        }
    }

    static List getAllComponents() {
        return Arrays.asList(COMPONENTS);
    }

    static int getBuildId(String name) {
        if (BUILDS == null) {
            return -1;
        }
        return Arrays.binarySearch(BUILDS, name);
    }

    static String getBuildName(int id) {
        if (BUILDS == null) {
            return null;
        }
        return BUILDS[id];
    }

    static String getComponentNameFromScenario(String scenarioName) {
        int length = SUPPORTED_COMPONENTS.length;
        int i = 0;
        while (i < length) {
            if (scenarioName.startsWith(SUPPORTED_COMPONENTS[i])) {
                return SUPPORTED_COMPONENTS[i];
            }
            ++i;
        }
        return null;
    }

    static String getConfig(int id) {
        return CONFIGS[id];
    }

    public static List getScenariosNames() {
        return Arrays.asList(SCENARII);
    }

    static Map queryAllScenarios(String scenarioPattern, String buildName) {
        return DB_Results.getDefault().internalQueryBuildScenarios(scenarioPattern, buildName);
    }

    static void queryAllVariations(String configPattern) {
        DB_Results.getDefault().internalQueryAllVariations(configPattern);
    }

    static void queryScenarioFailures(ScenarioResults scenarioResults, String configPattern, BuildResults currentBuild, BuildResults baselineBuild) {
        DB_Results.getDefault().internalQueryScenarioFailures(scenarioResults, configPattern, currentBuild, baselineBuild);
    }

    static void queryScenarioSummaries(ScenarioResults scenarioResults, String configPattern, BuildResults currentBuild, BuildResults baselineBuild) {
        DB_Results.getDefault().internalQueryScenarioSummaries(scenarioResults, configPattern, currentBuild, baselineBuild);
    }

    static void queryScenarioValues(ScenarioResults scenarioResults, String configPattern) {
        DB_Results.getDefault().internalQueryScenarioValues(scenarioResults, configPattern, null, -1L);
    }

    static void queryScenarioValues(ScenarioResults scenarioResults, String configPattern, String lastBuildName, long lastBuildDate) {
        DB_Results.getDefault().internalQueryScenarioValues(scenarioResults, configPattern, lastBuildName, lastBuildDate);
    }

    private void connect() {
        if (this.fConnection != null) {
            return;
        }
        String dbloc = PerformanceTestPlugin.getDBLocation();
        if (dbloc == null) {
            return;
        }
        String dbname = PerformanceTestPlugin.getDBName();
        String url = null;
        Properties info = new Properties();
        this.fDBType = DERBY;
        try {
            if (dbloc.startsWith("net://")) {
                this.fIsEmbedded = false;
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("retrieveMessagesFromServerOnGetMessage", "true");
                info.put("create", "true");
                url = String.valueOf(dbloc) + '/' + dbname;
            } else if (dbloc.startsWith("//")) {
                this.fIsEmbedded = false;
                Class.forName("org.apache.derby.jdbc.ClientDriver");
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("create", "true");
                url = String.valueOf(dbloc) + '/' + dbname;
            } else {
                File f;
                if ("Mac OS X".equals(System.getProperty("os.name"))) {
                    System.setProperty("derby.storage.fileSyncTransactionLog", "true");
                }
                this.fIsEmbedded = true;
                try {
                    Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Class.forName("com.ihost.cs.jdbc.CloudscapeDriver");
                    this.fDBType = CLOUDSCAPE;
                }
                if (dbloc.length() == 0) {
                    String user_home = System.getProperty("user.home");
                    if (user_home == null) {
                        return;
                    }
                    f = new File(user_home, this.fDBType);
                } else {
                    f = new File(dbloc);
                }
                url = new File(f, dbname).getAbsolutePath();
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("create", "true");
            }
            try {
                this.fConnection = DriverManager.getConnection("jdbc:" + this.fDBType + ":" + url, info);
            }
            catch (SQLException e) {
                if ("08001".equals(e.getSQLState()) && DERBY.equals(this.fDBType)) {
                    this.fDBType = CLOUDSCAPE;
                    this.fConnection = DriverManager.getConnection("jdbc:" + this.fDBType + ":" + url, info);
                }
                throw e;
            }
            this.fConnection.setAutoCommit(false);
            this.fSQL = new SQL_Results(this.fConnection);
            this.fConnection.commit();
        }
        catch (SQLException ex) {
            PerformanceTestPlugin.logError(ex.getMessage());
        }
        catch (ClassNotFoundException e) {
            PerformanceTestPlugin.log(e);
        }
    }

    private void disconnect() {
        block11: {
            if (this.fSQL != null) {
                try {
                    this.fSQL.dispose();
                }
                catch (SQLException e1) {
                    PerformanceTestPlugin.log(e1);
                }
                this.fSQL = null;
            }
            if (this.fConnection != null) {
                try {
                    this.fConnection.commit();
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                }
                try {
                    this.fConnection.close();
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                }
                this.fConnection = null;
            }
            if (this.fIsEmbedded) {
                try {
                    DriverManager.getConnection("jdbc:" + this.fDBType + ":;shutdown=true");
                }
                catch (SQLException e) {
                    String message = e.getMessage();
                    if (message.indexOf("system shutdown.") >= 0) break block11;
                    e.printStackTrace();
                }
            }
        }
    }

    private int getConfigId(String config) {
        if (CONFIGS == null) {
            return -1;
        }
        return Arrays.binarySearch(CONFIGS, config);
    }

    SQL_Results getSQL() {
        return this.fSQL;
    }

    /*
     * Exception decompiling
     */
    private void internalQueryAllComments() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 151->155)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void internalQueryAllVariations(String configPattern) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 225->229)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Map internalQueryBuildScenarios(String scenarioPattern, String buildName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 234->237)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void internalQueryScenarioValues(ScenarioResults scenarioResults, String configPattern, String lastBuildName, long lastBuildDate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 259->263)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void internalQueryScenarioFailures(ScenarioResults scenarioResults, String config, BuildResults currentBuild, BuildResults baselineBuild) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 183->187)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void internalQueryScenarioSummaries(ScenarioResults scenarioResults, String config, BuildResults currentBuild, BuildResults baselineBuild) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 367->371)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int storeComponent(String component) {
        int idx;
        if (COMPONENTS == null) {
            COMPONENTS = new String[SUPPORTED_COMPONENTS.length];
        }
        if ((idx = Arrays.binarySearch(SUPPORTED_COMPONENTS, component)) < 0) {
            throw new RuntimeException("Unexpected component name: " + component);
        }
        if (COMPONENTS[idx] == null) {
            DB_Results.COMPONENTS[idx] = SUPPORTED_COMPONENTS[idx];
        }
        return idx;
    }

    private int storeBuildName(String build) {
        if (BUILDS == null) {
            BUILDS = new String[1];
            DB_Results.BUILDS[DB_Results.BUILDS_LENGTH++] = build;
            return 0;
        }
        int idx = Arrays.binarySearch(BUILDS, build);
        if (idx >= 0) {
            return idx;
        }
        int index = -idx - 1;
        int length = BUILDS.length;
        if (BUILDS_LENGTH == length) {
            String[] array = new String[length + 1];
            if (index > 0) {
                System.arraycopy(BUILDS, 0, array, 0, index);
            }
            array[index] = build;
            if (index < length) {
                System.arraycopy(BUILDS, index, array, index + 1, length - index);
            }
            BUILDS = array;
        } else if (index < length) {
            System.arraycopy(BUILDS, index, BUILDS, index + 1, length - index);
            DB_Results.BUILDS[index] = build;
        }
        ++BUILDS_LENGTH;
        return index;
    }

    private int storeConfig(String config) {
        int i = 0;
        while (i < 5) {
            if (CONFIGS[i] == null) {
                DB_Results.CONFIGS[i] = config;
                return i;
            }
            if (config.equals(CONFIGS[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static class LogWriter
    extends PrintWriter {
        long[] starts = new long[10];
        long[] times = new long[10];
        StringBuffer[] buffers = new StringBuffer[10];
        int depth = -1;
        int max = -1;

        public LogWriter() {
            super(LOG_STR_WRITER);
        }

        void starts(String log) {
            if (++this.depth >= this.buffers.length) {
                this.times = new long[this.depth + 10];
                System.arraycopy(this.times, 0, this.times, 0, this.depth);
                this.buffers = new StringBuffer[this.depth + 10];
                System.arraycopy(this.buffers, 0, this.buffers, 0, this.depth);
            }
            StringBuffer buffer = this.buffers[this.depth];
            if (this.buffers[this.depth] == null) {
                buffer = this.buffers[this.depth] = new StringBuffer();
            }
            buffer.append(log);
            this.starts[this.depth] = System.currentTimeMillis();
            if (this.depth > this.max) {
                this.max = this.depth;
            }
        }

        void ends(String log) {
            if (this.depth < 0) {
                throw new RuntimeException("Invalid call to ends (missing corresponding starts call)!");
            }
            this.buffers[this.depth].append(log);
            if (this.depth > 0) {
                int n = this.depth;
                this.times[n] = this.times[n] + (System.currentTimeMillis() - this.starts[this.depth]);
                --this.depth;
                return;
            }
            int i = 0;
            while (i < this.max) {
                this.print(this.buffers[i].toString());
                this.print(" ( in ");
                this.print(this.times[this.depth]);
                this.println("ms)");
                ++i;
            }
            this.max = -1;
            this.depth = -1;
            this.starts = new long[10];
            this.times = new long[10];
            this.buffers = new StringBuffer[10];
        }

        public String toString() {
            return LOG_STR_WRITER.toString();
        }
    }
}

