/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.violation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jdt.core.Signature;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.api.ClassAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPIEmitter;
import org.eclipse.wtp.releng.tools.component.api.FieldAPI;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;
import org.eclipse.wtp.releng.tools.component.api.violation.ClassViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.ComponentAPIViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.FieldViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.MethodViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.ParamViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.ReturnViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.SuperViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.ThrowViolation;
import org.eclipse.wtp.releng.tools.component.internal.AbstractEmitter;
import org.eclipse.wtp.releng.tools.component.internal.ComponentEntry;
import org.eclipse.wtp.releng.tools.component.internal.ComponentSummary;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Type;
import org.xml.sax.SAXException;

public class ComponentAPIViolationEmitter
extends AbstractEmitter {
    private List compXMLDirs;
    private List compXMLRefDirs;
    private List eclipseDirs;
    private List includes;
    private List excludes;
    private String outputDir;
    private Map compLoc2CompXML;
    private Map compLoc2CompRef;
    private Map pluginId2Plugin;
    private Map fragmentId2Fragment;

    public ComponentAPIViolationEmitter(List compXMLDirs, List compXMLRefDirs, List eclipseDirs, List includes, List excludes, String outputDir) {
        this.compXMLDirs = compXMLDirs;
        this.compXMLRefDirs = compXMLRefDirs;
        this.eclipseDirs = eclipseDirs;
        this.includes = includes;
        this.excludes = excludes;
        this.outputDir = this.addTrailingSeperator(outputDir);
    }

    public void genAPIViolations() throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        this.compLoc2CompXML = new HashMap();
        this.compLoc2CompRef = new HashMap();
        this.pluginId2Plugin = new HashMap();
        this.fragmentId2Fragment = new HashMap();
        Iterator it = this.eclipseDirs.iterator();
        while (it.hasNext()) {
            File eclipseFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!eclipseFile.exists()) continue;
            this.harvestPlugins(eclipseFile, this.pluginId2Plugin, this.fragmentId2Fragment);
        }
        this.linkPluginsAndFragments(this.pluginId2Plugin, this.fragmentId2Fragment);
        it = this.compXMLDirs.iterator();
        while (it.hasNext()) {
            File compXMLFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!compXMLFile.exists()) continue;
            this.harvestComponents(compXMLFile, this.compLoc2CompXML);
        }
        this.compLoc2CompRef.putAll(this.compLoc2CompXML);
        if (this.compXMLRefDirs != null) {
            it = this.compXMLRefDirs.iterator();
            while (it.hasNext()) {
                File compXMLRefFile = new File(this.addTrailingSeperator((String)it.next()));
                if (!compXMLRefFile.exists()) continue;
                this.harvestComponents(compXMLRefFile, this.compLoc2CompRef);
            }
        }
        ComponentSummary summary = new ComponentSummary();
        Iterator it2 = this.compLoc2CompXML.keySet().iterator();
        while (it2.hasNext()) {
            String compLoc = (String)it2.next();
            ComponentAPIEmitter compAPIEmitter = new ComponentAPIEmitter(null);
            compAPIEmitter.init(this.compLoc2CompXML, this.pluginId2Plugin, this.fragmentId2Fragment);
            ComponentAPI compAPI = compAPIEmitter.genComponentApiXml(compLoc);
            ComponentAPIViolation v = this.genAPIViolation(compAPI);
            String compName = compAPI.getName();
            StringBuffer sb = new StringBuffer(this.outputDir);
            sb.append(compName);
            sb.append("/component-api-violation.xml");
            File file = new File(sb.toString());
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(v.toString().getBytes());
            fos.close();
            ComponentEntry entry = new ComponentEntry();
            entry.setCompName(compName);
            sb = new StringBuffer("./");
            sb.append(compName);
            sb.append("/component-api-violation.xml");
            entry.setRef(sb.toString());
            summary.add(entry);
        }
        summary.save(new FileLocation(new File(String.valueOf(this.outputDir) + "component-api-violation-all.xml")));
        this.xslt(summary.toString(), "org/eclipse/wtp/releng/tools/component/xsl/component-api-violation.xsl", String.valueOf(this.outputDir) + "component-api-violation-all.html");
    }

    private void xslt(String content, String xsl, String output) throws SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException, FileNotFoundException {
        File outputFile = new File(output);
        outputFile.getParentFile().mkdirs();
        this.xslt(new ByteArrayInputStream(content.getBytes()), xsl, new FileOutputStream(outputFile));
    }

    private void xslt(InputStream is, String xsl, OutputStream os) throws SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException, FileNotFoundException {
        String user_dir = "user.dir";
        String currUserDir = System.getProperty(user_dir);
        System.setProperty(user_dir, this.outputDir);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(ClassLoader.getSystemResourceAsStream(xsl)));
        transformer.transform(new StreamSource(is), new StreamResult(os));
        System.setProperty(user_dir, currUserDir);
    }

    private ComponentAPIViolation genAPIViolation(ComponentAPI compAPI) {
        ComponentAPIViolation v = new ComponentAPIViolation();
        v.setName(compAPI.getName());
        Iterator it = compAPI.getPackageAPIs().iterator();
        while (it.hasNext()) {
            v.addAllViolations(this.genAPIViolation((PackageAPI)it.next()));
        }
        return v;
    }

    private List genAPIViolation(PackageAPI pkgAPI) {
        ArrayList<ClassViolation> classViolations = new ArrayList<ClassViolation>();
        Iterator it = pkgAPI.getClassAPIs().iterator();
        while (it.hasNext()) {
            ClassViolation classViolation = this.genAPIViolation((ClassAPI)it.next());
            if (classViolation == null) continue;
            classViolations.add(classViolation);
        }
        return classViolations;
    }

    private ClassViolation genAPIViolation(ClassAPI classAPI) {
        ClassViolation classViolation = new ClassViolation();
        classViolation.setName(classAPI.getName());
        String superClassName = classAPI.getSuperClass();
        boolean isSuperClassAPI = this.checkAccess(classAPI.getAccess(), 512) ? this.isAPI(superClassName, false, false, true, false) : this.isAPI(superClassName, false, true, false, false);
        if (!isSuperClassAPI) {
            SuperViolation superViolation = new SuperViolation();
            superViolation.setName(superClassName);
            classViolation.addViolation(superViolation);
        }
        Iterator it = classAPI.getMethodAPIs().iterator();
        while (it.hasNext()) {
            MethodAPI methodAPI = (MethodAPI)it.next();
            MethodViolation methodViolation = new MethodViolation();
            methodViolation.setName(methodAPI.getName());
            String desc = methodAPI.getDescriptor();
            String returnTypeDesc = Signature.getReturnType((String)desc);
            String returnType = this.toFullyQualifiedName(returnTypeDesc);
            if (Signature.getTypeSignatureKind((String)returnTypeDesc) != 2 && !this.isAPI(returnType, true, false, false, false)) {
                ReturnViolation returnViolation = new ReturnViolation();
                returnViolation.setName(returnType);
                methodViolation.addViolation(returnViolation);
            }
            String[] params = Signature.getParameterTypes((String)desc);
            int j = 0;
            while (j < params.length) {
                String param = this.toFullyQualifiedName(params[j]);
                if (Signature.getTypeSignatureKind((String)params[j]) != 2 && !this.isAPI(param, true, false, false, false)) {
                    ParamViolation paramViolation = new ParamViolation();
                    paramViolation.setName(param);
                    methodViolation.addViolation(paramViolation);
                }
                ++j;
            }
            String[] throwTypes = Signature.getThrownExceptionTypes((String)desc);
            int j2 = 0;
            while (j2 < throwTypes.length) {
                String throwType = this.toFullyQualifiedName(throwTypes[j2]);
                if (Signature.getTypeSignatureKind((String)throwTypes[j2]) != 2 && !this.isAPI(throwType, true, false, false, false)) {
                    ThrowViolation throwViolation = new ThrowViolation();
                    throwViolation.setName(throwType);
                    methodViolation.addViolation(throwViolation);
                }
                ++j2;
            }
            if (methodViolation.countViolations() <= 0) continue;
            classViolation.addViolation(methodViolation);
        }
        it = classAPI.getFieldAPIs().iterator();
        while (it.hasNext()) {
            FieldAPI fieldAPI = (FieldAPI)it.next();
            String desc = new String(fieldAPI.getDescriptor());
            String field = this.toFullyQualifiedName(desc);
            if (Signature.getTypeSignatureKind((String)desc) == 2 || this.isAPI(field, true, false, false, false)) continue;
            FieldViolation fieldViolation = new FieldViolation();
            fieldViolation.setName(fieldAPI.getName());
            fieldViolation.setType(field);
            classViolation.addViolation(fieldViolation);
        }
        if (classViolation.countViolations() > 0) {
            return classViolation;
        }
        return null;
    }

    private String toFullyQualifiedName(String descriptor) {
        StringBuffer sb = new StringBuffer();
        descriptor = descriptor.replace('/', '.');
        sb.append(Signature.getSignatureQualifier((String)descriptor));
        sb.append('.');
        sb.append(Signature.getSignatureSimpleName((String)descriptor).replace('.', '$'));
        return sb.toString();
    }

    private boolean checkAccess(int flag, int bit) {
        return (flag & bit) == bit;
    }

    private boolean isAPI(String className, boolean ref, boolean subclass, boolean implement, boolean instantiate) {
        if (this.include(className)) {
            String pkgName = null;
            String typeName = null;
            int dot = className.lastIndexOf(46);
            if (dot != -1) {
                pkgName = className.substring(0, dot);
                typeName = className.substring(dot + 1);
            }
            if (pkgName != null && typeName != null) {
                Iterator it = this.compLoc2CompRef.values().iterator();
                while (it.hasNext()) {
                    ComponentXML compXML = (ComponentXML)it.next();
                    Iterator pkgIt = compXML.getPackages().iterator();
                    while (pkgIt.hasNext()) {
                        Package pkg = (Package)pkgIt.next();
                        if (!pkgName.equals(pkg.getName())) continue;
                        int index = typeName.indexOf(36);
                        String baseTypeName = index != -1 ? typeName.substring(0, index) : null;
                        Type baseType = null;
                        Iterator typeIt = pkg.getTypes().iterator();
                        while (typeIt.hasNext()) {
                            Type type = (Type)typeIt.next();
                            String name = type.getName();
                            if (typeName.equals(name)) {
                                if (ref && !type.isReference()) {
                                    return false;
                                }
                                if (subclass && !type.isSubclass()) {
                                    return false;
                                }
                                if (implement && !type.isImplement()) {
                                    return false;
                                }
                                return !instantiate || type.isInstantiate();
                            }
                            if (baseTypeName == null || baseType != null || !baseTypeName.equals(name)) continue;
                            baseType = type;
                        }
                        if (baseType != null) {
                            if (ref && !baseType.isReference()) {
                                return false;
                            }
                            if (subclass && !baseType.isSubclass()) {
                                return false;
                            }
                            if (implement && !baseType.isImplement()) {
                                return false;
                            }
                            return !instantiate || baseType.isInstantiate();
                        }
                        return pkg.isApi();
                    }
                }
            }
            return false;
        }
        return true;
    }

    private boolean include(String className) {
        Iterator it;
        if (this.excludes != null) {
            it = this.excludes.iterator();
            while (it.hasNext()) {
                if (!className.startsWith((String)it.next())) continue;
                return false;
            }
        }
        if (this.includes != null && this.includes.size() > 0) {
            it = this.includes.iterator();
            while (it.hasNext()) {
                if (!className.startsWith((String)it.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        List compXMLDirs = (List)options.get("compXMLDirs");
        List compXMLRefDirs = (List)options.get("compXMLRefDirs");
        List eclipseDirs = (List)options.get("eclipseDirs");
        List outputDir = (List)options.get("outputDir");
        List includes = (List)options.get("includes");
        List excludes = (List)options.get("excludes");
        if (compXMLDirs == null || eclipseDirs == null || outputDir == null || compXMLDirs.size() < 1 || eclipseDirs.size() < 1 || outputDir.size() < 1) {
            ComponentAPIViolationEmitter.printUsage();
            System.exit(-1);
        }
        ComponentAPIViolationEmitter emitter = new ComponentAPIViolationEmitter(compXMLDirs, compXMLRefDirs, eclipseDirs, includes, excludes, (String)outputDir.get(0));
        try {
            emitter.genAPIViolations();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.api.violation.APIViolationEmitter -compXMLDirs <compXMLDirs> -eclipseDirs <eclipseDirs> -outputDir <outputDir> [-options]");
        System.out.println("");
        System.out.println("\t-compXMLDirs\t<compXMLDirs>\tspace seperated list of directories containing component.xml files");
        System.out.println("\t-eclipseDirs\t<eclipseDirs>\tspace seperated list of directories containing Eclipse plugins");
        System.out.println("\t-outputDir\t<outputDir>\toutput directory");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-compXMLRefDirs\t<compXMLRefDirs>\tspace seperated list of directories containing component.xml files being referenced");
        System.out.println("\t-includes\t<includes>\tpackages to include");
        System.out.println("\t-excludes\t<excludes>\tpackages to exclude");
    }
}

