/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jst.jsf.common.internal.locator.ILocatorProvider;
import org.eclipse.jst.jsf.core.internal.tld.IFaceletConstants;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.AbstractFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.DefaultStandardTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IProjectTaglibDescriptor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.Listener;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagRecordFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTaglibDescriptor
implements IProjectTaglibDescriptor {
    private final AtomicInteger _isInitialized = new AtomicInteger(0);
    private final IProject _project;
    private final ILocatorProvider<AbstractFaceletTaglibLocator> _locatorProvider;
    private final MyChangeListener _libChangeListener;
    private final Map<String, IFaceletTagRecord> _tagRecords;
    private final TagRecordFactory _factory;
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);
    private final DefaultStandardTaglibLocator _defaultTaglibLocator;

    public ProjectTaglibDescriptor(IProject project, TagRecordFactory factory, ILocatorProvider<AbstractFaceletTaglibLocator> locatorProvider) {
        this._project = project;
        this._tagRecords = new HashMap<String, IFaceletTagRecord>();
        this._locatorProvider = locatorProvider;
        this._locatorProvider.initialize();
        this._factory = factory;
        this._libChangeListener = new MyChangeListener();
        this._defaultTaglibLocator = new DefaultStandardTaglibLocator();
        this._defaultTaglibLocator.start(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this._isInitialized.addAndGet(1) == 1) {
            ProjectTaglibDescriptor projectTaglibDescriptor = this;
            synchronized (projectTaglibDescriptor) {
                for (final AbstractFaceletTaglibLocator locator : this._locatorProvider.getLocators()) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            FaceletCorePlugin.log("While locating facelet libraries on project: " + ProjectTaglibDescriptor.this._project.getName(), new Exception(exception));
                        }

                        public void run() throws Exception {
                            locator.addListener(ProjectTaglibDescriptor.this._libChangeListener);
                            locator.start(ProjectTaglibDescriptor.this._project);
                            ProjectTaglibDescriptor.this._tagRecords.putAll((Map)locator.locate(ProjectTaglibDescriptor.this._project));
                        }
                    });
                }
                this.ensureStandardLibraries(this._project);
            }
        }
    }

    private void ensureStandardLibraries(IProject project) {
        Map defaultRecords = (Map)this._defaultTaglibLocator.locate(project);
        for (String uri : IFaceletConstants.ALL_FACELET_TAGLIBS) {
            if (this._tagRecords.containsKey(uri)) continue;
            IFaceletTagRecord faceletTagRecord = (IFaceletTagRecord)defaultRecords.get(uri);
            if (faceletTagRecord != null) {
                this._tagRecords.put(uri, faceletTagRecord);
                continue;
            }
            FaceletCorePlugin.log("Could not find taglib for uri: " + uri, new Exception());
        }
    }

    @Override
    public Collection<? extends IFaceletTagRecord> getTagLibraries() {
        this.initialize();
        return Collections.unmodifiableCollection(this._tagRecords.values());
    }

    void maybeLog(Exception e) {
        if (this._isInitialized.get() <= 1) {
            FaceletCorePlugin.log("Failed initializing taglib descriptor", e);
        }
    }

    @Override
    public IFaceletTagRecord getTagLibrary(String uri) {
        this.initialize();
        return this._tagRecords.get(uri);
    }

    @Override
    public void addListener(Listener listener) {
        for (AbstractFaceletTaglibLocator locator : this._locatorProvider.getLocators()) {
            locator.addListener(listener);
        }
    }

    @Override
    public void removeListener(Listener listener) {
        for (AbstractFaceletTaglibLocator locator : this._locatorProvider.getLocators()) {
            locator.removeListener(listener);
        }
    }

    public void checkpoint() {
    }

    public void destroy() {
        this.dispose();
    }

    public void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            for (AbstractFaceletTaglibLocator locator : this._locatorProvider.getLocators()) {
                locator.stop();
            }
            this._factory.dispose();
        }
    }

    public boolean isDisposed() {
        return this._isDisposed.get();
    }

    private class MyChangeListener
    extends Listener {
        private MyChangeListener() {
        }

        public void changed(Listener.TaglibChangedEvent event) {
            switch (event.getChangeType()) {
                case ADDED: {
                    ProjectTaglibDescriptor.this._tagRecords.put(event.getNewValue().getURI(), event.getNewValue());
                    break;
                }
                case CHANGED: {
                    ProjectTaglibDescriptor.this._tagRecords.put(event.getNewValue().getURI(), event.getNewValue());
                    break;
                }
                case REMOVED: {
                    ProjectTaglibDescriptor.this._tagRecords.remove(event.getOldValue());
                }
            }
        }
    }
}

