/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.wizards;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.SWTUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.ISummaryDataSource;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.WizardsResources;

public class WizardSummaryPage
extends WizardPage {
    private static WizardsResources resource = WizardsResources.getInstance();
    private static final String WIZARD_SUMMARY_PAGE = "WizardSummaryPage";
    private ISummaryDataSource source;
    private Table table;

    public WizardSummaryPage() {
        super(WIZARD_SUMMARY_PAGE);
        this.setTitle(resource.getString("WizardSummaryPage.Title.WizardSummary"));
        this.setDescription(resource.getString("WizardSummaryPage.Summary.SummaryDesc"));
    }

    public WizardSummaryPage(ISummaryDataSource source) {
        this();
        this.source = source;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTUtils.createComposite((Composite)parent, (int)1);
        this.table = new Table(composite, 2048);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(163));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(350));
        TableColumn keyCol = new TableColumn(this.table, 0);
        keyCol.setText(resource.getString("WizardSummaryPage.Label.Field"));
        TableColumn valueCol = new TableColumn(this.table, 0);
        valueCol.setText(resource.getString("WizardSummaryPage.Label.Value"));
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public void loadSummaryData() {
        if (this.source == null) {
            return;
        }
        Object[] data = this.source.getSummaryData().toArray();
        this.table.removeAll();
        int i = 0;
        while (i < data.length) {
            TableItem item = new TableItem(this.table, 0);
            item.setText((String[])data[i]);
            ++i;
        }
    }

    public void setSummaryDataSource(ISummaryDataSource s) {
        this.source = s;
    }

    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            this.loadSummaryData();
        }
    }
}

